/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.Function;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.FunctionCallException;
import com.nedap.archie.rules.evaluation.FunctionImplementation;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.functions.Ceil;
import com.nedap.archie.rules.evaluation.evaluators.functions.FlatSum;
import com.nedap.archie.rules.evaluation.evaluators.functions.Floor;
import com.nedap.archie.rules.evaluation.evaluators.functions.Max;
import com.nedap.archie.rules.evaluation.evaluators.functions.Mean;
import com.nedap.archie.rules.evaluation.evaluators.functions.Min;
import com.nedap.archie.rules.evaluation.evaluators.functions.Round;
import com.nedap.archie.rules.evaluation.evaluators.functions.Sum;
import com.nedap.archie.rules.evaluation.evaluators.functions.ValueWhenUndefined;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FunctionEvaluator
implements Evaluator<Function> {
    private Map<String, FunctionImplementation> functions = new LinkedHashMap<String, FunctionImplementation>();

    public void registerFunction(FunctionImplementation function) {
        this.functions.put(function.getName(), function);
    }

    public FunctionEvaluator() {
        this.registerFunction(new Max());
        this.registerFunction(new Min());
        this.registerFunction(new Mean());
        this.registerFunction(new Sum());
        this.registerFunction(new FlatSum());
        this.registerFunction(new ValueWhenUndefined());
        this.registerFunction(new Round());
        this.registerFunction(new Ceil());
        this.registerFunction(new Floor());
    }

    @Override
    public ValueList evaluate(RuleEvaluation evaluation, Function function) {
        ArrayList<ValueList> argumentResults = new ArrayList<ValueList>();
        for (Expression argument : function.getArguments()) {
            argumentResults.add(evaluation.evaluate((RuleElement)argument));
        }
        FunctionImplementation functionImplementation = this.functions.get(function.getFunctionName());
        if (functionImplementation != null) {
            try {
                return functionImplementation.evaluate(argumentResults);
            }
            catch (FunctionCallException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("unknown function: " + function.getFunctionName());
    }

    @Override
    public List<Class> getSupportedClasses() {
        return Lists.newArrayList((Object[])new Class[]{Function.class});
    }
}

