/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.BinaryOperatorEvaluator;
import java.util.List;

public class BinaryBooleanOperandEvaluator {
    BinaryOperatorEvaluator mainEvaluator;

    public BinaryBooleanOperandEvaluator(BinaryOperatorEvaluator mainEvaluator) {
        this.mainEvaluator = mainEvaluator;
    }

    protected Value evaluateMultipleValuesBooleanRelOp(BinaryOperator statement, ValueList leftValues, ValueList rightValues) {
        for (Value leftValue : leftValues.getValues()) {
            for (Value rightValue : rightValues.getValues()) {
                Value evaluatedRelOp = this.evaluateBooleanRelOp(statement, leftValue.getValue(), rightValue.getValue(), this.mainEvaluator.getPaths(leftValue, rightValue));
                if (!((Boolean)evaluatedRelOp.getValue()).booleanValue()) continue;
                return evaluatedRelOp;
            }
        }
        return new Value<Boolean>(false, this.mainEvaluator.getAllPaths(leftValues, rightValues));
    }

    private Value evaluateBooleanRelOp(BinaryOperator statement, Object leftValue, Object rightValue, List<String> paths) {
        if (leftValue == null || rightValue == null) {
            return new Value<Boolean>(this.mainEvaluator.evaluateNullRelOp(statement.getOperator(), leftValue, rightValue), paths);
        }
        if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
            return new Value<Object>(this.evaluateBooleanRelOp(statement.getOperator(), (Boolean)leftValue, (Boolean)rightValue), paths);
        }
        throw new IllegalStateException("operand types not both Boolean: " + leftValue.getClass().getSimpleName() + " and " + rightValue.getClass().getSimpleName());
    }

    private Object evaluateBooleanRelOp(OperatorKind operator, boolean leftValue, boolean rightValue) {
        switch (operator) {
            case eq: {
                return leftValue == rightValue;
            }
            case ne: {
                return leftValue != rightValue;
            }
        }
        throw new IllegalArgumentException("Not a boolean operator with boolean operands: " + operator);
    }
}

