/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.evaluation.AssertionResult;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.VariableMap;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FixableAssertionsChecker {
    private static Logger logger = LoggerFactory.getLogger(FixableAssertionsChecker.class);
    private ArrayListMultimap<RuleElement, ValueList> ruleElementValues;
    private VariableMap forAllVariables;

    protected FixableAssertionsChecker(ArrayListMultimap<RuleElement, ValueList> ruleElementValues) {
        this.ruleElementValues = ruleElementValues;
        this.forAllVariables = new VariableMap();
    }

    protected void checkAssertionForFixablePatterns(AssertionResult assertionResult, Expression expression, int index) {
        if (expression instanceof ForAllStatement) {
            this.handleForAll(assertionResult, expression);
        } else if (expression instanceof BinaryOperator) {
            ValueList expressionResult = (ValueList)this.ruleElementValues.get((Object)expression).get(index);
            BinaryOperator binaryExpression = (BinaryOperator)expression;
            if (binaryExpression.getOperator() == OperatorKind.eq && binaryExpression.getLeftOperand() instanceof ModelReference) {
                this.handlePathEquals(assertionResult, expressionResult, binaryExpression, index);
            } else if (binaryExpression.getOperator() == OperatorKind.implies) {
                this.handleImplies(assertionResult, index, binaryExpression);
            } else if (binaryExpression.getOperator() == OperatorKind.matches) {
                this.handleMatches(assertionResult, index, binaryExpression);
            } else if (binaryExpression.getOperator() == OperatorKind.and) {
                this.checkAssertionForFixablePatterns(assertionResult, binaryExpression.getLeftOperand(), index);
                this.checkAssertionForFixablePatterns(assertionResult, binaryExpression.getRightOperand(), index);
            }
        } else if (expression instanceof UnaryOperator) {
            UnaryOperator unaryOperator = (UnaryOperator)expression;
            if (unaryOperator.getOperator() == OperatorKind.not) {
                this.handleNot(assertionResult, unaryOperator, index);
            }
            if (unaryOperator.getOperator() == OperatorKind.exists && unaryOperator.getOperand() instanceof ModelReference) {
                assertionResult.addPathThatMustExist(this.resolveModelReference((ModelReference)unaryOperator.getOperand()));
            }
        }
    }

    private void handleNot(AssertionResult assertionResult, UnaryOperator unaryOperator, int index) {
        UnaryOperator existsOperator;
        Expression operand = unaryOperator.getOperand();
        if (operand instanceof UnaryOperator && ((UnaryOperator)operand).getOperator() == OperatorKind.exists && (existsOperator = (UnaryOperator)operand).getOperand() instanceof ModelReference) {
            List valueLists = this.ruleElementValues.get((Object)existsOperator);
            ValueList list = (ValueList)valueLists.get(index);
            if (list.getSingleBooleanResult()) {
                assertionResult.addPathsThatMustNotExist(this.resolveModelReferenceNonNull((ModelReference)existsOperator.getOperand(), index));
            } else {
                assertionResult.addPathThatMustNotExist(this.resolveModelReference((ModelReference)existsOperator.getOperand()));
            }
        }
    }

    private void handleImplies(AssertionResult assertionResult, int index, BinaryOperator binaryExpression) {
        boolean shouldEvaluate;
        ValueList leftOperandResult = (ValueList)this.ruleElementValues.get((Object)binaryExpression.getLeftOperand()).get(index);
        if (!leftOperandResult.isEmpty() && (shouldEvaluate = leftOperandResult.getSingleBooleanResult())) {
            this.checkAssertionForFixablePatterns(assertionResult, binaryExpression.getRightOperand(), index);
        }
    }

    private void handlePathEquals(AssertionResult assertionResult, ValueList expressionResult, BinaryOperator binaryExpression, int index) {
        ValueList valueList = (ValueList)this.ruleElementValues.get((Object)binaryExpression.getRightOperand()).get(index);
        ModelReference pathToSet = (ModelReference)binaryExpression.getLeftOperand();
        this.setPathsToValues(assertionResult, this.resolveModelReference(pathToSet), valueList);
    }

    private void handleMatches(AssertionResult assertionResult, int index, BinaryOperator binaryExpression) {
        Expression rightOperand = binaryExpression.getRightOperand();
        ModelReference pathToSet = (ModelReference)binaryExpression.getLeftOperand();
        if (rightOperand instanceof Constraint) {
            Constraint c = (Constraint)rightOperand;
            CPrimitiveObject object = c.getItem();
            List constraints = object.getConstraint();
            if (constraints.size() != 1) {
                return;
            }
            ValueList valueList = new ValueList();
            switch (object.getClass().getSimpleName()) {
                case "CTerminologyCode": {
                    String constraint = (String)constraints.get(0);
                    valueList.addValue(constraint, Collections.emptyList());
                    String path = this.resolveModelReference(pathToSet);
                    if (path.endsWith("symbol")) {
                        path = path + "/defining_code/code_string";
                    } else if (path.endsWith("defining_code")) {
                        path = path + "/code_string";
                    }
                    this.setPathsToValues(assertionResult, path, valueList);
                    break;
                }
                case "CString": {
                    String constraint = (String)constraints.get(0);
                    valueList.addValue(constraint, Collections.emptyList());
                    this.setPathsToValues(assertionResult, this.resolveModelReference(pathToSet), valueList);
                }
            }
        }
    }

    private void handleForAll(AssertionResult assertionResult, Expression expression) {
        ForAllStatement forAllStatement = (ForAllStatement)expression;
        List valueLists = this.ruleElementValues.get((Object)forAllStatement.getAssertion());
        int i = 0;
        ValueList pathExpressionValues = (ValueList)this.ruleElementValues.get((Object)forAllStatement.getPathExpression()).get(0);
        for (ValueList valueList : valueLists) {
            Value value = pathExpressionValues.get(i);
            Object context = value.getValue();
            String path = value.getPaths().get(0);
            RMObjectWithPath rmObjectWithPath = new RMObjectWithPath(context, path);
            ValueList variableValue = new ValueList(rmObjectWithPath);
            variableValue.setType(PrimitiveType.ObjectReference);
            this.forAllVariables.put(forAllStatement.getVariableName(), variableValue);
            this.checkAssertionForFixablePatterns(assertionResult, forAllStatement.getRightOperand(), i);
            ++i;
        }
        this.forAllVariables.put(forAllStatement.getVariableName(), null);
    }

    private String resolveModelReference(ModelReference statement) {
        String variable = statement.getVariableReferencePrefix();
        String pathPrefix = "";
        if (variable != null) {
            ValueList value = this.forAllVariables.get(variable);
            if (value.size() > 1) {
                throw new IllegalStateException("");
            }
            if (value.size() == 1) {
                if (value.getType() == PrimitiveType.ObjectReference) {
                    RMObjectWithPath reference = (RMObjectWithPath)value.get(0).getValue();
                    pathPrefix = reference.getPath();
                } else {
                    if (value.get(0).getPaths().size() > 1) {
                        throw new IllegalStateException("");
                    }
                    pathPrefix = value.get(0).getPaths().get(0);
                }
            }
        }
        return pathPrefix + statement.getPath();
    }

    private List<String> resolveModelReferenceNonNull(ModelReference statement, int index) {
        List values = this.ruleElementValues.get((Object)statement);
        if (index > values.size()) {
            return Collections.EMPTY_LIST;
        }
        ValueList valueList = (ValueList)values.get(index);
        return valueList.getAllPaths();
    }

    private void setPathsToValues(AssertionResult assertionResult, String path, ValueList value) {
        logger.debug("path {} set to value {} ", (Object)path, (Object)value);
        assertionResult.setSetPathValue(path, value);
    }
}

