/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator.validations;

import com.google.common.collect.Lists;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RMMultiplicityValidation {
    public static List<RMObjectValidationMessage> validate(CAttribute attribute, String pathSoFar, Object attributeValue) {
        if (attributeValue instanceof Collection) {
            Collection collectionValue = (Collection)attributeValue;
            Cardinality cardinality = attribute.getCardinality();
            if (cardinality != null && !cardinality.getInterval().has((Object)collectionValue.size())) {
                String message = RMObjectValidationMessageIds.rm_CARDINALITY_MISMATCH.getMessage(new Object[]{cardinality.getInterval().toString()});
                return Lists.newArrayList((Object[])new RMObjectValidationMessage[]{new RMObjectValidationMessage((ArchetypeConstraint)attribute, pathSoFar, message)});
            }
        } else {
            MultiplicityInterval existence = attribute.getExistence();
            if (existence != null && !existence.has((Object)(attributeValue == null ? 0 : 1))) {
                String message = RMObjectValidationMessageIds.rm_EXISTENCE_MISMATCH.getMessage(new Object[]{attribute.getRmAttributeName(), attribute.getParent() == null ? "Unknown type" : attribute.getParent().getRmTypeName(), existence.toString()});
                return Lists.newArrayList((Object[])new RMObjectValidationMessage[]{new RMObjectValidationMessage((ArchetypeConstraint)attribute, pathSoFar, message, RMObjectValidationMessageType.REQUIRED)});
            }
        }
        return new ArrayList<RMObjectValidationMessage>();
    }
}

