/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator;

import com.google.common.collect.Lists;
import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import com.nedap.archie.rmobjectvalidator.APathQueryCache;
import com.nedap.archie.rmobjectvalidator.RMObjectValidatingProcessor;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageType;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationUtil;
import com.nedap.archie.rmobjectvalidator.validations.RMMultiplicityValidation;
import com.nedap.archie.rmobjectvalidator.validations.RMOccurrenceValidation;
import com.nedap.archie.rmobjectvalidator.validations.RMPrimitiveObjectValidation;
import com.nedap.archie.rmobjectvalidator.validations.RMTupleValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RMObjectValidator
extends RMObjectValidatingProcessor {
    private final MetaModel metaModel;
    private APathQueryCache queryCache = new APathQueryCache();
    private ModelInfoLookup lookup;
    private ReflectionConstraintImposer constraintImposer;

    public RMObjectValidator(ModelInfoLookup lookup) {
        this.lookup = lookup;
        this.metaModel = new MetaModel(lookup, null);
        this.constraintImposer = new ReflectionConstraintImposer(lookup);
    }

    public List<RMObjectValidationMessage> validate(Archetype archetype, Object rmObject) {
        this.clearMessages();
        ArrayList objects = Lists.newArrayList((Object[])new RMObjectWithPath[]{new RMObjectWithPath(rmObject, "")});
        this.addAllMessages(this.runArchetypeValidations(objects, "", (CObject)archetype.getDefinition()));
        return this.getMessages();
    }

    public List<RMObjectValidationMessage> validate(Object rmObject) {
        this.clearMessages();
        ArrayList objects = Lists.newArrayList((Object[])new RMObjectWithPath[]{new RMObjectWithPath(rmObject, "")});
        this.addAllMessages(this.runArchetypeValidations(objects, "", null));
        return this.getMessages();
    }

    private List<RMObjectValidationMessage> runArchetypeValidations(List<RMObjectWithPath> rmObjects, String path, CObject cobject) {
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>(RMOccurrenceValidation.validate(this.metaModel, rmObjects, path, cobject));
        if (rmObjects.isEmpty()) {
            return result;
        }
        if (cobject == null) {
            for (RMObjectWithPath objectWithPath : rmObjects) {
                this.validateObjectWithPath(result, cobject, path, objectWithPath);
            }
        } else if (cobject instanceof CPrimitiveObject) {
            result.addAll(RMPrimitiveObjectValidation.validate(this.lookup, rmObjects, path, (CPrimitiveObject)cobject));
        } else {
            if (cobject instanceof CComplexObject) {
                CComplexObject cComplexObject = (CComplexObject)cobject;
                for (CAttributeTuple tuple : cComplexObject.getAttributeTuples()) {
                    result.addAll(RMTupleValidation.validate(this.lookup, cobject, path, rmObjects, tuple));
                }
            }
            for (RMObjectWithPath objectWithPath : rmObjects) {
                this.validateObjectWithPath(result, cobject, path, objectWithPath);
            }
        }
        return result;
    }

    private void validateObjectWithPath(List<RMObjectValidationMessage> result, CObject cobject, String path, RMObjectWithPath objectWithPath) {
        if (cobject == null) {
            RMTypeInfo typeInfo;
            Object rmObject = objectWithPath.getObject();
            if (rmObject != null && (typeInfo = this.lookup.getTypeInfo(rmObject.getClass())) != null) {
                List<CAttribute> defaultAttributes = RMObjectValidationUtil.getDefaultAttributeConstraints(typeInfo.getRmName(), (List<CAttribute>)Lists.newArrayList(), this.lookup, (ModelConstraintImposer)this.constraintImposer);
                this.validateCAttributes(result, path, objectWithPath, rmObject, null, defaultAttributes);
            }
        } else {
            Class classInConstraint = this.lookup.getClass(cobject.getRmTypeName());
            if (!classInConstraint.isAssignableFrom(objectWithPath.getObject().getClass())) {
                result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, objectWithPath.getPath(), RMObjectValidationMessageIds.rm_INCORRECT_TYPE.getMessage(new Object[]{cobject.getRmTypeName(), objectWithPath.getObject().getClass().getSimpleName()}), RMObjectValidationMessageType.WRONG_TYPE));
            } else {
                Object rmObject = objectWithPath.getObject();
                ArrayList<CAttribute> attributes = new ArrayList<CAttribute>(cobject.getAttributes());
                attributes.addAll(RMObjectValidationUtil.getDefaultAttributeConstraints(cobject, attributes, this.lookup, (ModelConstraintImposer)this.constraintImposer));
                this.validateCAttributes(result, path, objectWithPath, rmObject, cobject, attributes);
            }
        }
    }

    private void validateCAttributes(List<RMObjectValidationMessage> result, String path, RMObjectWithPath objectWithPath, Object rmObject, CObject cObject, List<CAttribute> attributes) {
        String pathSoFar = RMObjectValidationUtil.stripLastPathSegment(path) + objectWithPath.getPath();
        for (CAttribute attribute : attributes) {
            this.validateAttributes(result, attribute, cObject, rmObject, pathSoFar);
        }
    }

    private void validateAttributes(List<RMObjectValidationMessage> result, CAttribute attribute, CObject cobject, Object rmObject, String pathSoFar) {
        String rmAttributeName = attribute.getRmAttributeName();
        RMPathQuery aPathQuery = this.queryCache.getApathQuery("/" + attribute.getRmAttributeName());
        Object attributeValue = aPathQuery.find(this.lookup, rmObject);
        List<RMObjectValidationMessage> emptyObservationErrors = this.isObservationEmpty(attribute, rmAttributeName, attributeValue, pathSoFar, cobject);
        result.addAll(emptyObservationErrors);
        if (emptyObservationErrors.isEmpty()) {
            result.addAll(RMMultiplicityValidation.validate(attribute, pathSoFar + "/" + rmAttributeName, attributeValue));
            if (attribute.getChildren() == null || attribute.getChildren().isEmpty()) {
                String query = "/" + rmAttributeName;
                aPathQuery = this.queryCache.getApathQuery(query);
                List childRmObjects = aPathQuery.findList(this.lookup, rmObject);
                result.addAll(this.runArchetypeValidations(childRmObjects, pathSoFar + query, null));
            } else if (attribute.isSingle()) {
                this.validateSingleAttribute(result, attribute, rmObject, pathSoFar);
            } else {
                for (CObject childCObject : attribute.getChildren()) {
                    String query = "/" + rmAttributeName + "[" + childCObject.getNodeId() + "]";
                    aPathQuery = this.queryCache.getApathQuery(query);
                    List childRmObjects = aPathQuery.findList(this.lookup, rmObject);
                    result.addAll(this.runArchetypeValidations(childRmObjects, pathSoFar + query, childCObject));
                }
            }
        }
    }

    private void validateSingleAttribute(List<RMObjectValidationMessage> result, CAttribute attribute, Object rmObject, String pathSoFar) {
        block5: {
            ArrayList<List<RMObjectValidationMessage>> subResults = new ArrayList<List<RMObjectValidationMessage>>();
            for (CObject childCObject : attribute.getChildren()) {
                String query = "/" + attribute.getRmAttributeName() + "[" + childCObject.getNodeId() + "]";
                RMPathQuery rMPathQuery = this.queryCache.getApathQuery(query);
                List childNodes = rMPathQuery.findList(this.lookup, rmObject);
                List<RMObjectValidationMessage> subResult = this.runArchetypeValidations(childNodes, pathSoFar + query, childCObject);
                subResults.add(subResult);
            }
            boolean cObjectWithoutErrorsFound = subResults.stream().anyMatch(List::isEmpty);
            boolean atLeastOneWithoutWrongTypeFound = subResults.stream().anyMatch(RMObjectValidationUtil::hasNoneWithWrongType);
            if (cObjectWithoutErrorsFound) break block5;
            if (atLeastOneWithoutWrongTypeFound) {
                for (List list : subResults) {
                    result.addAll(list.stream().filter(message -> message.getType() != RMObjectValidationMessageType.WRONG_TYPE).collect(Collectors.toList()));
                }
            } else {
                for (List list : subResults) {
                    result.addAll(list);
                }
            }
        }
    }

    private List<RMObjectValidationMessage> isObservationEmpty(CAttribute attribute, String rmAttributeName, Object attributeValue, String pathSoFar, CObject cobject) {
        boolean attributeShouldNotBeEmpty;
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
        CObject parent = attribute.getParent();
        boolean parentIsEvent = parent != null && parent.getRmTypeName().contains("EVENT");
        boolean attributeIsData = rmAttributeName.equals("data");
        boolean attributeIsEmpty = attributeValue == null;
        boolean bl = attributeShouldNotBeEmpty = attribute.getExistence() != null && !attribute.getExistence().has((Object)0);
        if (parentIsEvent && attributeIsData && attributeIsEmpty && attributeShouldNotBeEmpty) {
            String message = "Observation " + RMObjectValidationUtil.getParentObservationTerm(attribute) + " contains no results";
            result.add(new RMObjectValidationMessage((ArchetypeConstraint)(cobject == null ? null : cobject.getParent().getParent()), pathSoFar, message, RMObjectValidationMessageType.EMPTY_OBSERVATION));
        }
        return result;
    }
}

