/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator;

import com.nedap.archie.base.Interval;
import java.util.List;
import java.util.Objects;
import org.openehr.utils.message.I18n;

public class ConstraintToStringUtil {
    public static String constraintElementToString(Object element) {
        String result = element instanceof Interval ? ConstraintToStringUtil.intervalToString((Interval)element) : (element instanceof String ? '\"' + ((String)element).replace("\"", "\\\"") + '\"' : element.toString());
        return result;
    }

    private static String intervalToString(Interval<?> interval) {
        String result = interval.isLowerUnbounded() && interval.isUpperUnbounded() ? I18n.t((String)"anything", (Object[])new Object[0]) : (interval.isLowerUnbounded() ? ConstraintToStringUtil.upperBoundToString(interval) : (interval.isUpperUnbounded() ? ConstraintToStringUtil.lowerBoundToString(interval) : (interval.isLowerIncluded() && interval.isUpperIncluded() && Objects.equals(interval.getLower(), interval.getUpper()) ? I18n.t((String)"equal to {0}", (Object[])new Object[]{interval.getLower()}) : I18n.t((String)"{0} and {1}", (Object[])new Object[]{ConstraintToStringUtil.lowerBoundToString(interval), ConstraintToStringUtil.upperBoundToString(interval)}))));
        return result;
    }

    private static String lowerBoundToString(Interval<?> interval) {
        String result = interval.isLowerIncluded() ? I18n.t((String)"at least {0}", (Object[])new Object[]{interval.getLower()}) : I18n.t((String)"greater than {0}", (Object[])new Object[]{interval.getLower()});
        return result;
    }

    private static String upperBoundToString(Interval<?> interval) {
        String result = interval.isUpperIncluded() ? I18n.t((String)"at most {0}", (Object[])new Object[]{interval.getUpper()}) : I18n.t((String)"less than {0}", (Object[])new Object[]{interval.getUpper()});
        return result;
    }

    public static String constraintListToString(List<?> constraint) {
        if (constraint.isEmpty()) {
            return I18n.t((String)"anything", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object constraintElement : constraint) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(" -\t");
            sb.append(ConstraintToStringUtil.constraintElementToString(constraintElement));
        }
        return sb.toString();
    }
}

