/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.nedap.archie.paths.PathSegment;
import java.util.Optional;
import org.w3c.dom.Node;

public class UniqueNodePathBuilder {
    public static String constructPath(Node node) {
        return UniqueNodePathBuilder.constructPathInner(node).toString();
    }

    private static StringBuilder constructPathInner(Node node) {
        Node parent = node.getParentNode();
        if (parent == null || parent.getParentNode() == null) {
            return new StringBuilder("");
        }
        String archetypeNodeId = Optional.ofNullable(node.getAttributes().getNamedItem("archetype_node_id")).map(Node::getNodeValue).orElse(null);
        String pathSegment = new PathSegment(node.getNodeName(), archetypeNodeId, UniqueNodePathBuilder.findNodeIndex(node, parent)).toString();
        return UniqueNodePathBuilder.constructPathInner(parent).append(pathSegment);
    }

    private static Integer findNodeIndex(Node node, Node parent) {
        Integer nodeIndex = null;
        int numberOfFoundNodes = 0;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            if (!parent.getChildNodes().item(i).getNodeName().equals(node.getNodeName())) continue;
            ++numberOfFoundNodes;
            if (parent.getChildNodes().item(i) != node) continue;
            nodeIndex = numberOfFoundNodes;
        }
        if (numberOfFoundNodes <= 1) {
            return null;
        }
        return nodeIndex;
    }
}

