/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.google.common.collect.Sets;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TerminologyFlattener {
    protected static void flattenTerminology(Archetype result, Archetype child) {
        ArchetypeTerminology resultTerminology = result.getTerminology();
        ArchetypeTerminology childTerminology = child.getTerminology();
        TerminologyFlattener.flattenTerminologyDefinitions(resultTerminology.getTermDefinitions(), childTerminology.getTermDefinitions());
        TerminologyFlattener.flattenTerminologyDefinitions(resultTerminology.getTerminologyExtracts(), childTerminology.getTerminologyExtracts());
        TerminologyFlattener.flattenTerminologyDefinitions(resultTerminology.getTermBindings(), childTerminology.getTermBindings());
        resultTerminology.setDifferential(Boolean.valueOf(false));
        Map childValueSets = childTerminology.getValueSets();
        Map resultValueSets = resultTerminology.getValueSets();
        TerminologyFlattener.flattenValueSets(childValueSets, resultValueSets);
    }

    protected static ArchetypeTerm getTerm(Map<String, Map<String, ArchetypeTerm>> termDefinitions, String language, String nodeId) {
        Map<String, ArchetypeTerm> translations = termDefinitions.get(language);
        ArchetypeTerm term = translations.get(nodeId);
        LinkedHashMap<String, ArchetypeTerm> foundTerms = new LinkedHashMap<String, ArchetypeTerm>();
        if (term == null) {
            for (Map.Entry<String, ArchetypeTerm> entry : translations.entrySet()) {
                if (!nodeId.startsWith(entry.getKey() + ".")) continue;
                foundTerms.put(nodeId, entry.getValue());
            }
            ArrayList foundNodeIds = new ArrayList(foundTerms.keySet());
            Collections.sort(foundNodeIds, Comparator.comparingInt(id -> id.length()));
            return (ArchetypeTerm)foundTerms.get(foundNodeIds.get(foundNodeIds.size() - 1));
        }
        return term;
    }

    private static void flattenValueSets(Map<String, ValueSet> childValueSets, Map<String, ValueSet> resultValueSets) {
        for (String key : childValueSets.keySet()) {
            ValueSet childValueSet = childValueSets.get(key);
            ValueSet overriddenValueSet = TerminologyFlattener.findMatchingValueSet(resultValueSets, key);
            if (overriddenValueSet == null) {
                resultValueSets.put(key, childValueSet);
                continue;
            }
            String originalId = overriddenValueSet.getId();
            overriddenValueSet.setId(childValueSet.getId());
            LinkedHashSet<String> newMembers = new LinkedHashSet<String>();
            for (String member : overriddenValueSet.getMembers()) {
                if (!childValueSet.getMembers().contains(member)) continue;
                newMembers.add(member);
            }
            overriddenValueSet.setMembers(newMembers);
            resultValueSets.remove(originalId);
            resultValueSets.put(key, overriddenValueSet);
        }
    }

    private static ValueSet findMatchingValueSet(Map<String, ValueSet> resultValueSets, String specializedId) {
        return resultValueSets.values().stream().filter(valueSet -> AOMUtils.isOverriddenIdCode((String)specializedId, (String)valueSet.getId())).findAny().orElse(null);
    }

    private static <T> void flattenTerminologyDefinitions(Map<String, Map<String, T>> resultTermDefinitions, Map<String, Map<String, T>> childTermDefinitions) {
        for (String language : childTermDefinitions.keySet()) {
            if (!resultTermDefinitions.containsKey(language)) {
                resultTermDefinitions.put(language, childTermDefinitions.get(language));
                continue;
            }
            for (String nodeId : childTermDefinitions.get(language).keySet()) {
                resultTermDefinitions.get(language).put(nodeId, childTermDefinitions.get(language).get(nodeId));
            }
        }
    }

    protected static void filterLanguages(OperationalTemplate result, boolean removeLanguagesFromMetaData, String[] languagesToKeep) {
        if (languagesToKeep != null) {
            HashSet languagesSet = Sets.newHashSet((Object[])languagesToKeep);
            TerminologyFlattener.filterLanguages((Set<String>)languagesSet, result.getTerminology());
            for (ArchetypeTerminology terminology : result.getComponentTerminologies().values()) {
                TerminologyFlattener.filterLanguages((Set<String>)languagesSet, terminology);
            }
            for (ArchetypeTerminology terminology : result.getTerminologyExtracts().values()) {
                TerminologyFlattener.filterLanguages((Set<String>)languagesSet, terminology);
            }
            if (removeLanguagesFromMetaData) {
                if (result.getDescription() != null) {
                    TerminologyFlattener.filterLanguages((Set<String>)languagesSet, result.getDescription().getDetails());
                }
                if (result.getTranslations() != null) {
                    TerminologyFlattener.filterLanguages((Set<String>)languagesSet, result.getTranslations());
                }
            }
        }
    }

    private static void filterLanguages(Set<String> languagesSet, ArchetypeTerminology terminology) {
        TerminologyFlattener.filterLanguages(languagesSet, terminology.getTermDefinitions());
        TerminologyFlattener.filterLanguages(languagesSet, terminology.getTerminologyExtracts());
    }

    private static void filterLanguages(Set<String> languagesSet, Map<String, ?> termDefinitions) {
        if (termDefinitions == null) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : termDefinitions.keySet()) {
            if (languagesSet.contains(key)) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            termDefinitions.remove(key);
        }
    }
}

