/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.google.common.base.Strings;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.RulesSection;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ExpressionVariable;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.Function;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.RuleStatement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.VariableReference;
import java.util.Objects;

public class RulesFlattener {
    public void combineRules(Archetype source, Archetype destination, String variablePrefix, String tagPrefix, String pathPrefix, boolean overWriteTagsWithSameName) {
        if (source.getRules() == null || source.getRules().getRules().isEmpty()) {
            return;
        }
        if (destination.getRules() == null) {
            destination.setRules(new RulesSection());
        }
        for (RuleStatement statement : source.getRules().getRules()) {
            RuleStatement clonedStatement = (RuleStatement)statement.clone();
            this.addVariableAndTagPrefix(clonedStatement, variablePrefix, tagPrefix, pathPrefix);
            if (overWriteTagsWithSameName) {
                if (clonedStatement instanceof Assertion) {
                    this.overWriteStatementWithSameTag(destination, clonedStatement);
                    continue;
                }
                destination.getRules().getRules().add(clonedStatement);
                continue;
            }
            destination.getRules().getRules().add(clonedStatement);
        }
    }

    private void overWriteStatementWithSameTag(Archetype destination, RuleStatement clonedStatement) {
        Assertion clonedAssertion = (Assertion)clonedStatement;
        if (Strings.isNullOrEmpty((String)clonedAssertion.getTag())) {
            destination.getRules().getRules().add(clonedStatement);
        } else {
            int ruleWithTagIndex = this.findRuleWithTag(destination.getRules(), clonedAssertion.getTag());
            if (ruleWithTagIndex > -1) {
                destination.getRules().getRules().set(ruleWithTagIndex, clonedAssertion);
            } else {
                destination.getRules().getRules().add(clonedStatement);
            }
        }
    }

    private int findRuleWithTag(RulesSection rules, String tag) {
        int i = 0;
        for (RuleStatement statement : rules.getRules()) {
            if (statement instanceof Assertion && Objects.equals(tag, ((Assertion)statement).getTag())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addVariableAndTagPrefix(RuleStatement clonedStatement, String variablePrefix, String tagPrefix, String pathPrefix) {
        if (clonedStatement instanceof Assertion) {
            Assertion assertion = (Assertion)clonedStatement;
            if (!Strings.isNullOrEmpty((String)assertion.getTag())) {
                assertion.setTag(tagPrefix + assertion.getTag());
            }
            if (!Strings.isNullOrEmpty((String)pathPrefix) && !(assertion.getExpression() instanceof ForAllStatement)) {
                this.setVariableReferencePrefix(assertion.getExpression(), "item");
                assertion.setExpression((Expression)new ForAllStatement("item", (Expression)new ModelReference(""), assertion.getExpression()));
            }
            this.addVariableAndTagPrefixToExpression(assertion.getExpression(), variablePrefix, pathPrefix);
        } else if (clonedStatement instanceof ExpressionVariable) {
            ExpressionVariable declaration = (ExpressionVariable)clonedStatement;
            declaration.setName(variablePrefix + declaration.getName());
            this.addVariableAndTagPrefixToExpression(declaration.getExpression(), variablePrefix, pathPrefix);
        }
    }

    private void setVariableReferencePrefix(Expression expression, String variablePrefix) {
        if (expression instanceof BinaryOperator) {
            this.setVariableReferencePrefix(((BinaryOperator)expression).getLeftOperand(), variablePrefix);
            this.setVariableReferencePrefix(((BinaryOperator)expression).getRightOperand(), variablePrefix);
        } else if (expression instanceof UnaryOperator) {
            this.setVariableReferencePrefix(((UnaryOperator)expression).getOperand(), variablePrefix);
        } else if (expression instanceof Function) {
            Function function = (Function)expression;
            if (function.getArguments() != null) {
                for (Expression argument : function.getArguments()) {
                    this.setVariableReferencePrefix(argument, variablePrefix);
                }
            }
        } else if (expression instanceof ModelReference) {
            ((ModelReference)expression).setVariableReferencePrefix(variablePrefix);
        }
    }

    private void addVariableAndTagPrefixToExpression(Expression expression, String variablePrefix, String pathPrefix) {
        Function function;
        if (expression instanceof BinaryOperator) {
            BinaryOperator operator = (BinaryOperator)expression;
            this.addVariableAndTagPrefixToExpression(operator.getLeftOperand(), variablePrefix, pathPrefix);
            this.addVariableAndTagPrefixToExpression(operator.getRightOperand(), variablePrefix, pathPrefix);
        } else if (expression instanceof ForAllStatement) {
            ForAllStatement forAllStatement = (ForAllStatement)expression;
            forAllStatement.setVariableName(variablePrefix + forAllStatement.getVariableName());
            this.addVariableAndTagPrefixToExpression(forAllStatement.getPathExpression(), variablePrefix, pathPrefix);
            this.addVariableAndTagPrefixToExpression(forAllStatement.getAssertion(), variablePrefix, pathPrefix);
        } else if (expression instanceof ModelReference) {
            ModelReference reference = (ModelReference)expression;
            if (reference.getVariableReferencePrefix() != null) {
                reference.setVariableReferencePrefix(variablePrefix + reference.getVariableReferencePrefix());
            } else {
                reference.setPath(pathPrefix + reference.getPath());
            }
        } else if (expression instanceof UnaryOperator) {
            UnaryOperator operator = (UnaryOperator)expression;
            this.addVariableAndTagPrefixToExpression(operator.getOperand(), variablePrefix, pathPrefix);
        } else if (expression instanceof VariableReference) {
            VariableReference reference = (VariableReference)expression;
            reference.getDeclaration().setName(variablePrefix + reference.getDeclaration().getName());
        } else if (expression instanceof Function && (function = (Function)expression).getArguments() != null) {
            for (Expression argument : function.getArguments()) {
                this.addVariableAndTagPrefixToExpression(argument, variablePrefix, pathPrefix);
            }
        }
    }
}

