/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.archetypevalidator.ArchetypeValidationSettings;
import com.nedap.archie.archetypevalidator.ValidationResult;
import com.nedap.archie.flattener.ArchetypeHRIDMap;
import com.nedap.archie.flattener.FullArchetypeRepository;
import com.nedap.archie.flattener.MutableArchetypeRepository;
import com.nedap.archie.flattener.SimpleArchetypeRepository;
import java.util.ArrayList;
import java.util.List;

public class InMemoryFullArchetypeRepository
extends SimpleArchetypeRepository
implements FullArchetypeRepository,
MutableArchetypeRepository {
    private ArchetypeHRIDMap<ValidationResult> validationResult = new ArchetypeHRIDMap();
    private ArchetypeHRIDMap<Archetype> flattenedArchetypes = new ArchetypeHRIDMap();
    private ArchetypeHRIDMap<OperationalTemplate> operationalTemplates = new ArchetypeHRIDMap();
    private ArchetypeValidationSettings archetypeValidationSettings;

    @Override
    public Archetype getFlattenedArchetype(String archetypeId) {
        return this.flattenedArchetypes.getLatestVersion(archetypeId);
    }

    @Override
    public ValidationResult getValidationResult(String archetypeId) {
        return this.validationResult.getLatestVersion(archetypeId);
    }

    @Override
    public OperationalTemplate getOperationalTemplate(String archetypeId) {
        return this.operationalTemplates.getLatestVersion(archetypeId);
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        if (result.getFlattened() != null) {
            this.setFlattenedArchetype(result.getFlattened());
        }
        this.validationResult.put(new ArchetypeHRID(result.getArchetypeId()), result);
    }

    @Override
    public void setFlattenedArchetype(Archetype archetype) {
        this.flattenedArchetypes.put(archetype.getArchetypeId(), archetype);
    }

    @Override
    public void setOperationalTemplate(OperationalTemplate template) {
        this.operationalTemplates.put(template.getArchetypeId(), template);
    }

    @Override
    public void removeValidationResult(String archetypeId) {
        this.operationalTemplates.remove(new ArchetypeHRID(archetypeId));
        this.validationResult.remove(new ArchetypeHRID(archetypeId));
    }

    @Override
    public List<ValidationResult> getAllValidationResults() {
        return new ArrayList<ValidationResult>(this.validationResult.values());
    }

    @Override
    public ArchetypeValidationSettings getArchetypeValidationSettings() {
        return this.archetypeValidationSettings;
    }

    public void setArchetypeValidationSettings(ArchetypeValidationSettings settings) {
        this.archetypeValidationSettings = settings;
    }

    @Override
    public void removeArchetype(String archetypeId) {
        super.removeArchetype(archetypeId);
        this.flattenedArchetypes.remove(archetypeId);
        this.operationalTemplates.remove(archetypeId);
        this.validationResult.remove(archetypeId);
    }
}

