/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.esotericsoftware.kryo.Kryo;
import com.nedap.archie.util.KryoUtil;

public class FlattenerConfiguration {
    private boolean createOperationalTemplate = false;
    private boolean useComplexObjectForArchetypeSlotReplacement = false;
    private boolean removeZeroOccurrencesObjects = false;
    private boolean removeZeroOccurrencesInParents = false;
    private boolean removeLanguagesFromMetaData = false;
    private String[] languagesToKeep = null;
    private boolean replaceUseNode = true;
    private boolean fillArchetypeRoots = true;
    private boolean closeArchetypeSlots = true;
    private boolean fillEmptyOccurrences = true;
    private boolean failOnMissingUsedArchetype = true;

    private FlattenerConfiguration() {
    }

    public static FlattenerConfiguration forFlattened() {
        return new FlattenerConfiguration();
    }

    public static FlattenerConfiguration forOperationalTemplate() {
        FlattenerConfiguration result = new FlattenerConfiguration();
        result.setCreateOperationalTemplate(true);
        result.setRemoveZeroOccurrencesObjects(true);
        return result;
    }

    public boolean isCreateOperationalTemplate() {
        return this.createOperationalTemplate;
    }

    public void setCreateOperationalTemplate(boolean createOperationalTemplate) {
        this.createOperationalTemplate = createOperationalTemplate;
    }

    public boolean isRemoveLanguagesFromMetaData() {
        return this.removeLanguagesFromMetaData;
    }

    public void setRemoveLanguagesFromMetaData(boolean removeLanguagesFromMetaData) {
        this.removeLanguagesFromMetaData = removeLanguagesFromMetaData;
    }

    public boolean isUseComplexObjectForArchetypeSlotReplacement() {
        return this.useComplexObjectForArchetypeSlotReplacement;
    }

    public void setUseComplexObjectForArchetypeSlotReplacement(boolean useComplexObjectForArchetypeSlotReplacement) {
        this.useComplexObjectForArchetypeSlotReplacement = useComplexObjectForArchetypeSlotReplacement;
    }

    public boolean isRemoveZeroOccurrencesObjects() {
        return this.removeZeroOccurrencesObjects;
    }

    public void setRemoveZeroOccurrencesObjects(boolean removeZeroOccurrencesObjects) {
        this.removeZeroOccurrencesObjects = removeZeroOccurrencesObjects;
    }

    public String[] getLanguagesToKeep() {
        return this.languagesToKeep;
    }

    public void setLanguagesToKeep(String[] languagesToKeep) {
        this.languagesToKeep = languagesToKeep;
    }

    public FlattenerConfiguration clone() {
        Kryo kryo = null;
        try {
            kryo = KryoUtil.getPool().borrow();
            FlattenerConfiguration flattenerConfiguration = (FlattenerConfiguration)kryo.copy((Object)this);
            return flattenerConfiguration;
        }
        finally {
            KryoUtil.getPool().release(kryo);
        }
    }

    public boolean isReplaceUseNode() {
        return this.replaceUseNode;
    }

    public void setReplaceUseNode(boolean replaceUseNode) {
        this.replaceUseNode = replaceUseNode;
    }

    public boolean isFillArchetypeRoots() {
        return this.fillArchetypeRoots;
    }

    public void setFillArchetypeRoots(boolean fillArchetypeRoots) {
        this.fillArchetypeRoots = fillArchetypeRoots;
    }

    public boolean isCloseArchetypeSlots() {
        return this.closeArchetypeSlots;
    }

    public void setCloseArchetypeSlots(boolean closeArchetypeSlots) {
        this.closeArchetypeSlots = closeArchetypeSlots;
    }

    public boolean isRemoveZeroOccurrencesInParents() {
        return this.removeZeroOccurrencesInParents;
    }

    public void setRemoveZeroOccurrencesInParents(boolean removeZeroOccurrencesInParents) {
        this.removeZeroOccurrencesInParents = removeZeroOccurrencesInParents;
    }

    public boolean isFillEmptyOccurrences() {
        return this.fillEmptyOccurrences;
    }

    public void setFillEmptyOccurrences(boolean fillEmptyOccurrences) {
        this.fillEmptyOccurrences = fillEmptyOccurrences;
    }

    public boolean isFailOnMissingUsedArchetype() {
        return this.failOnMissingUsedArchetype;
    }

    public void setFailOnMissingUsedArchetype(boolean failOnMissingUsedArchetype) {
        this.failOnMissingUsedArchetype = failOnMissingUsedArchetype;
    }
}

