/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.base.Interval;
import java.util.ArrayList;
import java.util.List;

public class UnconstrainedIntervalRemover {
    public static void removeUnconstrainedIntervals(Archetype archetype) {
        UnconstrainedIntervalRemover.removeUnconstrainedIntervals(archetype.getDefinition());
        if (archetype instanceof Template) {
            Template template = (Template)archetype;
            for (TemplateOverlay overlay : template.getTemplateOverlays()) {
                UnconstrainedIntervalRemover.removeUnconstrainedIntervals(overlay.getDefinition());
            }
        }
    }

    public static void removeUnconstrainedIntervals(CComplexObject cObject) {
        for (CAttribute attribute : cObject.getAttributes()) {
            UnconstrainedIntervalRemover.removeUnconstrainedIntervals(attribute);
        }
    }

    public static void removeUnconstrainedIntervals(CAttribute cAttribute) {
        ArrayList<CPrimitiveObject> cObjectsToRemove = new ArrayList<CPrimitiveObject>();
        for (CObject cObject : cAttribute.getChildren()) {
            if (cObject instanceof CComplexObject) {
                UnconstrainedIntervalRemover.removeUnconstrainedIntervals((CComplexObject)cObject);
                continue;
            }
            if (!(cObject instanceof CPrimitiveObject)) continue;
            CPrimitiveObject cPrimitiveObject = (CPrimitiveObject)cObject;
            List constraint = cPrimitiveObject.getConstraint();
            ArrayList toRemove = new ArrayList();
            for (Object i : constraint) {
                Interval interval;
                if (!(i instanceof Interval) || !(interval = (Interval)i).isUpperUnbounded() || !interval.isLowerUnbounded()) continue;
                toRemove.add(i);
            }
            constraint.removeAll(toRemove);
            if (!constraint.isEmpty()) continue;
            cObjectsToRemove.add(cPrimitiveObject);
        }
        for (CObject cObject : cObjectsToRemove) {
            cAttribute.removeChild(cObject);
        }
    }
}

