/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.CodeRedefinitionStatus;
import com.nedap.archie.diff.DiffUtil;
import com.nedap.archie.diff.NodeIdLCS;
import com.nedap.archie.rminfo.MetaModels;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LCSOrderingDiff {
    private final MetaModels metaModels;

    LCSOrderingDiff(MetaModels metaModels) {
        this.metaModels = metaModels;
    }

    public void addSiblingOrder(Archetype result, Archetype flatChild, Archetype flatParent) {
        this.addSiblingOrder(result.getDefinition(), flatChild.getDefinition(), flatParent.getDefinition());
    }

    private void addSiblingOrder(CAttribute resultAttribute, CAttribute flatChildAttribute, CAttribute flatParentAttribute) {
        for (CObject flatChildcObject : flatChildAttribute.getChildren()) {
            if (flatChildcObject instanceof CPrimitiveObject) continue;
            CObject flatParentcObject = DiffUtil.findMatchingParentCObject(flatChildcObject.getNodeId(), flatParentAttribute.getChildren());
            CObject resultcObject = DiffUtil.findMatchingParentCObject(flatChildcObject.getNodeId(), resultAttribute.getChildren());
            if (flatParentcObject == null || !(flatParentcObject instanceof CComplexObject)) continue;
            this.addSiblingOrder((CComplexObject)resultcObject, (CComplexObject)flatChildcObject, (CComplexObject)flatParentcObject);
        }
    }

    public void addSiblingOrder(CComplexObject result, CComplexObject flatChild, CComplexObject flatParent) {
        for (CAttribute flatChildAttribute : flatChild.getAttributes()) {
            CAttribute resultAttribute;
            CAttribute parentAttribute = DiffUtil.getMatchingAttribute((CObject)flatParent, flatChildAttribute);
            if (parentAttribute == null || parentAttribute.getChildren().isEmpty() || (resultAttribute = DiffUtil.getMatchingAttribute((CObject)result, flatChildAttribute)) == null) continue;
            this.addSiblingOrder(resultAttribute, flatChildAttribute, parentAttribute);
            if (!this.metaModels.isMultiple(parentAttribute.getParent().getRmTypeName(), parentAttribute.getRmAttributeName()) || !this.metaModels.isOrdered(parentAttribute.getParent().getRmTypeName(), parentAttribute.getRmAttributeName()) || flatChildAttribute.getChildren().size() <= 1) continue;
            LinkedHashMap<SiblingOrder, List<CObject>> siblingOrders = this.createSiblingOrders(parentAttribute, flatChild, flatChildAttribute, resultAttribute);
            this.removeLastSiblingOrderIfPossible(siblingOrders, parentAttribute, flatChild.getArchetype().specializationDepth());
            DiffUtil.addOrderToAttribute(siblingOrders);
        }
    }

    private void removeLastSiblingOrderIfPossible(LinkedHashMap<SiblingOrder, List<CObject>> siblingOrders, CAttribute parentAttribute, int specializationDepth) {
        SiblingOrder last = null;
        Iterator<SiblingOrder> iterator = siblingOrders.keySet().iterator();
        while (iterator.hasNext()) {
            SiblingOrder key;
            last = key = iterator.next();
        }
        if (last != null && !parentAttribute.getChildren().isEmpty() && !last.isBefore() && ((CObject)parentAttribute.getChildren().get(parentAttribute.getChildren().size() - 1)).getNodeId().equals(last.getSiblingNodeId())) {
            List<CObject> cObjects = siblingOrders.get(last);
            boolean allAdds = true;
            for (CObject cObject : cObjects) {
                if (AOMUtils.getSpecialisationStatusFromCode((String)cObject.getNodeId(), (int)specializationDepth) != CodeRedefinitionStatus.ADDED && !AOMUtils.isOverriddenIdCode((String)cObject.getNodeId(), (String)last.getSiblingNodeId())) continue;
                siblingOrders.remove(last);
            }
        }
    }

    private LinkedHashMap<SiblingOrder, List<CObject>> createSiblingOrders(CAttribute parentAttribute, CComplexObject flatChild, CAttribute flatChildAttribute, CAttribute resultAttribute) {
        int childSpecializationDepth;
        List<String> childNodeIds;
        LinkedHashMap<SiblingOrder, List<CObject>> siblingOrders = new LinkedHashMap<SiblingOrder, List<CObject>>();
        List<String> parentNodeIds = parentAttribute.getChildren().stream().map(cobject -> cobject.getNodeId()).collect(Collectors.toList());
        NodeIdLCS nodeIdLCS = new NodeIdLCS(parentNodeIds, childNodeIds = flatChildAttribute.getChildren().stream().map(cobject -> cobject.getNodeId()).collect(Collectors.toList()), childSpecializationDepth = flatChild.getArchetype().specializationDepth());
        List<String> lcs = nodeIdLCS.getLCS();
        if (lcs.size() != 0) {
            for (int i = 0; i < childNodeIds.size(); ++i) {
                String nodeId = childNodeIds.get(i);
                if (nodeIdLCS.contains(nodeId) || this.handleDirectlyAfterSameParentNode(resultAttribute, siblingOrders, childNodeIds, childSpecializationDepth, i) || this.handleAddAfterSiblingOrder(resultAttribute, siblingOrders, childNodeIds, nodeIdLCS, i)) continue;
                this.addBeforeFirstLcsNodeOrder(resultAttribute, siblingOrders, lcs, nodeId);
            }
        }
        return siblingOrders;
    }

    private void addBeforeFirstLcsNodeOrder(CAttribute resultAttribute, Map<SiblingOrder, List<CObject>> siblingOrders, List<String> lcs, String nodeId) {
        CObject cObjectInResult = resultAttribute.getChild(nodeId);
        DiffUtil.addSiblingOrder(siblingOrders, SiblingOrder.createBefore((String)lcs.get(0)), cObjectInResult);
    }

    private boolean handleAddAfterSiblingOrder(CAttribute resultAttribute, Map<SiblingOrder, List<CObject>> siblingOrders, List<String> childNodeIds, NodeIdLCS nodeIdLCS, int i) {
        int childSpecializationDepth = resultAttribute.getArchetype().specializationDepth();
        String nodeId = childNodeIds.get(i);
        for (int j = i - 1; j >= 0; --j) {
            if (!nodeIdLCS.contains(childNodeIds.get(j))) continue;
            CObject cObjectInResult = resultAttribute.getChild(nodeId);
            DiffUtil.addSiblingOrder(siblingOrders, SiblingOrder.createAfter((String)childNodeIds.get(j)), cObjectInResult);
            return true;
        }
        return false;
    }

    private boolean handleDirectlyAfterSameParentNode(CAttribute resultAttribute, Map<SiblingOrder, List<CObject>> siblingOrders, List<String> childNodeIds, int childSpecializationDepth, int i) {
        String nodeId = childNodeIds.get(i);
        boolean onlyTheSameParentNodeId = false;
        String firstNodeIdWithSameParent = null;
        for (int j = i - 1; j >= 0; --j) {
            String otherNodeId = childNodeIds.get(j);
            if (AOMUtils.getSpecializationDepthFromCode((String)nodeId) != childSpecializationDepth || !AOMUtils.codeExistsAtLevel((String)nodeId, (int)(childSpecializationDepth - 1)) || !AOMUtils.codeAtLevel((String)otherNodeId, (int)(childSpecializationDepth - 1)).equals(AOMUtils.codeAtLevel((String)nodeId, (int)(childSpecializationDepth - 1)))) {
                if (onlyTheSameParentNodeId) {
                    CObject cObjectInResult = resultAttribute.getChild(nodeId);
                    SiblingOrder order = DiffUtil.findSiblingOrder(siblingOrders, firstNodeIdWithSameParent);
                    if (order != null) {
                        DiffUtil.addSiblingOrder(siblingOrders, order, cObjectInResult);
                    }
                    return true;
                }
                return false;
            }
            onlyTheSameParentNodeId = true;
            firstNodeIdWithSameParent = otherNodeId;
        }
        return false;
    }
}

