/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.diff.PrimitiveObjectEqualsChecker;
import com.nedap.archie.query.ComplexObjectProxyReplacement;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ConstraintDifferentiator {
    private final Archetype flatParent;
    private final ModelConstraintImposer constraintImposer;

    ConstraintDifferentiator(ModelConstraintImposer constraintImposer, Archetype flatParent) {
        this.flatParent = flatParent;
        this.constraintImposer = constraintImposer;
    }

    public void removeUnspecializedConstraints(Archetype result, Archetype flatParent) {
        this.removeUnspecializedDefinition((CObject)result.getDefinition(), (CObject)flatParent.getDefinition());
    }

    public void removeUnspecializedDefinition(CObject cObject, @Nullable CObject cObjectInParent) {
        if (cObject instanceof CComplexObject) {
            CComplexObject cComplexObject = (CComplexObject)cObject;
            this.removeUnspecializedAttributeTuples(cObjectInParent, cComplexObject);
            this.removeUnspecializedAttributes(cComplexObject, cObjectInParent);
            this.removeUnspecializedOccurrences(cObject, cObjectInParent);
        }
    }

    public void removeUnspecializedAttributes(CComplexObject cComplexObject, @Nullable CObject cObjectInParent) {
        if (cObjectInParent instanceof CComplexObjectProxy) {
            ComplexObjectProxyReplacement replacement = ComplexObjectProxyReplacement.getComplexObjectProxyReplacement((CComplexObjectProxy)((CComplexObjectProxy)cObjectInParent));
            cObjectInParent = replacement.getReplacement();
        }
        ArrayList<CAttribute> attributesToRemove = new ArrayList<CAttribute>();
        for (CAttribute attribute : cComplexObject.getAttributes()) {
            if (attribute.getDifferentialPath() != null) {
                throw new IllegalArgumentException("cannot handle differential paths in the differentiator - supply flattened archetype please");
            }
            if (attribute.getSocParent() != null) continue;
            CAttribute attributeInParent = cObjectInParent == null ? null : cObjectInParent.getAttribute(attribute.getRmAttributeName());
            this.removeUnspecializedCObjects(attribute, attributeInParent);
            this.removeUnspecializedCardinality(attribute, attributeInParent);
            this.removeUnspecializedExistence(attribute, attributeInParent);
            this.removeDefaultCardinalityAndExistence((CObject)cComplexObject, attribute, attributeInParent);
            if (!this.shouldRemoveAttribute(attribute, attributeInParent)) continue;
            attributesToRemove.add(attribute);
        }
        for (CAttribute attribute : attributesToRemove) {
            cComplexObject.removeAttribute(attribute);
        }
    }

    private void removeUnspecializedExistence(CAttribute attribute, CAttribute attributeInParent) {
        if (attribute.getExistence() == null || attributeInParent == null || attributeInParent.getExistence() == null) {
            return;
        }
        if (attribute.getExistence().equals((Object)attributeInParent.getExistence())) {
            attribute.setExistence(null);
        }
    }

    public void removeUnspecializedCardinality(CAttribute attribute, CAttribute attributeInParent) {
        if (attribute.getCardinality() == null || attributeInParent == null || attributeInParent.getCardinality() == null) {
            return;
        }
        if (attribute.getCardinality().equals((Object)attributeInParent.getCardinality())) {
            attribute.setCardinality(null);
        }
    }

    public void removeUnspecializedCObjects(CAttribute attribute, CAttribute attributeInParent) {
        SiblingOrder anchor = null;
        ArrayList<CObject> cObjectsToRemove = new ArrayList<CObject>();
        for (CObject childCObject : attribute.getChildren()) {
            if (childCObject.getSiblingOrder() != null) {
                anchor = childCObject.getSiblingOrder();
            }
            CObject childCObjectInParent = this.findCObject(attributeInParent, childCObject);
            this.removeUnspecializedDefinition(childCObject, childCObjectInParent);
            this.removeUnspecializedOccurrences(childCObject, childCObjectInParent);
            if (!this.shouldRemoveUnspecializedCObject(childCObject, childCObjectInParent, anchor)) continue;
            cObjectsToRemove.add(childCObject);
        }
        for (CObject toRemove : cObjectsToRemove) {
            toRemove.getParent().removeChild(toRemove);
        }
    }

    public void removeUnspecializedAttributeTuples(@Nullable CObject cObjectInParent, CComplexObject cComplexObject) {
        ArrayList<CAttributeTuple> attributeTuplesToRemove = new ArrayList<CAttributeTuple>();
        for (CAttributeTuple tuple : cComplexObject.getAttributeTuples()) {
            if (!this.shouldRemoveUnspecializedTuple(tuple, (CComplexObject)cObjectInParent)) continue;
            attributeTuplesToRemove.add(tuple);
        }
        for (CAttributeTuple tuple : attributeTuplesToRemove) {
            cComplexObject.removeAttributeTuple(tuple.getMemberNames());
        }
    }

    private boolean shouldRemoveUnspecializedTuple(CAttributeTuple tuple, CComplexObject cObjectInParent) {
        if (cObjectInParent == null) {
            return false;
        }
        int indexOfMatchingAttributeTuple = cObjectInParent.getIndexOfMatchingAttributeTuple(tuple.getMemberNames());
        if (indexOfMatchingAttributeTuple < 0) {
            return false;
        }
        CAttributeTuple tupleInParent = (CAttributeTuple)cObjectInParent.getAttributeTuples().get(indexOfMatchingAttributeTuple);
        if (tuple.getTuples().size() != tupleInParent.getTuples().size()) {
            return false;
        }
        for (int i = 0; i < tuple.getTuples().size(); ++i) {
            CPrimitiveTuple primitiveTuple = (CPrimitiveTuple)tuple.getTuples().get(i);
            CPrimitiveTuple primitiveTupleInParent = (CPrimitiveTuple)tupleInParent.getTuples().get(i);
            for (int j = 0; j < primitiveTuple.getMembers().size(); ++j) {
                CPrimitiveObject memberInParent;
                CPrimitiveObject member = (CPrimitiveObject)primitiveTuple.getMember(j);
                if (PrimitiveObjectEqualsChecker.isEqual(member, memberInParent = (CPrimitiveObject)primitiveTupleInParent.getMember(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldRemoveAttribute(CAttribute attribute, CAttribute attributeInParent) {
        return attributeInParent != null && attribute.getChildren().isEmpty() && attribute.getCardinality() == null && attribute.getExistence() == null;
    }

    private boolean shouldRemoveUnspecializedCObject(CObject childCObject, CObject childCObjectInParent, SiblingOrder anchor) {
        if (anchor != null) {
            return false;
        }
        if (childCObject.getOccurrences() != null || childCObjectInParent == null || childCObject.getAttributes().size() > 0 || childCObject.getSiblingOrder() != null) {
            return false;
        }
        if (childCObject instanceof ArchetypeSlot && childCObjectInParent instanceof ArchetypeSlot) {
            ArchetypeSlot slot = (ArchetypeSlot)childCObject;
            ArchetypeSlot parentSlot = (ArchetypeSlot)childCObjectInParent;
            if (slot.isClosed() != parentSlot.isClosed()) {
                return false;
            }
        }
        if (childCObject instanceof CArchetypeRoot) {
            if (childCObjectInParent instanceof ArchetypeSlot) {
                return false;
            }
            if (childCObjectInParent instanceof CArchetypeRoot && !((CArchetypeRoot)childCObject).getArchetypeRef().equals(((CArchetypeRoot)childCObjectInParent).getArchetypeRef())) {
                return false;
            }
        }
        if (childCObject instanceof CPrimitiveObject) {
            return PrimitiveObjectEqualsChecker.isEqual((CPrimitiveObject)childCObject, (CPrimitiveObject)childCObjectInParent);
        }
        return childCObject.specialisationDepth() == childCObjectInParent.specialisationDepth();
    }

    private void removeUnspecializedOccurrences(CObject cObject, CObject cObjectInParent) {
        if (cObject.getOccurrences() == null || cObjectInParent == null || cObjectInParent.getOccurrences() == null) {
            return;
        }
        if (cObject.getOccurrences().equals((Object)cObjectInParent.getOccurrences())) {
            cObject.setOccurrences(null);
        }
    }

    private CObject findCObject(CAttribute attributeInParent, CObject cObjectInChild) {
        if (attributeInParent == null) {
            return null;
        }
        if (cObjectInChild instanceof CPrimitiveObject) {
            int indexOfChildWithMatchingRmTypeName = attributeInParent.getIndexOfChildWithMatchingRmTypeName(cObjectInChild.getRmTypeName());
            if (indexOfChildWithMatchingRmTypeName > -1) {
                return (CObject)attributeInParent.getChildren().get(indexOfChildWithMatchingRmTypeName);
            }
            return null;
        }
        String codeAtParentLevel = AOMUtils.codeAtLevel((String)cObjectInChild.getNodeId(), (int)this.flatParent.specializationDepth());
        return attributeInParent.getChild(codeAtParentLevel);
    }

    private void removeDefaultCardinalityAndExistence(CObject cObject, CAttribute attribute, CAttribute attributeInParent) {
        CAttribute defaultAttribute = this.constraintImposer.getDefaultAttribute(cObject.getRmTypeName(), attribute.getRmAttributeName());
        if (defaultAttribute != null) {
            MultiplicityInterval defaultExistence;
            MultiplicityInterval existence;
            if ((attributeInParent == null || attributeInParent.getCardinality() == null) && attribute.getCardinality() != null && defaultAttribute.getCardinality() != null) {
                Cardinality cardinality = attribute.getCardinality();
                Cardinality defaultCardinality = defaultAttribute.getCardinality();
                if (cardinality.getInterval().equals((Object)defaultCardinality.getInterval()) && cardinality.isOrdered() == defaultCardinality.isOrdered() && cardinality.isUnique() == defaultCardinality.isUnique()) {
                    attribute.setCardinality(null);
                }
            }
            if ((attributeInParent == null || attributeInParent.getExistence() == null) && attribute.getExistence() != null && defaultAttribute.getExistence() != null && (existence = attribute.getExistence()).equals((Object)(defaultExistence = defaultAttribute.getExistence()))) {
                attribute.setExistence(null);
            }
        }
    }
}

