/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.google.common.base.Joiner;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.CodeRedefinitionStatus;
import com.nedap.archie.aom.utils.NodeIdUtil;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.archetypevalidator.validations.SpecializedAttributeValidation;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rules.Assertion;
import java.util.List;
import org.openehr.utils.message.I18n;

public class SpecializedDefinitionValidation
extends ValidatingVisitor {
    @Override
    public void validate() {
        if (this.archetype.isSpecialized() && this.flatParent != null) {
            super.validate();
        } else if (this.archetype.isSpecialized() && this.flatParent == null) {
            this.addMessage(ErrorType.VASID, I18n.t((String)"Parent archetype {0} not found or can not be flattened", (Object[])new Object[]{this.archetype.getParentArchetypeId()}));
        }
    }

    @Override
    public void validate(CObject cObject) {
        boolean nodeOk = this.checkSpecializedNodeHasMatchingPathInParent(cObject);
        if (nodeOk) {
            this.checkSpecializedNode(cObject);
        }
    }

    private void checkSpecializedNode(CObject cObject) {
        ArchetypeSlot slot;
        String flatPath = AOMUtils.pathAtSpecializationLevel((List)cObject.getPathSegments(), (int)this.flatParent.specializationDepth());
        CObject parentCObject = this.getCObject(this.flatParent.itemAtPath(flatPath));
        boolean passed = true;
        if (parentCObject == null) {
            this.addMessageWithPath(ErrorType.OTHER, cObject.path(), I18n.t((String)"Could not find parent object for {0} but it should have been prechecked. Could you report this as a bug?", (Object[])new Object[]{flatPath}));
            return;
        }
        if (parentCObject instanceof ArchetypeSlot && ((ArchetypeSlot)parentCObject).isClosed()) {
            this.addMessageWithPath(ErrorType.VDSSP, cObject.path(), I18n.t((String)"Cannot redefine a closed archetype slot", (Object[])new Object[0]));
            passed = false;
        }
        if (cObject instanceof ArchetypeSlot && (slot = (ArchetypeSlot)cObject).isClosed() && (this.hasAssertions(slot.getExcludes()) || this.hasAssertions(slot.getIncludes()))) {
            this.addMessageWithPath(ErrorType.VDSSC, cObject.path(), I18n.t((String)"A closed archetype slot cannot have its includes or excludes assertions modified", (Object[])new Object[0]));
            passed = false;
        }
        if (cObject instanceof CArchetypeRoot && parentCObject instanceof ArchetypeSlot) {
            passed = this.validateSlotSpecializedWithRoot((ArchetypeSlot)parentCObject, (CArchetypeRoot)cObject);
        } else if (cObject instanceof ArchetypeSlot && parentCObject instanceof ArchetypeSlot) {
            passed = this.validateSlotSpecializedWithSlot((ArchetypeSlot)parentCObject, (ArchetypeSlot)cObject);
        } else if (cObject instanceof CArchetypeRoot && parentCObject instanceof CArchetypeRoot) {
            passed = this.validateRootSpecializedWithRoot((CArchetypeRoot)parentCObject, (CArchetypeRoot)cObject);
        } else if (cObject instanceof CComplexObject && parentCObject instanceof CComplexObjectProxy) {
            CObject usedNodeInParent = (CObject)this.flatParent.itemAtPath(((CComplexObjectProxy)parentCObject).getTargetPath());
            if (usedNodeInParent != null) {
                parentCObject = usedNodeInParent;
            } else {
                this.addMessageWithPath(ErrorType.VSUNT, cObject.path());
                passed = false;
            }
        } else if (parentCObject instanceof CComplexObject && ((CComplexObject)parentCObject).isAnyAllowed()) {
            passed = true;
        } else if (!cObject.getClass().equals(parentCObject.getClass())) {
            this.addMessageWithPath(ErrorType.VSONT, cObject.path(), I18n.t((String)"A {0} cannot specialize a {1}", (Object[])new Object[]{cObject.getClass().getSimpleName(), parentCObject.getClass().getSimpleName()}));
            passed = false;
        }
        if (passed) {
            this.validateConformsTo(cObject, parentCObject);
        }
    }

    private boolean hasAssertions(List<Assertion> assertions) {
        return assertions != null && !assertions.isEmpty();
    }

    private void validateConformsTo(CObject cObject, CObject parentCObject) {
        if (!cObject.cConformsTo(parentCObject, (arg_0, arg_1) -> ((MetaModels)this.combinedModels).rmTypesConformant(arg_0, arg_1))) {
            if (!cObject.typeNameConformsTo(parentCObject, (arg_0, arg_1) -> ((MetaModels)this.combinedModels).rmTypesConformant(arg_0, arg_1))) {
                this.addMessageWithPath(ErrorType.VSONCT, cObject.path(), I18n.t((String)"Type {0} does not conform to type {1} in parent", (Object[])new Object[]{cObject.getRmTypeName(), parentCObject.getRmTypeName()}));
            } else if (!cObject.occurrencesConformsTo(parentCObject)) {
                this.addMessageWithPath(ErrorType.VSONCO, cObject.path(), I18n.t((String)"Occurrences {0} does not conform to occurrences {1} in parent", (Object[])new Object[]{cObject.getOccurrences(), parentCObject.getOccurrences()}));
            } else if (!cObject.nodeIdConformsTo(parentCObject)) {
                this.addMessageWithPath(ErrorType.VSONI, cObject.path(), I18n.t((String)"Node ID {0} does not conform to node id {1} in parent", (Object[])new Object[]{cObject.getNodeId(), parentCObject.getNodeId()}));
            } else if (cObject instanceof CPrimitiveObject && parentCObject instanceof CPrimitiveObject) {
                this.addMessageWithPath(ErrorType.VPOV, cObject.path(), I18n.t((String)"Primitive object with RM type {0} does not conform to primitive object with RM type {1} in parent", (Object[])new Object[]{cObject.getRmTypeName(), parentCObject.getRmTypeName()}));
            } else {
                this.addMessageWithPath(ErrorType.VUNK, cObject.path(), I18n.t((String)"Unknown error in conformance of specialized C_OBJECT", (Object[])new Object[0]));
            }
        } else if (cObject instanceof CComplexObject && parentCObject instanceof CComplexObject) {
            CComplexObject cComplexObject = (CComplexObject)cObject;
            CComplexObject parentCComplexObject = (CComplexObject)parentCObject;
            if (cComplexObject.getAttributeTuples() != null && parentCComplexObject.getAttributeTuples() != null) {
                for (CAttributeTuple tuple : cComplexObject.getAttributeTuples()) {
                    CAttributeTuple matchingTuple = AOMUtils.findMatchingTuple((List)parentCComplexObject.getAttributeTuples(), (CAttributeTuple)tuple);
                    if (matchingTuple != null) {
                        if (!tuple.cConformsTo(matchingTuple, (arg_0, arg_1) -> ((MetaModels)this.combinedModels).rmTypesConformant(arg_0, arg_1))) {
                            this.addMessageWithPath(ErrorType.VTPNC, cObject.path(), I18n.t((String)"Attribute tuple with members {0} does not conform to parent attribute tuple", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)tuple.getMemberNames())}));
                            continue;
                        }
                    }
                    for (CAttribute attribute : tuple.getMembers()) {
                        CAttribute parentAttribute = parentCComplexObject.getAttribute(attribute.getRmAttributeName());
                        if (parentAttribute == null || parentAttribute.getSocParent() != null) continue;
                        for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
                            CPrimitiveObject member = (CPrimitiveObject)primitiveTuple.getMember(tuple.getMemberIndex(attribute.getRmAttributeName()));
                            if (this.hasConformingParent(parentAttribute, member)) continue;
                            this.addMessageWithPath(ErrorType.VTPIN, attribute.getPath(), I18n.t((String)"Attribute {0} is a non-tuple attribute in the parent archetype, but a tuple attribute in the current archetype. That is not allowed", (Object[])new Object[]{attribute.getRmAttributeName()}));
                        }
                    }
                }
            }
        }
    }

    private boolean hasConformingParent(CAttribute parentAttribute, CPrimitiveObject<?, ?> member) {
        for (CObject parentCObject : parentAttribute.getChildren()) {
            if (!member.cConformsTo(parentCObject, (a, b) -> this.combinedModels.rmTypesConformant(a, b))) continue;
            return true;
        }
        return false;
    }

    private boolean validateRootSpecializedWithRoot(CArchetypeRoot parentCObject, CArchetypeRoot cObject) {
        if (cObject.getArchetypeRef() == null && cObject.getOccurrences() != null && cObject.getOccurrences().isProhibited()) {
            return true;
        }
        Archetype usedArchetype = this.repository.getArchetype(cObject.getArchetypeRef());
        if (usedArchetype != null) {
            if (!this.repository.isChildOf(this.repository.getArchetype(parentCObject.getArchetypeRef()), usedArchetype)) {
                this.addMessageWithPath(ErrorType.VARXAV, cObject.path(), I18n.t((String)"Use_archetype specializes an archetype root pointing to {0}, but the archetype {1} is not a descendant", (Object[])new Object[]{parentCObject.getArchetypeRef(), usedArchetype.getArchetypeId()}));
                return false;
            }
        } else {
            this.addMessageWithPath(ErrorType.VARXRA, cObject.path(), I18n.t((String)"Use_archetype references archetype id {0}, but no archetype was found", (Object[])new Object[]{cObject.getArchetypeRef()}));
            return false;
        }
        return true;
    }

    private boolean validateSlotSpecializedWithSlot(ArchetypeSlot parentCObject, ArchetypeSlot cObject) {
        if (!parentCObject.getNodeId().equals(cObject.getNodeId())) {
            this.addMessageWithPath(ErrorType.VDSSID, cObject.path(), I18n.t((String)"A specialized archetype slot must have the same id as the parent id {0}, but it was {1}", (Object[])new Object[]{parentCObject.getNodeId(), cObject.getNodeId()}));
            return false;
        }
        return true;
    }

    private boolean validateSlotSpecializedWithRoot(ArchetypeSlot slot, CArchetypeRoot root) {
        if (!this.rootMatchesSlotType(slot, root)) {
            this.addMessageWithPath(ErrorType.VARXS, root.path(), I18n.t((String)"The use_archetype with type {0} does not match the archetype slow (allow_archetype) with type {1}", (Object[])new Object[]{slot.getRmTypeName(), root.getRmTypeName()}));
            return false;
        }
        if (this.repository.getArchetype(root.getArchetypeRef()) == null) {
            this.addMessageWithPath(ErrorType.VARXR, root.path(), I18n.t((String)"Use_archetype references archetype id {0}, but no archetype was found", (Object[])new Object[]{root.getArchetypeRef()}));
            return false;
        }
        if (AOMUtils.getSpecializationDepthFromCode((String)root.getNodeId()) != this.archetype.specializationDepth()) {
            this.addMessageWithPath(ErrorType.VARXID, root.getPath(), I18n.t((String)"Node ID {0} specialization depth does not conform to the archetype specialization depth {1}", (Object[])new Object[]{root.getNodeId(), this.archetype.specializationDepth()}));
            return false;
        }
        if (!AOMUtils.archetypeRefMatchesSlotExpression((String)root.getArchetypeRef(), (ArchetypeSlot)slot)) {
            this.addMessageWithPath(ErrorType.VARXS, root.path(), I18n.t((String)"Use_archetype {0} does not match the expression of the archetype slot it specialized in the parent", (Object[])new Object[]{root.getArchetypeRef()}));
            return false;
        }
        return true;
    }

    private boolean rootMatchesSlotType(ArchetypeSlot slot, CArchetypeRoot root) {
        String slotRmTypeName = slot.getRmTypeName();
        String rootRmTypeName = root.getRmTypeName();
        String rootReferenceRmTypeName = new ArchetypeHRID(root.getArchetypeRef()).getRmClass();
        if (!this.combinedModels.typeNameExists(rootRmTypeName) || !this.combinedModels.typeNameExists(rootReferenceRmTypeName)) {
            return false;
        }
        if (!this.combinedModels.rmTypesConformant(rootRmTypeName, slotRmTypeName)) {
            return false;
        }
        return this.combinedModels.rmTypesConformant(rootReferenceRmTypeName, slotRmTypeName);
    }

    private boolean checkSpecializedNodeHasMatchingPathInParent(CObject cObject) {
        boolean result = false;
        if (cObject.isRootNode() || !cObject.getParent().isSecondOrderConstrained()) {
            if (AOMUtils.getSpecializationDepthFromCode((String)cObject.getNodeId()) <= this.flatParent.specializationDepth() || new NodeIdUtil(cObject.getNodeId()).isRedefined()) {
                if (!AOMUtils.isPhantomPathAtLevel((List)cObject.getPathSegments(), (int)this.flatParent.specializationDepth())) {
                    String flatPath = AOMUtils.pathAtSpecializationLevel((List)cObject.getPathSegments(), (int)this.flatParent.specializationDepth());
                    CObject parentCObject = this.getCObject(this.flatParent.itemAtPath(flatPath));
                    boolean bl = result = parentCObject != null;
                    if (parentCObject != null) {
                        if (cObject.isProhibited()) {
                            if (!cObject.getClass().equals(parentCObject.getClass())) {
                                this.addMessageWithPath(ErrorType.VSONPT, cObject.path(), I18n.t((String)"C_OBJECT in this archetype with class {0} is prohibited, which means its class must be the same as parent type {1}", (Object[])new Object[]{cObject.getClass().getSimpleName(), parentCObject.getClass().getSimpleName()}));
                            } else if (!parentCObject.getNodeId().equals(cObject.getNodeId())) {
                                this.addMessageWithPath(ErrorType.VSONPI, cObject.path(), I18n.t((String)"C_OBJECT in this archetype with node id {0} is prohibited, which means its node id must be the same as parent {1}", (Object[])new Object[]{cObject.getNodeId(), parentCObject.getNodeId()}));
                            }
                        }
                    } else if (!(cObject instanceof CPrimitiveObject)) {
                        this.addMessageWithPath(ErrorType.VSONIN, cObject.path(), I18n.t((String)"Node id {0} is not valid here", (Object[])new Object[]{cObject.getNodeId()}));
                    }
                } else if (AOMUtils.getSpecialisationStatusFromCode((String)cObject.getNodeId(), (int)cObject.specialisationDepth()) == CodeRedefinitionStatus.REDEFINED) {
                    this.addMessageWithPath(ErrorType.VSONIN, cObject.path(), I18n.t((String)"Node id {0} is not valid here because it redefines an object illegally", (Object[])new Object[]{cObject.getNodeId()}));
                }
            } else {
                CAttribute parentAttribute;
                if (cObject.getSiblingOrder() != null && (parentAttribute = (CAttribute)this.flatParent.itemAtPath(AOMUtils.pathAtSpecializationLevel((List)cObject.getParent().getPathSegments(), (int)this.flatParent.specializationDepth()))) != null) {
                    CObject child = parentAttribute.getChild(cObject.getSiblingOrder().getSiblingNodeId());
                    CObject child2 = parentAttribute.getChild(AOMUtils.codeAtLevel((String)cObject.getSiblingOrder().getSiblingNodeId(), (int)this.flatParent.specializationDepth()));
                    if (child == null && child2 == null) {
                        this.addMessageWithPath(ErrorType.VSSM, cObject.path(), I18n.t((String)"Sibling order {0} refers to missing node id", (Object[])new Object[]{cObject.getSiblingOrder()}));
                    }
                }
                if (cObject.isProhibited()) {
                    this.addMessageWithPath(ErrorType.VSONPO, cObject.path(), I18n.t((String)"An object with the new node id {0} cannot be prohibited", (Object[])new Object[]{cObject.getNodeId()}));
                }
            }
        }
        return result;
    }

    private CObject getCObject(ArchetypeModelObject archetypeModelObject) {
        if (archetypeModelObject instanceof CAttribute) {
            CAttribute attribute = (CAttribute)archetypeModelObject;
            if (attribute.getChildren().size() == 1) {
                return (CObject)attribute.getChildren().get(0);
            }
        } else if (archetypeModelObject instanceof CObject) {
            return (CObject)archetypeModelObject;
        }
        return null;
    }

    @Override
    public void validate(CAttribute attribute) {
        SpecializedAttributeValidation specializedAttributeValidation = new SpecializedAttributeValidation();
        if (specializedAttributeValidation.validateTest(attribute, this)) {
            specializedAttributeValidation.validate(attribute, this);
        }
    }
}

