/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.archetypevalidator.ValidationMessage;
import java.util.ArrayList;
import java.util.List;

public class ValidationResult {
    private String archetypeId;
    private List<ValidationMessage> errors = new ArrayList<ValidationMessage>();
    private Archetype sourceArchetype;
    private Archetype flattened;
    private List<ValidationResult> overlayValidations;

    public ValidationResult(String archetypeId) {
        this.archetypeId = archetypeId;
    }

    public ValidationResult(Archetype archetype) {
        this.sourceArchetype = archetype;
        this.archetypeId = archetype.getArchetypeId().toString();
        this.overlayValidations = new ArrayList<ValidationResult>();
    }

    public List<ValidationMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ValidationMessage> errors) {
        this.errors = errors;
    }

    public Archetype getSourceArchetype() {
        return this.sourceArchetype;
    }

    public void setSourceArchetype(Archetype sourceArchetype) {
        this.sourceArchetype = sourceArchetype;
    }

    public Archetype getFlattened() {
        return this.flattened;
    }

    public void setFlattened(Archetype flattened) {
        this.flattened = flattened;
    }

    public String getArchetypeId() {
        return this.archetypeId;
    }

    public boolean hasWarningsOrErrors() {
        return !this.errors.isEmpty();
    }

    public boolean passes() {
        for (ValidationMessage message : this.getErrors()) {
            if (message.isWarning()) continue;
            return false;
        }
        return true;
    }

    public void addOverlayValidations(List<ValidationResult> overlayValidations) {
        this.overlayValidations = overlayValidations;
    }

    public List<ValidationResult> getOverlayValidations() {
        return this.overlayValidations;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("archetype: " + this.archetypeId);
        result.append("\n");
        result.append("passes: " + this.passes());
        result.append("\n");
        for (ValidationMessage message : this.errors) {
            result.append(message);
            result.append("\n");
        }
        if (this.overlayValidations != null) {
            for (ValidationResult overlayValidation : this.overlayValidations) {
                result.append("\n");
                result.append(overlayValidation);
            }
        }
        return result.toString();
    }
}

