/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator;

import com.google.common.base.Joiner;
import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.archetypevalidator.ArchetypeValidation;
import com.nedap.archie.archetypevalidator.ArchetypeValidationSettings;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidationMessage;
import com.nedap.archie.archetypevalidator.ValidationResult;
import com.nedap.archie.archetypevalidator.validations.AnnotationsValidation;
import com.nedap.archie.archetypevalidator.validations.AttributeTupleValidation;
import com.nedap.archie.archetypevalidator.validations.AttributeUniquenessValidation;
import com.nedap.archie.archetypevalidator.validations.AuthoredArchetypeMetadataChecks;
import com.nedap.archie.archetypevalidator.validations.BasicChecks;
import com.nedap.archie.archetypevalidator.validations.BasicDefinitionObjectValidation;
import com.nedap.archie.archetypevalidator.validations.BasicTerminologyValidation;
import com.nedap.archie.archetypevalidator.validations.CodeValidation;
import com.nedap.archie.archetypevalidator.validations.DefinitionStructureValidation;
import com.nedap.archie.archetypevalidator.validations.FlatFormValidation;
import com.nedap.archie.archetypevalidator.validations.MultiplicitiesValidation;
import com.nedap.archie.archetypevalidator.validations.NodeIdValidation;
import com.nedap.archie.archetypevalidator.validations.SpecializedDefinitionValidation;
import com.nedap.archie.archetypevalidator.validations.ValidateAgainstReferenceModel;
import com.nedap.archie.archetypevalidator.validations.VariousStructureValidation;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.flattener.Flattener;
import com.nedap.archie.flattener.FlattenerConfiguration;
import com.nedap.archie.flattener.FullArchetypeRepository;
import com.nedap.archie.flattener.InMemoryFullArchetypeRepository;
import com.nedap.archie.flattener.OverridingInMemFullArchetypeRepository;
import com.nedap.archie.rminfo.MetaModelInterface;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ReferenceModels;
import java.util.ArrayList;
import java.util.List;
import org.openehr.utils.message.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchetypeValidator {
    private static final Logger logger = LoggerFactory.getLogger(ArchetypeValidator.class);
    private MetaModels combinedModels;
    private FlattenerConfiguration flattenerConfiguration = FlattenerConfiguration.forFlattened();
    private List<ArchetypeValidation> validationsPhase0;
    private List<ArchetypeValidation> validationsPhase1;
    private List<ArchetypeValidation> validationsPhase2;
    private List<ArchetypeValidation> validationsPhase3;

    public ArchetypeValidator(ReferenceModels models) {
        this(new MetaModels(models, null));
    }

    public ArchetypeValidator(MetaModels models) {
        this.combinedModels = models;
        this.validationsPhase0 = new ArrayList<ArchetypeValidation>();
        this.validationsPhase0.add(new AttributeUniquenessValidation());
        this.validationsPhase0.add(new NodeIdValidation());
        this.validationsPhase0.add(new BasicDefinitionObjectValidation());
        this.validationsPhase0.add(new AttributeTupleValidation());
        this.validationsPhase1 = new ArrayList<ArchetypeValidation>();
        this.validationsPhase1.add(new BasicChecks());
        this.validationsPhase1.add(new MultiplicitiesValidation());
        this.validationsPhase1.add(new AuthoredArchetypeMetadataChecks());
        this.validationsPhase1.add(new DefinitionStructureValidation());
        this.validationsPhase1.add(new BasicTerminologyValidation());
        this.validationsPhase1.add(new VariousStructureValidation());
        this.validationsPhase1.add(new CodeValidation());
        this.validationsPhase2 = new ArrayList<ArchetypeValidation>();
        this.validationsPhase2.add(new ValidateAgainstReferenceModel());
        this.validationsPhase2.add(new SpecializedDefinitionValidation());
        this.validationsPhase3 = new ArrayList<ArchetypeValidation>();
        this.validationsPhase3.add(new AnnotationsValidation());
        this.validationsPhase3.add(new FlatFormValidation());
    }

    public void setRemoveZeroOccurrencesConstraintsComingFromParents(boolean value) {
        this.flattenerConfiguration.setRemoveZeroOccurrencesInParents(value);
    }

    public ValidationResult validate(Archetype archetype) {
        return this.validate(archetype, null);
    }

    public ValidationResult validate(Archetype archetype, FullArchetypeRepository repository) {
        ArchetypeValidationSettings settings;
        ArchetypeValidationSettings archetypeValidationSettings = settings = repository == null ? null : repository.getArchetypeValidationSettings();
        if (settings == null) {
            settings = new ArchetypeValidationSettings();
        }
        OverridingInMemFullArchetypeRepository extraRepository = null;
        extraRepository = repository == null ? new OverridingInMemFullArchetypeRepository() : new OverridingInMemFullArchetypeRepository(repository);
        repository = extraRepository;
        if (archetype instanceof Template) {
            for (TemplateOverlay overlay : ((Template)archetype).getTemplateOverlays()) {
                extraRepository.addExtraArchetype((Archetype)overlay);
            }
            for (TemplateOverlay overlay : ((Template)archetype).getTemplateOverlays()) {
                this.getValidationResult(overlay.getArchetypeId().toString(), extraRepository);
            }
        }
        this.combinedModels.selectModel(archetype);
        if (this.combinedModels.getSelectedModelInfoLookup() == null && this.combinedModels.getSelectedBmmModel() == null) {
            throw new UnsupportedOperationException("reference model unknown for archetype " + archetype.getArchetypeId());
        }
        archetype = this.cloneAndPreprocess(this.combinedModels, archetype);
        ValidationResult parentValidationResult = null;
        Archetype flatParent = null;
        if (archetype.isSpecialized() && (parentValidationResult = this.getParentValidationResult(archetype, repository)) != null) {
            if (parentValidationResult.passes()) {
                flatParent = parentValidationResult.getFlattened();
            } else {
                ValidationResult result = new ValidationResult(archetype);
                ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
                ValidationMessage message = new ValidationMessage(ErrorType.PARENT_VALIDATION_FAILED, "", I18n.t((String)"Error in parent archetype. Fix those errors before continuing with this archetype: {0}", (Object[])new Object[]{parentValidationResult.getErrors().toString()}));
                messages.add(message);
                result.setErrors(messages);
                result.setSourceArchetype(archetype);
                return result;
            }
        }
        if (repository == null) {
            repository = new InMemoryFullArchetypeRepository();
        }
        List<ValidationMessage> messages = this.runValidations(archetype, repository, settings, flatParent, this.validationsPhase0);
        ValidationResult result = new ValidationResult(archetype);
        result.setErrors(messages);
        if (result.passes()) {
            messages.addAll(this.runValidations(archetype, repository, settings, flatParent, this.validationsPhase1));
            messages.addAll(this.runValidations(archetype, repository, settings, flatParent, this.validationsPhase2));
        }
        result.setErrors(messages);
        if (result.passes() || settings.isAlwaysTryToFlatten()) {
            try {
                Archetype flattened = new Flattener(repository, this.combinedModels, this.flattenerConfiguration).flatten(archetype);
                try {
                    OperationalTemplate operationalTemplate = (OperationalTemplate)new Flattener((ArchetypeRepository)repository, this.combinedModels).createOperationalTemplate(true).flatten(archetype);
                    extraRepository.addExtraOperationalTemplate(operationalTemplate);
                }
                catch (Exception e) {
                    ValidationMessage message = new ValidationMessage(ErrorType.OTHER, "Error during Operational template creation. This does not necessarily mean the current archetype has a problem, but perhaps one that is included with use_archetype: " + e);
                    message.setWarning(true);
                    messages.add(message);
                }
                result.setFlattened(flattened);
                if (result.passes()) {
                    messages.addAll(this.runValidations(flattened, repository, settings, flatParent, this.validationsPhase3));
                }
            }
            catch (Exception e) {
                messages.add(new ValidationMessage(ErrorType.OTHER, "flattening failed with exception " + e));
                logger.error("error during validation", (Throwable)e);
            }
        }
        if (archetype instanceof Template) {
            OverridingInMemFullArchetypeRepository repositoryWithOverlays = (OverridingInMemFullArchetypeRepository)repository;
            FullArchetypeRepository extraArchetypeRepository = repositoryWithOverlays.getExtraArchetypeRepository();
            result.addOverlayValidations(extraArchetypeRepository.getAllValidationResults());
            for (ValidationResult subResult : extraArchetypeRepository.getAllValidationResults()) {
                if (subResult.passes()) continue;
                result.getErrors().add(new ValidationMessage(ErrorType.OVERLAY_VALIDATION_FAILED, I18n.t((String)"Template overlay {0} had validation errors", (Object[])new Object[]{subResult.getArchetypeId()})));
            }
        }
        if (repository != null) {
            repository.setValidationResult(result);
        }
        return result;
    }

    private ValidationResult getParentValidationResult(Archetype archetype, FullArchetypeRepository repository) {
        if (!archetype.isSpecialized()) {
            return null;
        }
        if (repository == null) {
            return null;
        }
        return this.getValidationResult(archetype.getParentArchetypeId(), repository);
    }

    private ValidationResult getValidationResult(String archetypeId, FullArchetypeRepository repository) {
        Archetype archetype = repository.getArchetype(archetypeId);
        if (archetype == null) {
            return null;
        }
        ValidationResult validationResult = repository.getValidationResult(archetypeId);
        if (validationResult == null) {
            validationResult = this.validate(archetype, repository);
        }
        return validationResult;
    }

    private Archetype cloneAndPreprocess(MetaModels models, Archetype archetype) {
        Archetype preprocessed = archetype.clone();
        new ReflectionConstraintImposer((MetaModelInterface)models).setSingleOrMultiple(preprocessed.getDefinition());
        return preprocessed;
    }

    private List<ValidationMessage> runValidations(Archetype archetype, FullArchetypeRepository repository, ArchetypeValidationSettings settings, Archetype flatParent, List<ArchetypeValidation> validations) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ArchetypeValidation validation : validations) {
            try {
                messages.addAll(validation.validate(this.combinedModels, archetype, flatParent, repository, settings));
            }
            catch (Exception e) {
                logger.error("error running validation processor", (Throwable)e);
                e.printStackTrace();
                messages.add(new ValidationMessage(ErrorType.OTHER, null, "error running validator : " + e.getClass().getSimpleName() + Joiner.on((String)"\n").join((Object[])e.getStackTrace())));
            }
        }
        return messages;
    }
}

