/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adlparser.modelconstraints.BMMConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModels;
import java.util.ArrayList;

public class DefaultRmStructureRemover {
    private final MetaModels metaModels;
    private BMMConstraintImposer constraintImposer;
    private boolean removeEmptyAttributes = false;

    public DefaultRmStructureRemover(MetaModels metaModels) {
        this(metaModels, false);
    }

    public DefaultRmStructureRemover(MetaModels metaModels, boolean removeEmptyAttributes) {
        this.metaModels = metaModels;
        this.removeEmptyAttributes = removeEmptyAttributes;
    }

    public void setRemoveEmptyAttributes(boolean removeEmptyAttributes) {
        this.removeEmptyAttributes = removeEmptyAttributes;
    }

    public void removeRMDefaults(Archetype archetype) {
        this.metaModels.selectModel(archetype);
        if (this.metaModels.getSelectedModel() == null) {
            throw new IllegalArgumentException("cannot find model for argument, so cannot remove default multiplicity");
        }
        this.constraintImposer = new BMMConstraintImposer(this.metaModels.getSelectedBmmModel());
        this.removeRMDefaults((CObject)archetype.getDefinition());
    }

    private void removeRMDefaults(CObject object) {
        if (object.getOccurrences() != null) {
            MultiplicityInterval defaultRMOccurrences = object.getDefaultRMOccurrences((arg_0, arg_1) -> ((MetaModels)this.metaModels).referenceModelPropMultiplicity(arg_0, arg_1));
            if (defaultRMOccurrences.equals((Object)object.getOccurrences())) {
                object.setOccurrences(null);
            }
        }
        if (object instanceof CComplexObject) {
            CComplexObject complexObject = (CComplexObject)object;
            ArrayList<CAttribute> attributesToRemove = new ArrayList<CAttribute>();
            for (CAttribute attribute : object.getAttributes()) {
                this.removeMultiplicities(attribute);
                if (!this.removeEmptyAttributes || attribute.getCardinality() != null || attribute.getExistence() != null || attribute.getChildren() != null && !attribute.getChildren().isEmpty() || this.isInTuple(complexObject, attribute)) continue;
                attributesToRemove.add(attribute);
            }
            for (CAttribute attributeToRemove : attributesToRemove) {
                complexObject.removeAttribute(attributeToRemove);
            }
        }
    }

    private boolean isInTuple(CComplexObject complexObject, CAttribute attribute) {
        if (complexObject.getAttributeTuples() == null) {
            return false;
        }
        for (CAttributeTuple tuple : complexObject.getAttributeTuples()) {
            if (tuple.getMember(attribute.getRmAttributeName()) == null) continue;
            return true;
        }
        return false;
    }

    private void removeMultiplicities(CAttribute attribute) {
        CAttribute defaultAttribute = this.constraintImposer.getDefaultAttribute(attribute.getParent().getRmTypeName(), attribute.getRmAttributeName());
        if (attribute.getExistence() != null && defaultAttribute != null && defaultAttribute.getExistence() != null && defaultAttribute.getExistence().equals((Object)attribute.getExistence())) {
            attribute.setExistence(null);
        }
        if (attribute.getCardinality() != null && defaultAttribute != null && defaultAttribute.getCardinality() != null && defaultAttribute.getCardinality().equals((Object)attribute.getCardinality())) {
            attribute.setCardinality(null);
        }
        for (CObject child : attribute.getChildren()) {
            this.removeRMDefaults(child);
        }
    }
}

