/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation;

import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.evaluation.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueList {
    private PrimitiveType type;
    private List<Value> values = new ArrayList<Value>();
    private static Logger logger = LoggerFactory.getLogger(ValueList.class);

    public ValueList() {
    }

    public ValueList(List<Value> values) {
        this.setValues(values);
        this.determineTypeFromValues();
    }

    public void determineTypeFromValues() {
        this.type = !this.values.isEmpty() ? PrimitiveType.fromJavaType(this.values.get(0).getValue().getClass()) : PrimitiveType.Unknown;
    }

    public ValueList(Object value) {
        this(value, Collections.EMPTY_LIST);
    }

    public ValueList(Object value, PrimitiveType type) {
        this(value, Collections.EMPTY_LIST);
        this.setType(type);
    }

    public ValueList(Object value, List<String> paths) {
        if (value == null) {
            this.type = null;
            this.addValue(value, paths);
        } else {
            this.addValue(value, paths);
            this.type = PrimitiveType.fromJavaType(value.getClass());
        }
    }

    public PrimitiveType getType() {
        return this.type;
    }

    public void setType(PrimitiveType type) {
        this.type = type;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public List<Object> getValueObjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Value value : this.values) {
            result.add(value.getValue());
        }
        return result;
    }

    public void setValues(List<Value> values) {
        this.values = new ArrayList<Value>(values.size());
        for (Value o : values) {
            this.addValue(o);
        }
    }

    public void addValue(Object value, List<String> paths) {
        this.values.add(new Value<Object>(value, paths));
    }

    public void addValue(Value value) {
        this.values.add(value);
    }

    public String toString() {
        return this.type + ": " + this.values;
    }

    public int size() {
        return this.values.size();
    }

    public Object getObject(int i) {
        return this.values.get(i).getValue();
    }

    public List<String> getPaths(int i) {
        return this.values.get(i).getPaths();
    }

    public Value get(int i) {
        return this.values.get(i);
    }

    public boolean isEmpty() {
        boolean containsValue = false;
        for (Value value : this.values) {
            if (value.isNull()) continue;
            containsValue = true;
        }
        return !containsValue;
    }

    public void addValues(ValueList evaluated) {
        for (Value value : evaluated.getValues()) {
            this.addValue(value);
        }
    }

    public List<String> getAllPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : this.values) {
            result.addAll(value.getPaths());
        }
        return result;
    }

    public boolean getSingleBooleanResult() {
        if (this.isEmpty()) {
            return false;
        }
        for (Value singleResult : this.values) {
            Boolean singleBoolean = (Boolean)singleResult.getValue();
            if (singleBoolean == null || singleBoolean.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean containsOnlyNullValues() {
        for (Value value : this.values) {
            if (value.isNull()) continue;
            return false;
        }
        return true;
    }
}

