/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator.validations;

import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.query.RMObjectAttributes;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import com.nedap.archie.rmobjectvalidator.validations.RMPrimitiveObjectValidation;
import java.util.ArrayList;
import java.util.List;

public class RMTupleValidation {
    public static List<RMObjectValidationMessage> validate(ModelInfoLookup lookup, CObject cobject, String pathSoFar, List<RMObjectWithPath> rmObjects, CAttributeTuple tuple) {
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
        if (rmObjects.size() != 1) {
            String message = RMObjectValidationMessageIds.rm_TUPLE_CONSTRAINT.getMessage(new Object[]{cobject.toString(), rmObjects.toString()});
            result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar, message));
            return result;
        }
        Object rmObject = rmObjects.get(0).getObject();
        if (!tuple.isValid(lookup, rmObject)) {
            if (tuple.getTuples().size() == 1) {
                result.addAll(RMTupleValidation.validateSingleTuple(lookup, pathSoFar, rmObject, tuple));
            }
            if (result.isEmpty()) {
                String message = RMObjectValidationMessageIds.rm_TUPLE_MISMATCH.getMessage(new Object[]{tuple.toString()});
                result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar, message));
            }
        }
        return result;
    }

    private static List<RMObjectValidationMessage> validateSingleTuple(ModelInfoLookup lookup, String pathSoFar, Object rmObject, CAttributeTuple attributeTuple) {
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
        CPrimitiveTuple tuple = (CPrimitiveTuple)attributeTuple.getTuples().get(0);
        int index = 0;
        for (CAttribute attribute : attributeTuple.getMembers()) {
            String attributeName = attribute.getRmAttributeName();
            CPrimitiveObject cPrimitiveObject = (CPrimitiveObject)tuple.getMembers().get(index);
            Object value = RMObjectAttributes.getAttributeValueFromRMObject((Object)rmObject, (String)attributeName, (ModelInfoLookup)lookup);
            String path = pathSoFar + "/" + attributeName + "[" + cPrimitiveObject.getNodeId() + "]";
            result.addAll(RMPrimitiveObjectValidation.validate_inner(lookup, value, path, cPrimitiveObject));
            ++index;
        }
        return result;
    }
}

