/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmGenericType;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmOpenType;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmSimpleType;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class JSONSchemaCreator {
    private Map<String, Supplier<JsonObjectBuilder>> primitiveTypeMapping = new HashMap<String, Supplier<JsonObjectBuilder>>();
    private List<String> rootTypes;
    private BmmModel bmmModel;
    private final JsonBuilderFactory jsonFactory;
    private boolean allowAdditionalProperties;

    public JSONSchemaCreator() {
        this.primitiveTypeMapping.put("integer", () -> this.createType("integer"));
        this.primitiveTypeMapping.put("integer64", () -> this.createType("integer"));
        this.primitiveTypeMapping.put("boolean", () -> this.createType("boolean"));
        this.primitiveTypeMapping.put("real", () -> this.createType("number"));
        this.primitiveTypeMapping.put("double", () -> this.createType("number"));
        this.primitiveTypeMapping.put("octet", () -> this.createType("string"));
        this.primitiveTypeMapping.put("byte", () -> this.createType("string"));
        this.primitiveTypeMapping.put("character", () -> this.createType("string"));
        this.primitiveTypeMapping.put("hash", () -> this.createType("object"));
        this.primitiveTypeMapping.put("string", () -> this.createType("string"));
        this.primitiveTypeMapping.put("iso8601_date", () -> this.createType("string").add("format", "date"));
        this.primitiveTypeMapping.put("iso8601_date_time", () -> this.createType("string").add("format", "date-time"));
        this.primitiveTypeMapping.put("iso8601_time", () -> this.createType("string").add("format", "time"));
        this.primitiveTypeMapping.put("iso8601_duration", () -> this.createType("string"));
        this.primitiveTypeMapping.put("proportion_kind", () -> this.createType("integer"));
        this.rootTypes = new ArrayList<String>();
        this.rootTypes.add("COMPOSITION");
        this.rootTypes.add("OBSERVATION");
        this.rootTypes.add("EVALUATION");
        this.rootTypes.add("ACTIVITY");
        this.rootTypes.add("ACTION");
        this.rootTypes.add("SECTION");
        this.rootTypes.add("INSTRUCTION");
        this.rootTypes.add("INSTRUCTION_DETAILS");
        this.rootTypes.add("ADMIN_ENTRY");
        this.rootTypes.add("CLUSTER");
        this.rootTypes.add("CAPABILITY");
        this.rootTypes.add("PERSON");
        this.rootTypes.add("ADDRESS");
        this.rootTypes.add("ROLE");
        this.rootTypes.add("ORGANISATION");
        this.rootTypes.add("PARTY_IDENTITY");
        this.rootTypes.add("ITEM_TREE");
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.jsonFactory = Json.createBuilderFactory(config);
    }

    public JsonObject create(BmmModel bmm) {
        this.bmmModel = bmm;
        JsonArrayBuilder allOfArray = this.jsonFactory.createArrayBuilder();
        JsonObjectBuilder definitions = this.jsonFactory.createObjectBuilder();
        allOfArray.add(this.createRequiredArray("_type"));
        for (String rootType : this.rootTypes) {
            JsonObjectBuilder typePropertyCheck = this.createConstType(rootType);
            JsonObjectBuilder typeCheck = this.jsonFactory.createObjectBuilder().add("properties", typePropertyCheck);
            JsonObjectBuilder typeReference = this.createReference(rootType);
            JsonObjectBuilder ifObject = this.jsonFactory.createObjectBuilder().add("if", typeCheck).add("then", typeReference);
            allOfArray.add(ifObject);
        }
        for (BmmClass bmmClass : bmm.getClassDefinitions().values()) {
            if (bmmClass.isAbstract() || this.primitiveTypeMapping.containsKey(bmmClass.getTypeName().toLowerCase())) continue;
            this.addClass(definitions, bmmClass);
        }
        return this.jsonFactory.createObjectBuilder().add("$schema", "http://json-schema.org/draft-07/schema").add("allOf", allOfArray).add("definitions", definitions).build();
    }

    private void addClass(JsonObjectBuilder definitions, BmmClass bmmClass) {
        String typeName = BmmDefinitions.typeNameToClassKey((String)bmmClass.getTypeName());
        BmmClass flatBmmClass = bmmClass.flattenBmmClass();
        JsonArrayBuilder required = this.jsonFactory.createArrayBuilder();
        JsonObjectBuilder properties = this.jsonFactory.createObjectBuilder();
        boolean atLeastOneProperty = false;
        for (String propertyName : flatBmmClass.getProperties().keySet()) {
            JsonObjectBuilder propertyDef;
            BmmProperty bmmProperty = (BmmProperty)flatBmmClass.getProperties().get(propertyName);
            if (bmmProperty.getComputed().booleanValue()) continue;
            if ((bmmClass.getTypeName().startsWith("POINT_EVENT") || bmmClass.getTypeName().startsWith("INTERVAL_EVENT")) && propertyName.equalsIgnoreCase("data")) {
                propertyDef = this.createPolymorphicReference(this.bmmModel.getClassDefinition("ITEM_STRUCTURE"));
                this.extendPropertyDef(propertyDef, bmmProperty);
                properties.add(propertyName, propertyDef);
                if (bmmProperty.getMandatory().booleanValue()) {
                    required.add(propertyName);
                }
                atLeastOneProperty = true;
                continue;
            }
            propertyDef = this.createPropertyDef(bmmProperty.getType());
            this.extendPropertyDef(propertyDef, bmmProperty);
            properties.add(propertyName, propertyDef);
            if (bmmProperty.getMandatory().booleanValue()) {
                required.add(propertyName);
            }
            atLeastOneProperty = true;
        }
        properties.add("_type", this.jsonFactory.createObjectBuilder().add("type", "string").add("pattern", "^" + typeName + "(<.*>)?$"));
        JsonObjectBuilder definition = this.jsonFactory.createObjectBuilder().add("type", "object").add("required", required).add("properties", properties);
        if (!this.allowAdditionalProperties && atLeastOneProperty) {
            definition.add("additionalProperties", false);
        }
        definitions.add(typeName, definition);
    }

    private void extendPropertyDef(JsonObjectBuilder propertyDef, BmmProperty bmmProperty) {
        BmmContainerProperty containerProperty;
        if (bmmProperty instanceof BmmContainerProperty && (containerProperty = (BmmContainerProperty)bmmProperty).getCardinality() != null && (Integer)containerProperty.getCardinality().getLower() > 0) {
            propertyDef.add("minItems", ((Integer)containerProperty.getCardinality().getLower()).intValue());
        }
    }

    private JsonObjectBuilder createPropertyDef(BmmType type) {
        if (type instanceof BmmOpenType) {
            return this.createType("object");
        }
        if (type instanceof BmmSimpleType) {
            if (this.isJSPrimitive(type)) {
                return this.getJSPrimitive(type);
            }
            return this.createPolymorphicReference(type.getBaseClass());
        }
        if (type instanceof BmmContainerType) {
            BmmContainerType containerType = (BmmContainerType)type;
            return this.jsonFactory.createObjectBuilder().add("type", "array").add("items", this.createPropertyDef(containerType.getBaseType()));
        }
        if (type instanceof BmmGenericType) {
            if (this.isJSPrimitive(type)) {
                return this.getJSPrimitive(type);
            }
            return this.createPolymorphicReference(type.getBaseClass());
        }
        throw new IllegalArgumentException("type must be a BmmType, but was " + type.getClass().getSimpleName());
    }

    private JsonObjectBuilder createPolymorphicReference(BmmClass type) {
        List<String> descendants = this.getAllNonAbstractDescendants(type);
        if (!type.isAbstract()) {
            descendants.add(BmmDefinitions.typeNameToClassKey((String)type.getTypeName()));
        }
        if (descendants.isEmpty()) {
            return this.createType("object");
        }
        if (descendants.size() > 1) {
            JsonArrayBuilder array = this.jsonFactory.createArrayBuilder();
            array.add(this.createRequiredArray("_type"));
            for (String descendant : descendants) {
                JsonObjectBuilder typePropertyCheck = this.createConstType(descendant);
                JsonObjectBuilder typeCheck = this.jsonFactory.createObjectBuilder().add("properties", typePropertyCheck);
                JsonObjectBuilder typeReference = this.createReference(descendant);
                JsonObjectBuilder ifObject = this.jsonFactory.createObjectBuilder().add("if", typeCheck).add("then", typeReference);
                array.add(ifObject);
            }
            return this.jsonFactory.createObjectBuilder().add("allOf", array);
        }
        return this.createReference(descendants.get(0));
    }

    private List<String> getAllNonAbstractDescendants(BmmClass bmmClass) {
        ArrayList<String> result = new ArrayList<String>();
        List descs = bmmClass.getImmediateDescendants();
        for (String desc : descs) {
            if (bmmClass.getTypeName().equalsIgnoreCase(desc)) continue;
            BmmClass classDefinition = this.bmmModel.getClassDefinition(desc);
            if (!classDefinition.isAbstract()) {
                result.add(BmmDefinitions.typeNameToClassKey((String)classDefinition.getTypeName()));
            }
            result.addAll(this.getAllNonAbstractDescendants(classDefinition));
        }
        return result;
    }

    private boolean isJSPrimitive(BmmType bmmType) {
        return this.primitiveTypeMapping.containsKey(bmmType.getTypeName().toLowerCase());
    }

    private JsonObjectBuilder getJSPrimitive(BmmType bmmType) {
        return this.primitiveTypeMapping.get(bmmType.getTypeName().toLowerCase()).get();
    }

    private JsonObjectBuilder createConstType(String rootType) {
        return this.jsonFactory.createObjectBuilder().add("_type", this.jsonFactory.createObjectBuilder().add("type", "string").add("pattern", "^" + rootType + "(<.*>)?$"));
    }

    private JsonObjectBuilder createRequiredArray(String ... requiredFields) {
        JsonArrayBuilder requiredArray = this.jsonFactory.createArrayBuilder();
        for (String requiredProperty : requiredFields) {
            requiredArray.add(requiredProperty);
        }
        return this.jsonFactory.createObjectBuilder().add("required", requiredArray);
    }

    private JsonObjectBuilder createType(String jsPrimitive) {
        return this.jsonFactory.createObjectBuilder().add("type", jsPrimitive);
    }

    private JsonObjectBuilder createReference(String rootType) {
        return this.jsonFactory.createObjectBuilder().add("$ref", "#/definitions/" + rootType);
    }

    public JSONSchemaCreator allowAdditionalProperties(boolean allowAdditionalProperties) {
        this.allowAdditionalProperties = allowAdditionalProperties;
        return this;
    }
}

