/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.flattener.Flattener;
import com.nedap.archie.flattener.TerminologyFlattener;
import com.nedap.archie.query.ComplexObjectProxyReplacement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;

class OperationalTemplateCreator {
    private final Flattener flattener;

    OperationalTemplateCreator(Flattener flattener) {
        this.flattener = flattener;
    }

    public static OperationalTemplate createOperationalTemplate(Archetype archetype) {
        Archetype clone = archetype.clone();
        OperationalTemplate result = new OperationalTemplate();
        result.setArchetypeId((ArchetypeHRID)archetype.getArchetypeId().clone());
        result.setDefinition(clone.getDefinition());
        result.setDifferential(false);
        result.setRmRelease(clone.getRmRelease());
        result.setAdlVersion(clone.getAdlVersion());
        result.setTerminology(clone.getTerminology());
        result.setGenerated(Boolean.valueOf(true));
        result.setOtherMetaData(clone.getOtherMetaData());
        result.setRules(clone.getRules());
        result.setBuildUid(clone.getBuildUid());
        result.setDescription(clone.getDescription());
        result.setOriginalLanguage(clone.getOriginalLanguage());
        result.setTranslations(clone.getTranslations());
        result.setAnnotations(clone.getAnnotations());
        return result;
    }

    public static void overrideArchetypeId(Archetype result, Archetype override) {
        result.setArchetypeId(override.getArchetypeId());
        result.setParentArchetypeId(override.getParentArchetypeId());
    }

    public void fillSlots(OperationalTemplate archetype) {
        this.closeArchetypeSlots(archetype);
        this.fillArchetypeRoots(archetype);
        this.fillComplexObjectProxies(archetype);
    }

    public void removeZeroOccurrencesConstraints(Archetype archetype) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(archetype.getDefinition());
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            ArrayList<CAttribute> attributesToRemove = new ArrayList<CAttribute>();
            for (CAttribute attribute : object.getAttributes()) {
                if (attribute.getExistence() != null && (Integer)attribute.getExistence().getUpper() == 0 && !attribute.getExistence().isUpperUnbounded()) {
                    attributesToRemove.add(attribute);
                    continue;
                }
                ArrayList<CObject> objectsToRemove = new ArrayList<CObject>();
                for (CObject child : attribute.getChildren()) {
                    if (!child.isAllowed()) {
                        objectsToRemove.add(child);
                    }
                    workList.push(child);
                }
                attribute.getChildren().removeAll(objectsToRemove);
            }
            object.getAttributes().removeAll(attributesToRemove);
        }
    }

    private void closeArchetypeSlots(OperationalTemplate archetype) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(archetype.getDefinition());
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                ArrayList<CObject> toRemove = new ArrayList<CObject>();
                for (CObject child : attribute.getChildren()) {
                    if (child instanceof ArchetypeSlot && ((ArchetypeSlot)child).isClosed()) {
                        toRemove.add(child);
                    }
                    workList.push(child);
                }
                attribute.getChildren().removeAll(toRemove);
            }
        }
    }

    private void fillArchetypeRoots(OperationalTemplate result) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(result.getDefinition());
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                for (CObject child : attribute.getChildren()) {
                    if (child instanceof CArchetypeRoot) {
                        this.fillArchetypeRoot((CArchetypeRoot)child, result);
                    }
                    workList.push(child);
                }
            }
        }
    }

    private void fillComplexObjectProxies(OperationalTemplate result) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(result.getDefinition());
        ArrayList<ComplexObjectProxyReplacement> replacements = new ArrayList<ComplexObjectProxyReplacement>();
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                for (CObject child : attribute.getChildren()) {
                    if (child instanceof CComplexObjectProxy) {
                        ComplexObjectProxyReplacement possibleReplacement = ComplexObjectProxyReplacement.getComplexObjectProxyReplacement((CComplexObjectProxy)((CComplexObjectProxy)child));
                        if (possibleReplacement != null) {
                            replacements.add(possibleReplacement);
                        } else {
                            throw new RuntimeException("cannot find target in CComplexObjectProxy");
                        }
                    }
                    workList.push(child);
                }
            }
        }
        for (ComplexObjectProxyReplacement replacement : replacements) {
            replacement.replace();
        }
    }

    private void fillArchetypeRoot(CArchetypeRoot root, OperationalTemplate result) {
        if (this.flattener.getCreateOperationalTemplate()) {
            String archetypeRef;
            String newArchetypeRef = archetypeRef = root.getArchetypeRef();
            Archetype archetype = this.flattener.getRepository().getArchetype(archetypeRef);
            if (archetype instanceof TemplateOverlay) {
                newArchetypeRef = archetype.getParentArchetypeId();
            }
            if (archetype == null) {
                throw new IllegalArgumentException("Archetype with reference :" + archetypeRef + " not found.");
            }
            archetype = this.flattener.getNewFlattener().flatten(archetype);
            CArchetypeRoot rootToFill = root;
            if (this.flattener.isUseComplexObjectForArchetypeSlotReplacement()) {
                rootToFill = archetype.getDefinition();
                root.getParent().replaceChild(root.getNodeId(), (CObject)rootToFill);
            } else {
                rootToFill.setAttributes(archetype.getDefinition().getAttributes());
                rootToFill.setAttributeTuples(archetype.getDefinition().getAttributeTuples());
                rootToFill.setDefaultValue(archetype.getDefinition().getDefaultValue());
            }
            String newNodeId = archetype.getArchetypeId().getFullId();
            ArchetypeTerminology terminology = archetype.getTerminology();
            Map termDefinitions = terminology.getTermDefinitions();
            for (String language : termDefinitions.keySet()) {
                Map translations = (Map)termDefinitions.get(language);
                translations.put(newNodeId, TerminologyFlattener.getTerm(terminology.getTermDefinitions(), language, archetype.getDefinition().getNodeId()));
            }
            if (!this.flattener.isUseComplexObjectForArchetypeSlotReplacement()) {
                root.setArchetypeRef(newNodeId);
            }
            if (archetype instanceof OperationalTemplate) {
                OperationalTemplate template = (OperationalTemplate)archetype;
                for (String subarchetypeId : template.getComponentTerminologies().keySet()) {
                    result.addComponentTerminology(subarchetypeId, (ArchetypeTerminology)template.getComponentTerminologies().get(subarchetypeId));
                }
            }
            result.addComponentTerminology(newNodeId, terminology);
            String prefix = archetype.getArchetypeId().getConceptId() + "_";
            this.flattener.getRulesFlattener().combineRules(archetype, root.getArchetype(), prefix, prefix, rootToFill.getPath(), false);
            this.flattener.getAnnotationsFlattener().addAnnotationsWithPathPrefix(rootToFill.getPath(), archetype, result);
        }
    }
}

