/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.flattener.FlattenerUtil;
import com.nedap.archie.flattener.IAttributeFlattenerSupport;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.paths.PathUtil;
import com.nedap.archie.query.AOMPathQuery;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.query.ComplexObjectProxyReplacement;
import com.nedap.archie.rminfo.MetaModels;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class CAttributeFlattener {
    private final IAttributeFlattenerSupport flattener;

    public CAttributeFlattener(IAttributeFlattenerSupport flattener) {
        this.flattener = flattener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flattenSingleAttribute(CComplexObject newObject, CAttribute attribute) {
        if (attribute.getDifferentialPath() != null) {
            ArchetypeModelObject object = new AOMPathQuery(attribute.getDifferentialPath()).dontFindThroughCComplexObjectProxies().find(newObject);
            if (object == null) {
                CComplexObjectProxy internalReference = new AOMPathQuery(attribute.getDifferentialPath()).findAnyInternalReference(newObject);
                if (internalReference != null) {
                    ComplexObjectProxyReplacement complexObjectProxyReplacement = ComplexObjectProxyReplacement.getComplexObjectProxyReplacement((CComplexObjectProxy)internalReference);
                    if (complexObjectProxyReplacement == null) throw new RuntimeException("cannot find target in CComplexObjectProxy");
                    complexObjectProxyReplacement.replace();
                    this.flattenSingleAttribute(newObject, attribute);
                    return;
                }
                List pathSegments = new APathQuery(attribute.getDifferentialPath()).getPathSegments();
                String pathMinusLastNode = PathUtil.getPath(pathSegments.subList(0, pathSegments.size() - 1));
                CObject parentObject = (CObject)newObject.itemAtPath(pathMinusLastNode);
                if (parentObject == null) return;
                if (!(parentObject instanceof CComplexObject)) return;
                CAttribute realAttribute = new CAttribute(((PathSegment)pathSegments.get(pathSegments.size() - 1)).getNodeName());
                ((CComplexObject)parentObject).addAttribute(realAttribute);
                this.flattenAttribute(newObject, realAttribute, attribute);
                return;
            }
            if (object instanceof CAttribute) {
                CAttribute realAttribute = (CAttribute)object;
                this.flattenAttribute(newObject, realAttribute, attribute);
                return;
            }
            if (!(object instanceof CObject)) return;
            return;
        } else {
            this.flattenAttribute(newObject, newObject.getAttribute(attribute.getRmAttributeName()), attribute);
        }
    }

    public CAttribute flattenAttribute(CComplexObject root, CAttribute attributeInParent, CAttribute attributeInSpecialization) {
        if (attributeInParent == null) {
            CAttribute childCloned = attributeInSpecialization.clone();
            root.addAttribute(childCloned);
            return childCloned;
        }
        attributeInParent.setExistence(FlattenerUtil.getPossiblyOverridenValue(attributeInParent.getExistence(), attributeInSpecialization.getExistence()));
        attributeInParent.setCardinality(FlattenerUtil.getPossiblyOverridenValue(attributeInParent.getCardinality(), attributeInSpecialization.getCardinality()));
        if (attributeInSpecialization.getChildren().size() > 0 && attributeInSpecialization.getChildren().get(0) instanceof CPrimitiveObject) {
            attributeInParent.setChildren(attributeInSpecialization.getChildren());
        } else {
            this.reorderSiblingOrdersReferringToSameLevel(attributeInSpecialization);
            SiblingOrder anchor = null;
            List parentCObjects = attributeInParent.getChildren();
            for (CObject specializedChildCObject : attributeInSpecialization.getChildren()) {
                CObject matchingParentObject = this.findMatchingParentCObject(specializedChildCObject, parentCObjects);
                if (specializedChildCObject.getSiblingOrder() != null) {
                    anchor = specializedChildCObject.getSiblingOrder();
                }
                if (anchor != null) {
                    this.mergeObjectIntoAttribute(attributeInParent, specializedChildCObject, matchingParentObject, attributeInSpecialization.getChildren(), anchor);
                    anchor = this.nextAnchor(anchor, specializedChildCObject);
                    continue;
                }
                CObject specializedObject = this.flattener.createSpecializeCObject(attributeInParent, matchingParentObject, specializedChildCObject);
                if (matchingParentObject == null) {
                    attributeInParent.addChild(specializedObject);
                    continue;
                }
                attributeInParent.addChild(specializedObject, SiblingOrder.createAfter((String)this.findLastSpecializedChildDirectlyAfter(attributeInParent, matchingParentObject)));
                if (!this.shouldRemoveParent(specializedChildCObject, matchingParentObject, attributeInSpecialization.getChildren())) continue;
                attributeInParent.removeChild(matchingParentObject.getNodeId());
            }
        }
        return attributeInParent;
    }

    private SiblingOrder nextAnchor(SiblingOrder lastAnchor, CObject lastSpecializedObject) {
        if (lastAnchor.isBefore()) {
            return lastAnchor;
        }
        return SiblingOrder.createAfter((String)lastSpecializedObject.getNodeId());
    }

    private void mergeObjectIntoAttribute(CAttribute parentAttribute, CObject specializedChildCObject, CObject matchingParentObject, List<CObject> allSpecializedChildren, SiblingOrder siblingOrder) {
        CObject specializedObject = this.flattener.createSpecializeCObject(parentAttribute, matchingParentObject, specializedChildCObject);
        if (this.shouldRemoveParent(specializedChildCObject, matchingParentObject, allSpecializedChildren)) {
            parentAttribute.removeChild(matchingParentObject.getNodeId());
        }
        parentAttribute.addChild(specializedObject, siblingOrder);
    }

    private void reorderSiblingOrdersReferringToSameLevel(CAttribute parent) {
        for (CObject cObject : new ArrayList(parent.getChildren())) {
            String matchingNodeId;
            if (cObject.getSiblingOrder() == null || (matchingNodeId = this.findCObjectMatchingSiblingOrder(cObject.getSiblingOrder(), parent.getChildren())) == null) continue;
            parent.removeChild(cObject.getNodeId());
            SiblingOrder siblingOrder = new SiblingOrder();
            siblingOrder.setSiblingNodeId(matchingNodeId);
            siblingOrder.setBefore(cObject.getSiblingOrder().isBefore());
            parent.addChild(cObject, siblingOrder);
            cObject.setSiblingOrder(null);
        }
    }

    private String findCObjectMatchingSiblingOrder(SiblingOrder siblingOrder, List<CObject> cObjectList) {
        for (CObject object : cObjectList) {
            if (!AOMUtils.isOverriddenIdCode((String)object.getNodeId(), (String)siblingOrder.getSiblingNodeId())) continue;
            return object.getNodeId();
        }
        return null;
    }

    private String findLastSpecializedChildDirectlyAfter(CAttribute parent, CObject matchingParentObject) {
        int matchingIndex = parent.getIndexOfChildWithNodeId(matchingParentObject.getNodeId());
        String result = matchingParentObject.getNodeId();
        for (int i = matchingIndex + 1; i < parent.getChildren().size(); ++i) {
            if (!AOMUtils.isOverriddenIdCode((String)((CObject)parent.getChildren().get(i)).getNodeId(), (String)matchingParentObject.getNodeId())) continue;
            result = ((CObject)parent.getChildren().get(i)).getNodeId();
        }
        return result;
    }

    private boolean shouldRemoveParent(CObject specializedChildCObject, CObject matchingParentObject, List<CObject> allSpecializedChildren) {
        if (matchingParentObject == null) {
            return false;
        }
        ArrayList<CObject> allMatchingChildren = new ArrayList<CObject>();
        for (CObject specializedChild : allSpecializedChildren) {
            if (!AOMUtils.isOverridenCObject((CObject)specializedChild, (CObject)matchingParentObject)) continue;
            allMatchingChildren.add(specializedChild);
        }
        boolean hasSameNodeIdInMatchingChildren = allMatchingChildren.stream().anyMatch(c -> c.getNodeId().equals(matchingParentObject.getNodeId()));
        if (hasSameNodeIdInMatchingChildren) {
            return specializedChildCObject.getNodeId().equalsIgnoreCase(matchingParentObject.getNodeId());
        }
        if (((CObject)allMatchingChildren.get(allMatchingChildren.size() - 1)).getNodeId().equalsIgnoreCase(specializedChildCObject.getNodeId())) {
            return this.shouldReplaceSpecializedParent(matchingParentObject, allMatchingChildren);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean shouldReplaceSpecializedParent(CObject parent, List<CObject> differentialNodes) {
        block5: {
            occurrences = parent.effectiveOccurrences((BiFunction<String, String, MultiplicityInterval>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, referenceModelPropMultiplicity(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Lcom/nedap/archie/base/MultiplicityInterval;)((MetaModels)this.flattener.getMetaModels()));
            if (this.isSingle(parent.getParent())) {
                return true;
            }
            if (occurrences != null && occurrences.upperIsOne()) {
                return true;
            }
            if (differentialNodes.size() != 1) break block5;
            if (parent.getParent() == null) ** GOTO lbl15
            if (parent.getParent().getParent() == null) {
lbl15:
                // 2 sources

                effectiveOccurrences = differentialNodes.get(0).effectiveOccurrences((BiFunction<String, String, MultiplicityInterval>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, referenceModelPropMultiplicity(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Lcom/nedap/archie/base/MultiplicityInterval;)((MetaModels)this.flattener.getMetaModels()));
            } else {
                effectiveOccurrences = differentialNodes.get(0).effectiveOccurrences((BiFunction<String, String, MultiplicityInterval>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$shouldReplaceSpecializedParent$1(com.nedap.archie.aom.CObject java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Lcom/nedap/archie/base/MultiplicityInterval;)((CAttributeFlattener)this, (CObject)parent));
            }
            if (effectiveOccurrences != null && effectiveOccurrences.upperIsOne()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSingle(CAttribute attribute) {
        if (attribute != null && attribute.getParent() != null && attribute.getDifferentialPath() == null) {
            return !this.flattener.getMetaModels().isMultiple(attribute.getParent().getRmTypeName(), attribute.getRmAttributeName());
        }
        return false;
    }

    private CObject findMatchingParentCObject(CObject specializedChildCObject, List<CObject> parentCObjects) {
        for (CObject parentCObject : parentCObjects) {
            if (!AOMUtils.isOverridenCObject((CObject)specializedChildCObject, (CObject)parentCObject)) continue;
            return parentCObject;
        }
        return null;
    }

    private /* synthetic */ MultiplicityInterval lambda$shouldReplaceSpecializedParent$1(CObject parent, String s, String s2) {
        return this.flattener.getMetaModels().referenceModelPropMultiplicity(parent.getParent().getParent().getRmTypeName(), parent.getParent().getRmAttributeName());
    }
}

