/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.ResourceAnnotations;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotationsFlattener {
    public void flatten(Archetype parent, Archetype child, Archetype result) {
        if (this.isAnnotationsEmpty(parent) && this.isAnnotationsEmpty(child)) {
            return;
        }
        ResourceAnnotations resultAnnotation = this.ensureAnnotationsPresent(result);
        Map resultDocumentation = resultAnnotation.getDocumentation();
        this.mergeInAnnotations(parent, resultDocumentation);
        this.mergeInAnnotations(child, resultDocumentation);
    }

    private ResourceAnnotations ensureAnnotationsPresent(Archetype result) {
        ResourceAnnotations resultAnnotation = result.getAnnotations();
        if (resultAnnotation == null) {
            resultAnnotation = new ResourceAnnotations();
            result.setAnnotations(resultAnnotation);
        }
        if (resultAnnotation.getDocumentation() == null) {
            resultAnnotation.setDocumentation(new LinkedHashMap());
        }
        return resultAnnotation;
    }

    private void mergeInAnnotations(Archetype toBeMergedIn, Map<String, Map<String, Map<String, String>>> resultDocumentation) {
        if (!this.isAnnotationsEmpty(toBeMergedIn)) {
            ResourceAnnotations toBeMergedInAnnotations = toBeMergedIn.getAnnotations();
            Map toBeMergedInDocumentation = toBeMergedInAnnotations.getDocumentation();
            this.mergeDocumentation(resultDocumentation, toBeMergedInDocumentation);
        }
    }

    private void mergeDocumentation(Map<String, Map<String, Map<String, String>>> resultDocumentation, Map<String, Map<String, Map<String, String>>> documentationToBeMergedIn) {
        for (String language : documentationToBeMergedIn.keySet()) {
            Map<String, Map<String, String>> languageAnnotationsToBeMergedIn = documentationToBeMergedIn.get(language);
            Map<String, Map<String, String>> resultLanguageAnnotations = resultDocumentation.get(language);
            if (resultLanguageAnnotations == null) {
                resultLanguageAnnotations = new LinkedHashMap<String, Map<String, String>>();
                resultDocumentation.put(language, resultLanguageAnnotations);
            }
            for (String path : languageAnnotationsToBeMergedIn.keySet()) {
                Map<String, String> pathAnnotationsToBeMergedIn = languageAnnotationsToBeMergedIn.get(path);
                Map<String, String> resultPathAnnotations = resultLanguageAnnotations.get(path);
                if (resultPathAnnotations == null) {
                    resultPathAnnotations = new LinkedHashMap<String, String>();
                    resultLanguageAnnotations.put(path, resultPathAnnotations);
                }
                resultPathAnnotations.putAll(pathAnnotationsToBeMergedIn);
            }
        }
    }

    private boolean isAnnotationsEmpty(Archetype archetype) {
        return archetype.getAnnotations() == null || archetype.getAnnotations().getDocumentation() == null || archetype.getAnnotations().getDocumentation().isEmpty();
    }

    public void addAnnotationsWithPathPrefix(String pathPrefix, Archetype archetype, OperationalTemplate result) {
        if (this.isAnnotationsEmpty(archetype)) {
            return;
        }
        Map documentationToBeMergedIn = archetype.getAnnotations().getDocumentation();
        for (String language : documentationToBeMergedIn.keySet()) {
            Map languageAnnotationsToBeMergedIn = (Map)documentationToBeMergedIn.get(language);
            for (String path : languageAnnotationsToBeMergedIn.keySet()) {
                String newPath = this.ensureNoSlashAtEnd(pathPrefix) + path;
                this.merge(language, newPath, (Map)languageAnnotationsToBeMergedIn.get(path), result);
            }
        }
    }

    private void merge(String language, String newPath, Map<String, String> annotationsMap, OperationalTemplate result) {
        LinkedHashMap<String, String> existingAnnotations;
        ResourceAnnotations annotations = this.ensureAnnotationsPresent((Archetype)result);
        LinkedHashMap<String, LinkedHashMap<String, String>> languageMap = (LinkedHashMap<String, LinkedHashMap<String, String>>)annotations.getDocumentation().get(language);
        if (languageMap == null) {
            languageMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            annotations.getDocumentation().put(language, languageMap);
        }
        if ((existingAnnotations = (LinkedHashMap<String, String>)languageMap.get(newPath)) == null) {
            existingAnnotations = new LinkedHashMap<String, String>(annotationsMap);
            languageMap.put(newPath, existingAnnotations);
        } else {
            existingAnnotations.putAll(annotationsMap);
        }
    }

    private String ensureNoSlashAtEnd(String pathPrefix) {
        if (pathPrefix.endsWith("/")) {
            return pathPrefix.substring(0, pathPrefix.length() - 1);
        }
        return pathPrefix;
    }
}

