/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.creation;

import com.google.common.collect.Lists;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RMObjectCreator {
    private final ModelInfoLookup modelInfoLookup;

    public RMObjectCreator(ModelInfoLookup lookup) {
        this.modelInfoLookup = lookup;
    }

    public <T> T create(CObject constraint) {
        Class clazz = this.modelInfoLookup.getClassToBeCreated(constraint.getRmTypeName());
        if (clazz == null) {
            throw new IllegalArgumentException("cannot construct RMObject because of unknown constraint name " + constraint.getRmTypeName() + " full constraint " + constraint);
        }
        try {
            Object result = clazz.newInstance();
            this.modelInfoLookup.processCreatedObject(result, constraint);
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("error creating class " + constraint.getRmTypeName(), e);
        }
    }

    public void set(Object object, String rmAttributeName, List<Object> values) {
        try {
            RMAttributeInfo attributeInfo = this.modelInfoLookup.getAttributeInfo(object.getClass(), rmAttributeName);
            if (attributeInfo == null) {
                throw new IllegalArgumentException(String.format("Attribute %s not known for object %s", rmAttributeName, object.getClass().getSimpleName()));
            }
            Class type = attributeInfo.getType();
            if (type instanceof Class) {
                Class clazz = type;
                if (attributeInfo.isMultipleValued()) {
                    Collection collection = (Collection)this.newInstance(attributeInfo);
                    if (values != null) {
                        collection.addAll(values);
                    }
                    this.setField(object, attributeInfo, collection);
                } else {
                    this.setSingleValuedAttribute(object, rmAttributeName, values, attributeInfo);
                }
            } else {
                this.setSingleValuedAttribute(object, rmAttributeName, values, attributeInfo);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void setSingleValuedAttribute(Object object, String rmAttributeName, List<Object> values, RMAttributeInfo attributeInfo) throws InvocationTargetException, IllegalAccessException {
        if (values == null || values.isEmpty()) {
            this.setField(object, attributeInfo, null);
        } else {
            if (values.size() > 1) {
                throw new IllegalArgumentException(String.format("trying to set multiple values for a single valued field, class %s field %s", object.getClass().getSimpleName(), rmAttributeName));
            }
            this.setField(object, attributeInfo, values.get(0));
        }
    }

    private Object newInstance(RMAttributeInfo attributeInfo) throws InstantiationException, IllegalAccessException {
        if (attributeInfo.getType().equals(List.class)) {
            return new ArrayList();
        }
        if (attributeInfo.getType().equals(Set.class)) {
            return new LinkedHashSet();
        }
        if (attributeInfo.getType() instanceof Class) {
            return attributeInfo.getType().newInstance();
        }
        throw new IllegalArgumentException("cannot create collection instanceof " + attributeInfo.toString());
    }

    private void setField(Object object, RMAttributeInfo field, Object value) throws InvocationTargetException, IllegalAccessException {
        Method setMethod = field.getSetMethod();
        if (setMethod == null) {
            throw new IllegalArgumentException(String.format("field %s of class %s is not a settable field - it has no set method", field.getRmName(), object.getClass().getSimpleName()));
        }
        try {
            setMethod.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            Class<?> valueType = value == null ? null : value.getClass();
            throw new InvocationTargetException(e.getTargetException(), "Error setting value '" + value + "' of type '" + valueType + "' using method '" + setMethod + "'");
        }
    }

    public void addElementToList(Object object, RMAttributeInfo attributeInfo, Object element) {
        block6: {
            try {
                if (attributeInfo.getAddMethod() != null) {
                    attributeInfo.getAddMethod().invoke(object, element);
                    break block6;
                }
                Object collectionValue = attributeInfo.getGetMethod().invoke(object, new Object[0]);
                if (!(attributeInfo.getType() instanceof Class)) {
                    throw new IllegalArgumentException("trying to add an element to an object with type " + attributeInfo.getType());
                }
                if (Collection.class.isAssignableFrom(attributeInfo.getType())) {
                    if (collectionValue == null) {
                        collectionValue = this.newInstance(attributeInfo);
                        this.setField(object, attributeInfo, collectionValue);
                    }
                    Collection collection = (Collection)collectionValue;
                    collection.add(element);
                    break block6;
                }
                throw new IllegalArgumentException("trying to add an element to an object with type " + attributeInfo.getType());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addElementToListOrSetSingleValues(Object object, String rmAttributeName, Object element) {
        RMAttributeInfo attributeInfo = this.modelInfoLookup.getAttributeInfo(object.getClass(), rmAttributeName);
        if (attributeInfo == null) {
            throw new IllegalArgumentException(String.format("Attribute %s not known for object %s", rmAttributeName, object.getClass().getSimpleName()));
        }
        if (!attributeInfo.isMultipleValued()) {
            if (element instanceof Collection) {
                this.set(object, rmAttributeName, new ArrayList<Object>((Collection)element));
            } else {
                this.set(object, rmAttributeName, Lists.newArrayList((Object[])new Object[]{element}));
            }
        } else if (element instanceof Collection) {
            Collection collection = (Collection)element;
            for (Object el : collection) {
                this.addElementToList(object, attributeInfo, el);
            }
        } else {
            this.addElementToList(object, attributeInfo, element);
        }
    }
}

