/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.flattener.FullArchetypeRepository;
import com.nedap.archie.rules.Assertion;
import java.util.List;
import org.openehr.utils.message.I18n;

public class VariousStructureValidation
extends ValidatingVisitor {
    protected void beginValidation(Archetype archetype, Archetype flatParent, FullArchetypeRepository repository) {
        this.archetype = archetype;
        this.flatParent = flatParent;
        this.repository = repository;
    }

    @Override
    protected void validate(ArchetypeSlot slot) {
        List includes = slot.getIncludes();
        List excludes = slot.getExcludes();
        if (!includes.isEmpty()) {
            if (((Assertion)includes.get(0)).matchesAny()) {
                if (!excludes.isEmpty() && ((Assertion)excludes.get(0)).matchesAny()) {
                    this.addMessageWithPath(ErrorType.VDSEV, slot.path());
                }
            } else if (!excludes.isEmpty() && !((Assertion)excludes.get(0)).matchesAny()) {
                this.addMessageWithPath(ErrorType.VDSEV, slot.path());
            }
        }
    }

    @Override
    protected void validate(CComplexObject cComplexObject) {
        if (cComplexObject instanceof CArchetypeRoot) {
            CArchetypeRoot archetypeRoot = (CArchetypeRoot)cComplexObject;
            if (archetypeRoot.getArchetypeRef() != null) {
                if (this.repository.getArchetype(archetypeRoot.getArchetypeRef()) == null) {
                    this.addMessageWithPath(ErrorType.VARXRA, cComplexObject.path(), I18n.t((String)"Archetype with id {0} used in use_archetype, but it was not found", (Object[])new Object[]{archetypeRoot.getArchetypeRef()}));
                }
                ArchetypeHRID hrId = new ArchetypeHRID(archetypeRoot.getArchetypeRef());
                String archetypeRootTypeName = cComplexObject.getRmTypeName();
                String archetypeReferenceTypeName = hrId.getRmClass();
                if (this.combinedModels.typeNameExists(archetypeRootTypeName)) {
                    if (!this.combinedModels.typeNameExists(archetypeReferenceTypeName)) {
                        this.addMessageWithPath(ErrorType.VCORM, cComplexObject.getPath(), I18n.t((String)"Archetype referenced in use_archetype points to class {0}, which does not exist in this reference model", (Object[])new Object[]{cComplexObject.getRmTypeName()}));
                    } else if (!this.combinedModels.rmTypesConformant(archetypeReferenceTypeName, archetypeRootTypeName)) {
                        this.addMessageWithPath(ErrorType.VARXTV, cComplexObject.getPath(), I18n.t((String)"Use_archetype points to type {0}, which is not conformant for type {1} of the archetype root used", (Object[])new Object[]{cComplexObject.getRmTypeName(), archetypeRootTypeName}));
                    }
                }
            } else if (archetypeRoot.getOccurrences() == null || !archetypeRoot.getOccurrences().isProhibited()) {
                this.addMessageWithPath(ErrorType.VARXR, archetypeRoot.getPath(), I18n.t((String)"Archetype root must have an archetype reference or be prohibited (occurrences matches 0)", (Object[])new Object[0]));
            }
        }
    }
}

