/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.query.AOMPathQuery;
import com.nedap.archie.query.ComplexObjectProxyReplacement;
import java.util.List;
import java.util.Map;
import org.openehr.utils.message.I18n;

public class FlatFormValidation
extends ValidatingVisitor {
    @Override
    protected void validate(CComplexObjectProxy cObject) {
        List replacements = new AOMPathQuery(cObject.getTargetPath()).findList(ComplexObjectProxyReplacement.getNearestArchetypeRoot((CObject)cObject), true);
        if (replacements.size() == 0) {
            this.addMessageWithPath(ErrorType.VUNP, cObject.path(), I18n.t((String)"Use_node (C_COMPLEX_OBJECT_PROXY) points to a path that cannot be found: {0}", (Object[])new Object[]{cObject.getTargetPath()}));
        } else if (replacements.size() > 1) {
            this.addMessageWithPath(ErrorType.VUNP, cObject.path(), I18n.t((String)"Use_node (C_COMPLEX_OBJECT_PROXY) points to a path that resolves to more than one object", (Object[])new Object[0]));
        } else {
            ArchetypeModelObject replacement = (ArchetypeModelObject)replacements.get(0);
            if (replacement instanceof CComplexObject) {
                ComplexObjectProxyReplacement complexObjectProxyReplacement = ComplexObjectProxyReplacement.getComplexObjectProxyReplacement((CComplexObjectProxy)cObject);
                CComplexObject replacementComplexObject = complexObjectProxyReplacement.getReplacement();
                if (!this.combinedModels.rmTypesConformant(replacementComplexObject.getRmTypeName(), cObject.getRmTypeName())) {
                    this.addMessageWithPath(ErrorType.VUNT, cObject.path(), I18n.t((String)"Use_node (C_COMPLEX_OBJECT_PROXY) points to type {0}, which does not conform to type {1}", (Object[])new Object[]{replacementComplexObject.getRmTypeName(), cObject.getRmTypeName()}));
                }
            } else {
                String cObjectTypeName = cObject instanceof CComplexObjectProxy ? "use_node (C_COMPLEX_OBJECT)" : cObject.getClass().getSimpleName();
                this.addMessageWithPath(ErrorType.VUNP, cObject.path(), I18n.t((String)"Use_node (C_COMPLEX_OBJECT_PROXY) must point to a C_COMPLEX_OBJECT, but points to a {0}", (Object[])new Object[]{cObjectTypeName}));
            }
        }
    }

    @Override
    protected void validate(CAttribute cAttribute) {
        Cardinality cardinality = cAttribute.getCardinality();
        if (cardinality != null && !cardinality.getInterval().isUpperUnbounded()) {
            if (cAttribute.getAggregateOccurrencesLowerSum() > (Integer)cardinality.getInterval().getUpper()) {
                this.addWarningWithPath(ErrorType.WACMCL, cAttribute.path(), I18n.t((String)"The occurrences of all C_OBJECTS under this attributes is at least {0}, which does not fit in the upper limit of the cardinality of the attribute, {1}", (Object[])new Object[]{cAttribute.getAggregateOccurrencesLowerSum(), cardinality.getInterval().getUpper()}));
            } else if (cAttribute.getMinimumChildCount() > (Integer)cardinality.getInterval().getUpper()) {
                this.addMessageWithPath(ErrorType.VACMCO, cAttribute.path(), I18n.t((String)"The attribute contains {0} objects that are required, but only has an upper cardinality of {1}", (Object[])new Object[]{cAttribute.getMinimumChildCount(), cardinality.getInterval().getUpper()}));
            }
        }
    }

    @Override
    protected void beginValidation() {
    }

    private void validateTerminologyBindings() {
        ArchetypeTerminology terminology = this.archetype.getTerminology();
        Map termBindings = terminology.getTermBindings();
        for (String terminologyId : termBindings.keySet()) {
            for (String constraintCodeOrPath : ((Map)termBindings.get(terminologyId)).keySet()) {
                boolean archetypeHasPath = false;
                try {
                    archetypeHasPath = this.archetype.hasPath(constraintCodeOrPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(AOMUtils.isValidCode((String)constraintCodeOrPath) || archetypeHasPath || this.combinedModels.hasReferenceModelPath(this.archetype.getDefinition().getRmTypeName(), constraintCodeOrPath))) {
                    this.addMessage(ErrorType.VTTBK, I18n.t((String)"Term binding key {0} points to a path that cannot be found in the archetype", (Object[])new Object[]{constraintCodeOrPath}));
                    continue;
                }
                if (!AOMUtils.isValidCode((String)constraintCodeOrPath) || terminology.hasCode(constraintCodeOrPath) || this.archetype.isSpecialized() && this.flatParent != null && !this.flatParent.getTerminology().hasCode(constraintCodeOrPath)) continue;
                this.addMessage(ErrorType.VTTBK, I18n.t((String)"Term binding key {0} is not present in the terminology", (Object[])new Object[]{constraintCodeOrPath}));
            }
        }
    }
}

