/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import java.util.List;
import org.openehr.utils.message.I18n;

public class DefinitionStructureValidation
extends ValidatingVisitor {
    @Override
    protected void validate(CAttribute cAttribute) {
        if (cAttribute.getDifferentialPath() != null) {
            if (this.archetype.getParentArchetypeId() == null) {
                this.addMessageWithPath(ErrorType.VDIFV, cAttribute.path(), I18n.t((String)"A differential path was used in an attribute, but this is not allowed in an archetype that has no parent", (Object[])new Object[0]));
            } else if (this.repository != null && this.flatParent != null) {
                ArchetypeModelObject parentAOMObject = this.flatParent.itemAtPath(AOMUtils.pathAtSpecializationLevel((List)cAttribute.getParent().getPathSegments(), (int)this.flatParent.specializationDepth()));
                ArchetypeModelObject differentialPathInParent = null;
                List pathSegments = new APathQuery(cAttribute.getDifferentialPath()).getPathSegments();
                if (parentAOMObject == null || !(parentAOMObject instanceof CComplexObject)) {
                    this.addPathNotFoundInParentError(cAttribute);
                } else {
                    CComplexObject parentObject = (CComplexObject)parentAOMObject;
                    differentialPathInParent = parentObject.itemAtPath(AOMUtils.pathAtSpecializationLevel((List)pathSegments, (int)this.flatParent.specializationDepth()));
                    if (differentialPathInParent == null) {
                        String pathMinuLastNode = AOMUtils.pathAtSpecializationLevel(pathSegments.subList(0, pathSegments.size() - 1), (int)this.flatParent.specializationDepth());
                        CObject parent = (CObject)parentObject.itemAtPath(pathMinuLastNode);
                        if (parent == null || parent.isRoot()) {
                            this.addPathNotFoundInParentError(cAttribute);
                        } else {
                            PathSegment terminalNode = (PathSegment)pathSegments.get(pathSegments.size() - 1);
                            if (!this.combinedModels.attributeExists(parent.getRmTypeName(), terminalNode.getNodeName())) {
                                this.addPathNotFoundInParentError(cAttribute);
                            }
                        }
                    } else if (!(differentialPathInParent instanceof CAttribute)) {
                        this.addMessageWithPath(ErrorType.VDIFP, cAttribute.getDifferentialPath(), I18n.t((String)"Differential path must point to a C_ATTRIBUTE in the flat parent, but it pointed instead to a {0}", (Object[])new Object[]{differentialPathInParent.getClass()}));
                    }
                }
            }
        }
    }

    private void addPathNotFoundInParentError(CAttribute cAttribute) {
        this.addMessageWithPath(ErrorType.VDIFP, cAttribute.getPath(), I18n.t((String)"Differential path {0} was not found in the parent archetype", (Object[])new Object[]{cAttribute.getDifferentialPath()}));
    }
}

