/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.google.common.base.Joiner;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import org.openehr.utils.message.I18n;

public class CodeValidation
extends ValidatingVisitor {
    @Override
    public void validate(CObject cObject) {
        int archetypeSpecializationDepth;
        String nodeId;
        int codeSpecializationDepth;
        if (cObject instanceof CTerminologyCode) {
            this.validate((CTerminologyCode)cObject);
        }
        if ((codeSpecializationDepth = AOMUtils.getSpecializationDepthFromCode((String)(nodeId = cObject.getNodeId()))) > (archetypeSpecializationDepth = this.archetype.specializationDepth())) {
            this.addMessageWithPath(ErrorType.VTSD, cObject.path(), I18n.t((String)"The code specialization depth of code {0} is {1}, which is greater than archetype specialization depth {2}", (Object[])new Object[]{nodeId, codeSpecializationDepth, archetypeSpecializationDepth}));
        } else if ((cObject.isRoot() || this.parentIsMultiple(cObject)) && (codeSpecializationDepth < archetypeSpecializationDepth && !this.flatParent.getTerminology().hasIdCode(nodeId) || codeSpecializationDepth == archetypeSpecializationDepth && !this.archetype.getTerminology().hasIdCode(nodeId))) {
            this.addMessageWithPath(ErrorType.VATID, cObject.path(), I18n.t((String)"Node id {0} is used in the archetype, but missing in the terminology", (Object[])new Object[]{nodeId}));
        }
    }

    private boolean parentIsMultiple(CObject cObject) {
        if (cObject.getParent() != null) {
            CAttribute attributeFromParent;
            CAttribute parent = cObject.getParent();
            CObject owningObject = parent.getParent();
            if (parent.getDifferentialPath() != null && this.flatParent != null && (attributeFromParent = (CAttribute)AOMUtils.getDifferentialPathFromParent((Archetype)this.flatParent, (CAttribute)parent)) != null) {
                owningObject = attributeFromParent.getParent();
            }
            if (owningObject != null) {
                return this.combinedModels.isMultiple(owningObject.getRmTypeName(), parent.getRmAttributeName());
            }
        }
        return false;
    }

    public void validate(CTerminologyCode cTerminologyCode) {
        int archetypeSpecializationDepth = this.archetype.specializationDepth();
        for (String constraint : cTerminologyCode.getConstraint()) {
            int codeSpecializationDepth;
            if (AOMUtils.isValueSetCode((String)constraint)) {
                ValueSet valueSet;
                codeSpecializationDepth = AOMUtils.getSpecializationDepthFromCode((String)constraint);
                if (codeSpecializationDepth > archetypeSpecializationDepth) {
                    this.addMessageWithPath(ErrorType.VATCD, cTerminologyCode.path(), I18n.t((String)"Code {0} from the C_TERMINOLOGY_CODE constraint has specialization depth {1}, but this must be no greater than {2}", (Object[])new Object[]{constraint, codeSpecializationDepth, archetypeSpecializationDepth}));
                    continue;
                }
                if (codeSpecializationDepth < archetypeSpecializationDepth && !this.flatParent.getTerminology().hasValueSetCode(constraint) || codeSpecializationDepth == archetypeSpecializationDepth && !this.archetype.getTerminology().hasValueSetCode(constraint)) {
                    this.addMessageWithPath(ErrorType.VACDF, cTerminologyCode.path(), I18n.t((String)"Code {0} from the C_TERMINOLOGY_CODE constraint is not defined in the terminology", (Object[])new Object[]{constraint}));
                    continue;
                }
                if (cTerminologyCode.getAssumedValue() == null || (valueSet = (ValueSet)this.archetype.getTerminology().getValueSets().get(constraint)) == null || valueSet.getMembers().contains(cTerminologyCode.getAssumedValue().getCodeString())) continue;
                this.addMessageWithPath(ErrorType.VATDA, cTerminologyCode.path(), I18n.t((String)"Assumed value {0} from the C_TERMINOLOGY_CODE is not part of value set {1}. Expected one of {2}", (Object[])new Object[]{cTerminologyCode.getAssumedValue(), valueSet.getId(), Joiner.on((String)", ").join((Iterable)valueSet.getMembers())}));
                continue;
            }
            if (!AOMUtils.isValueCode((String)constraint)) continue;
            codeSpecializationDepth = AOMUtils.getSpecializationDepthFromCode((String)constraint);
            if (codeSpecializationDepth > archetypeSpecializationDepth) {
                this.addMessageWithPath(ErrorType.VATCD, cTerminologyCode.path(), I18n.t((String)"Code {0} from the C_TERMINOLOGY_CODE constraint has specialization depth {1}, but this must be no greater than {2}", (Object[])new Object[]{constraint, codeSpecializationDepth, archetypeSpecializationDepth}));
                continue;
            }
            if ((codeSpecializationDepth >= archetypeSpecializationDepth || this.flatParent.getTerminology().hasValueCode(constraint)) && (codeSpecializationDepth != archetypeSpecializationDepth || this.archetype.getTerminology().hasValueCode(constraint))) continue;
            this.addMessageWithPath(ErrorType.VATDF, cTerminologyCode.path(), I18n.t((String)"Code {0} from C_TERMINOLOGY_CODE constraint is not defined in the terminology", (Object[])new Object[]{constraint}));
        }
    }
}

