/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.ResourceDescriptionItem;
import com.nedap.archie.aom.TranslationDetails;
import com.nedap.archie.archetypevalidator.ArchetypeValidationBase;
import com.nedap.archie.archetypevalidator.ErrorType;
import java.util.Objects;
import org.openehr.utils.message.I18n;

public class AuthoredArchetypeMetadataChecks
extends ArchetypeValidationBase {
    @Override
    public void validate() {
        if (this.archetype instanceof AuthoredArchetype) {
            AuthoredArchetype authoredArchetype = (AuthoredArchetype)this.archetype;
            this.checkOriginalLanguagePresent();
            this.checkAdlRmVersionIdFormats();
            this.validateDescription();
            if (this.hasPassed()) {
                this.checkLanguagesInTranslationAreInTerminology();
            }
        }
    }

    private void validateDescription() {
        if (this.archetype.getDescription().getDetails() != null) {
            for (String language : this.archetype.getDescription().getDetails().keySet()) {
                ResourceDescriptionItem resourceDescriptionItem = (ResourceDescriptionItem)this.archetype.getDescription().getDetails().get(language);
                if (resourceDescriptionItem.getLanguage() != null && Objects.equals(language, resourceDescriptionItem.getLanguage().getCodeString())) continue;
                this.addMessage(ErrorType.VRDLA, I18n.t((String)"Resource description language {0} has an incorrect key: {1}", (Object[])new Object[]{language, resourceDescriptionItem.getLanguage() == null ? null : resourceDescriptionItem.getLanguage().getCodeString()}));
            }
        }
    }

    private void checkLanguagesInTranslationAreInTerminology() {
        if (this.archetype.getTranslations() != null) {
            for (String language : this.archetype.getTranslations().keySet()) {
                TranslationDetails translationDetails = (TranslationDetails)this.archetype.getTranslations().get(language);
                if (translationDetails.getLanguage() == null || !language.equals(translationDetails.getLanguage().getCodeString())) {
                    this.addMessage(ErrorType.VTRLA, I18n.t((String)"Translation details language {0} has an incorrect key: {1}", (Object[])new Object[]{language, translationDetails.getLanguage().getCodeString()}));
                }
                if (this.archetype.getTerminology() != null && this.archetype.getTerminology().getTermDefinitions() != null && this.archetype.getTerminology().getTermDefinitions().get(language) != null) continue;
                this.addMessage(ErrorType.VOTM, I18n.t((String)"Language {0} is defined in the translations, but is not present in the terminology", (Object[])new Object[]{language}));
            }
        }
    }

    private void checkAdlRmVersionIdFormats() {
        if (!this.isValidVersion(this.archetype.getAdlVersion())) {
            this.addMessage(ErrorType.VARAV, I18n.t((String)"ADL version {0} is an invalid format for a version, should be x.x.x-(rc|alpha(x)?)?", (Object[])new Object[]{this.archetype.getAdlVersion()}));
        }
        if (!this.isValidVersion(this.archetype.getRmRelease())) {
            this.addMessage(ErrorType.VARRV, I18n.t((String)"RM Release version {0} is an invalid format for a version, should be x.x.x-(rc|alpha(x)?)?", (Object[])new Object[]{this.archetype.getRmRelease()}));
        }
    }

    private void checkOriginalLanguagePresent() {
        if (this.archetype.getOriginalLanguage() != null) {
            String languageCode = this.archetype.getOriginalLanguage().getCodeString();
            if (languageCode != null && this.archetype.getTerminology().getTermDefinitions().get(languageCode) == null) {
                this.addMessage(ErrorType.VOLT, I18n.t((String)"Original language {0} is not defined in the terminology", (Object[])new Object[]{languageCode}));
            }
        } else {
            this.addMessage(ErrorType.VDEOL);
        }
    }

    private boolean isValidVersion(String version) {
        return version != null && version.matches("\\d+\\.\\d+\\.\\d+((-rc|-alpha)(\\.\\d+)?)?");
    }
}

