/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.archetypevalidator.ArchetypeValidation;
import com.nedap.archie.archetypevalidator.ArchetypeValidationSettings;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidationMessage;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.flattener.FullArchetypeRepository;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.ArrayList;
import java.util.List;

public abstract class ArchetypeValidationBase
implements ArchetypeValidation {
    protected Archetype archetype;
    protected Archetype flatParent;
    protected FullArchetypeRepository repository;
    protected List<ValidationMessage> messages;
    protected ModelInfoLookup lookup;
    protected MetaModels combinedModels;
    protected ArchetypeValidationSettings settings;

    @Override
    public List<ValidationMessage> validate(MetaModels models, Archetype archetype, Archetype flatParent, FullArchetypeRepository repository, ArchetypeValidationSettings settings) {
        this.archetype = archetype;
        this.flatParent = flatParent;
        this.repository = repository;
        this.lookup = models.getSelectedModelInfoLookup();
        this.combinedModels = models;
        this.settings = settings;
        this.messages = new ArrayList<ValidationMessage>();
        this.validate();
        return this.messages;
    }

    public abstract void validate();

    public void addMessage(ErrorType errorType) {
        this.messages.add(new ValidationMessage(errorType));
    }

    public void addMessageWithPath(ErrorType errorType, String path) {
        this.messages.add(new ValidationMessage(errorType, path));
    }

    public void addMessageWithPath(ErrorType errorType, String path, String customMessage) {
        this.messages.add(new ValidationMessage(errorType, path, customMessage));
    }

    public void addMessage(ErrorType errorType, String customMessage) {
        this.messages.add(new ValidationMessage(errorType, null, customMessage));
    }

    public void addWarning(ErrorType errorType) {
        ValidationMessage message = new ValidationMessage(errorType);
        message.setWarning(true);
        this.messages.add(message);
    }

    public void addWarning(ErrorType errorType, String customMessage) {
        ValidationMessage message = new ValidationMessage(errorType, null, customMessage);
        message.setWarning(true);
        this.messages.add(message);
    }

    public void addWarningWithPath(ErrorType errorType, String location) {
        ValidationMessage message = new ValidationMessage(errorType, location);
        message.setWarning(true);
        this.messages.add(message);
    }

    public void addWarningWithPath(ErrorType errorType, String location, String customMessage) {
        ValidationMessage message = new ValidationMessage(errorType, location, customMessage);
        message.setWarning(true);
        this.messages.add(message);
    }

    public boolean hasPassed() {
        return this.messages.isEmpty();
    }

    public ModelInfoLookup getLookup() {
        return this.lookup;
    }

    public Archetype getArchetype() {
        return this.archetype;
    }

    public Archetype getFlatParent() {
        return this.flatParent;
    }

    public ArchetypeRepository getRepository() {
        return this.repository;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public ArchetypeValidationSettings getSettings() {
        return this.settings;
    }
}

