/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.referencemodels;

import com.nedap.archie.aom.profile.AomProfile;
import com.nedap.archie.aom.profile.AomProfiles;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import com.nedap.archie.rminfo.ReferenceModels;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openehr.bmm.v2.persistence.odin.BmmOdinParser;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmSchemaConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinReferenceModels {
    private static final Logger logger = LoggerFactory.getLogger(BuiltinReferenceModels.class);
    private static AomProfiles aomProfiles;
    private static BmmRepository bmmRepository;

    public static BmmRepository getBmmRepository() {
        if (bmmRepository != null) {
            return bmmRepository;
        }
        String[] resources = new String[]{"bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_demographic_104.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_structures_102.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_ehr_103.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_primitive_types_102.bmm", "bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_ehr_extract_104.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_rm_103.bmm", "bmm/openEHR/components/BASE/Release-1.1.0/openehr_base_110.bmm", "bmm/openEHR/components/RM/rejected/openehr_ehr_extract_999.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_demographic_102.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_ehr_102.bmm", "bmm/openEHR/components/LANG/Release-1.0.0/openehr_lang_100.bmm", "bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_ehr_104.bmm", "bmm/openEHR/components/PROC/latest/openehr_proc_task_planning_110.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_rm_102.bmm", "bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_structures_104.bmm", "bmm/FHIR/DSTU/BMM/hl7_fhir_resourceses_dstu.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_demographic_103.bmm", "bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_104.bmm", "bmm/openEHR/components/BASE/Release-1.0.0/openehr_base_100.bmm", "bmm/openEHR/adl_test/Release-1.0.0/BMM/openehr_adltest_100.bmm", "bmm/openEHR/components/PROC/Release-1.0.0/openehr_proc_task_planning_100.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_structures_103.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_ehr_extract_103.bmm", "bmm/openEHR/original/Release-1.0.2/openehr_basic_types_102.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_primitive_types_103.bmm", "bmm/openEHR/components/RM/Release-1.0.3/openehr_basic_types_103.bmm", "bmm/openEHR/components/RM/Release-1.0.4/openehr_rm_data_types_104.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_110.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_data_types_110.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_demographic_110.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_ehr_110.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_ehr_extract_110.bmm", "bmm/openEHR/components/RM/Release-1.1.0/openehr_rm_structures_110.bmm"};
        bmmRepository = new BmmRepository();
        for (String resourceName : resources) {
            logger.info("parsing " + resourceName);
            try (InputStream stream = BuiltinReferenceModels.class.getResourceAsStream("/" + resourceName);){
                bmmRepository.addPersistentSchema(BmmOdinParser.convert((InputStream)stream));
            }
            catch (IOException e) {
                throw new RuntimeException("error loading file: " + e);
            }
            catch (RuntimeException ex) {
                logger.error("error parsing {}", (Object)resourceName, (Object)ex);
            }
        }
        BmmSchemaConverter converter = new BmmSchemaConverter(bmmRepository);
        converter.validateAndConvertRepository();
        return bmmRepository;
    }

    public static AomProfiles getAomProfiles() {
        String[] resourceNames;
        if (aomProfiles != null) {
            return aomProfiles;
        }
        AomProfiles profiles = new AomProfiles();
        for (String resource : resourceNames = new String[]{"/aom_profiles/openehr_aom_profile.arp", "/aom_profiles/cdisc_aom_profile.arp", "/aom_profiles/cimi_aom_profile.arp", "/aom_profiles/fhir_aom_profile.arp", "/aom_profiles/iso13606_aom_profile.arp"}) {
            try (InputStream odin = BuiltinReferenceModels.class.getResourceAsStream(resource);){
                profiles.add(odin);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        aomProfiles = profiles;
        return profiles;
    }

    public static ReferenceModels getAvailableModelInfoLookups() {
        ReferenceModels result = new ReferenceModels();
        BuiltinReferenceModels.addModelInfoLookupIfExists(result, "com.nedap.archie.rminfo.ArchieRMInfoLookup", "com.nedap.archie.json.ArchieRMObjectMapperProvider");
        BuiltinReferenceModels.addModelInfoLookupIfExists(result, "com.nedap.archie.openehrtestrm.TestRMInfoLookup", null);
        return result;
    }

    private static void addModelInfoLookupIfExists(ReferenceModels result, String className, String objectMapperProviderClassName) {
        try {
            Class<?> openEhrRMLookup = Class.forName(className);
            Method getInstance = openEhrRMLookup.getDeclaredMethod("getInstance", new Class[0]);
            ModelInfoLookup modelInfo = (ModelInfoLookup)getInstance.invoke(null, new Object[0]);
            RMObjectMapperProvider provider = null;
            if (objectMapperProviderClassName != null) {
                try {
                    Class<?> objectMapperProvider = Class.forName(objectMapperProviderClassName);
                    Constructor<?> getProviderInstance = objectMapperProvider.getConstructor(new Class[0]);
                    provider = (RMObjectMapperProvider)getProviderInstance.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            result.registerModel(modelInfo, provider);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static MetaModels getMetaModels() {
        MetaModels metaModels = new MetaModels(BuiltinReferenceModels.getAvailableModelInfoLookups(), BuiltinReferenceModels.getBmmRepository());
        for (AomProfile profile : BuiltinReferenceModels.getAomProfiles().getProfiles()) {
            metaModels.getAomProfiles().add(profile);
        }
        return metaModels;
    }
}

