/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.docgen;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmPackageContainer;
import org.openehr.docgen.model.ClassDetails;
import org.openehr.docgen.model.ClassListItem;
import org.openehr.docgen.model.PackageListItem;
import org.openehr.docgen.model.PackageTreeNode;
import org.openehr.docgen.model.PropertyDetails;
import org.openehr.utils.file.FileAndDirUtils;

public class DocumentGenerator {
    public static final String ALL_CLASSES_FRAME_TEMPLATE = "allclasses-frame.ftlh";
    public static final String ALL_PACKAGES_FRAME_TEMPLATE = "overview-frame.ftlh";
    public static final String OVERVIEW_SUMMARY_TEMPLATE = "overview-summary.ftlh";
    public static final String OVERVIEW_TEMPLATE = "overview.ftlh";
    public static final String PACKAGE_DETAILS_TEMPLATE = "package_details.ftlh";
    public static final String CLASS_DETAILS_TEMPLATE = "class.ftlh";
    protected static final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private Configuration cfg;
    private String outputDirectory;
    private String supplementalFilesDirectory;

    public void generateDocument(BmmModel schema) {
        try {
            this.prepareDirectory();
            this.populateOverviewPage(schema);
            this.populateAllClassList(schema);
            this.populateAllPackagesList(schema);
            this.populateOverviewSummaryList(schema);
        }
        catch (Exception e) {
            throw new RuntimeException("Error binding root to template", e);
        }
    }

    private void prepareDirectory() {
        try {
            FileUtils.deleteDirectory((File)new File(this.outputDirectory));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String currentBaseDir = DocumentGenerator.class.getResource("/templates").getFile();
        File dir = new File(currentBaseDir);
        if (dir.exists()) {
            System.out.println(dir + " exists");
        }
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/index.html", (String)(this.outputDirectory + "index.html"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/stylesheet.css", (String)(this.outputDirectory + "stylesheet.css"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/background.gif", (String)(this.outputDirectory + "resources/background.gif"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/lastnode.png", (String)(this.outputDirectory + "resources/lastnode.png"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/node.png", (String)(this.outputDirectory + "resources/node.png"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/overview.jpg", (String)(this.outputDirectory + "resources/overview.jpg"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/tab.gif", (String)(this.outputDirectory + "resources/tab.gif"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/titlebar.gif", (String)(this.outputDirectory + "resources/titlebar.gif"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/titlebar_end.gif", (String)(this.outputDirectory + "resources/titlebar_end.gif"));
        FileAndDirUtils.copyStreamToTargetFile((String)"/templates/resources/vline.png", (String)(this.outputDirectory + "resources/vline.png"));
        FileAndDirUtils.copyDirectoryAndContent((String)(currentBaseDir + File.separator + "supplementalFiles"), (String)this.outputDirectory);
    }

    public void populateOverviewPage(BmmModel schema) throws Exception {
        Template overviewTemplate = this.retrieveTemplate(OVERVIEW_TEMPLATE);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("stylesheet", this.getStylesheetPath(0));
        root.put("overview", this.getOverviewPath(0));
        this.populateTemplate(overviewTemplate, root, "overview.html");
    }

    public void populateAllClassList(BmmModel schema) throws Exception {
        Template allclasses = this.retrieveAllClassesTemplate();
        Map<String, Object> root = this.populateRootMapWithClassDefinitions(schema);
        this.populateTemplate(allclasses, root, "allclasses-frame.html");
    }

    public void populateOverviewSummaryList(BmmModel schema) throws Exception {
        Template allclasses = this.retrieveOverviewSummaryTemplate();
        Map<String, Object> root = this.populateRootMapWithClassDefinitions(schema);
        root.put("currentDate", this.getMMDDYYYYhmsFormattedDate());
        this.populateTemplate(allclasses, root, "overview-summary.html");
    }

    public Map<String, Object> populateRootMapWithClassDefinitions(BmmModel schema) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("stylesheet", this.getStylesheetPath(0));
        ArrayList classes = new ArrayList();
        schema.getClassDefinitions().forEach((bmmClassName, bmmClass) -> {
            String classDetailUri = bmmClass.getPackage().getPath().replaceAll("\\.", "/") + "/" + bmmClass.getName() + ".html";
            ClassDetails details = new ClassDetails(classDetailUri, bmmClass.getPackagePath(), bmmClass.getName());
            details.setDocumentation(DocumentGenerator.revertSafeString(bmmClass.getDocumentation()));
            details.setFlagClass(false);
            bmmClass.getProperties().forEach((propName, property) -> {
                if (property.getDocumentation() == null) {
                    details.setFlagClass(true);
                }
            });
            if (bmmClass.getDocumentation() == null) {
                details.setFlagClass(true);
            }
            classes.add(details);
        });
        root.put("classes", classes);
        return root;
    }

    public void populatePackageClassList(BmmModel schema, BmmPackage bmmPackage, PackageListItem packageListItem, String filePath) throws Exception {
        Template packageDetailsTemplate = this.retrievePackageDetailsTemplate();
        HashMap<String, Object> root = new HashMap<String, Object>();
        ArrayList classes = new ArrayList();
        List bmmClasses = bmmPackage.getClasses();
        bmmClasses.forEach(bmmClass -> {
            ClassListItem item = new ClassListItem(((BmmClass)bmmClass).getName() + ".html", packageListItem.getPath(), ((BmmClass)bmmClass).getName());
            classes.add(item);
            String classDetailFilePath = filePath.substring(0, filePath.lastIndexOf("/") + 1) + ((BmmClass)bmmClass).getName() + ".html";
            this.populateClassDetails(schema, (BmmClass)bmmClass, item, classDetailFilePath);
        });
        root.put("classes", classes);
        root.put("package", packageListItem);
        root.put("stylesheet", this.getStylesheetPath(packageListItem.getPath().split("\\.").length));
        this.populateTemplate(packageDetailsTemplate, root, filePath);
    }

    public void populateAllPackagesList(BmmModel schema) throws Exception {
        Template allPackages = this.retrieveAllPackagesTemplate();
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        root.put("stylesheet", this.getStylesheetPath(0));
        Map<String, BmmPackage> packages = this.collectPackages(schema);
        ArrayList packageList = new ArrayList();
        packages.forEach((K, V) -> {
            PackageListItem item = this.buildPackageListItemFromPackage((String)K, (BmmPackage)V);
            packageList.add(item);
            this.generateFolderStructureFromPath(schema, (String)K, (BmmPackage)V, item);
        });
        PackageTreeNode node = this.buildPackageTree(schema);
        root.put("packages", packageList);
        root.put("packagetree", node);
        this.populateTemplate(allPackages, root, "overview-frame.html");
    }

    private PackageListItem buildPackageListItemFromPackage(String path, BmmPackage bmmPackage) {
        PackageListItem item = new PackageListItem(bmmPackage.getName(), this.buildPackageContentPagePath(path, bmmPackage), path);
        item.setPackageInfoPath(this.buildPackageInfoPagePath(path, bmmPackage));
        return item;
    }

    public void populateClassDetails(BmmModel schema, BmmClass bmmClass, ClassListItem item, String classPath) {
        try {
            Template classDetails = this.retrieveClassDetailsTemplate();
            HashMap<String, Object> root = new HashMap<String, Object>();
            ClassDetails details = new ClassDetails(item);
            details.setDocumentation(DocumentGenerator.revertSafeString(bmmClass.getDocumentation()));
            ArrayList<ClassDetails> ancestors = new ArrayList<ClassDetails>();
            Map ancestorMap = schema.getAllAncestorClassObjects(bmmClass);
            ancestors.add(details);
            ancestorMap.forEach((K, V) -> {
                String classDetailUri = V.getPackage().getPath().replaceAll("\\.", "/") + "/" + V.getName() + ".html";
                ClassDetails ancestor = new ClassDetails(this.getRelativePath(classPath.split("/").length - 1, classDetailUri), V.getPackagePath(), V.getName());
                V.getProperties().forEach((name, value) -> {
                    PropertyDetails propDetails = new PropertyDetails(value.getName());
                    ancestor.addProperty(propDetails);
                });
                ancestors.add(ancestor);
            });
            ArrayList properties = new ArrayList();
            bmmClass.getProperties().forEach((K, V) -> {
                PropertyDetails property = new PropertyDetails(V.getName());
                property.setType(V.getType().toDisplayString());
                property.setDocumentation(DocumentGenerator.revertSafeString(V.getDocumentation()));
                property.setExistence(V.getExistence().toString());
                if (V instanceof BmmContainerProperty) {
                    if (((BmmContainerProperty)V).getCardinality().getLower() != null) {
                        property.setCardinality(((BmmContainerProperty)V).getCardinality().toString());
                    } else {
                        System.out.println("######## INVESTIGATE " + bmmClass.getName() + "." + property.getName());
                        property.setCardinality("0..*");
                    }
                } else {
                    property.setCardinality("N/A");
                }
                properties.add(property);
            });
            ArrayList descendants = new ArrayList();
            Map descendantMap = schema.getAllDescendantClassObjects(bmmClass);
            descendantMap.forEach((K, V) -> {
                String classDetailUri = V.getPackage().getPath().replaceAll("\\.", "/") + "/" + V.getName() + ".html";
                ClassDetails descendant = new ClassDetails(this.getRelativePath(classPath.split("/").length - 1, classDetailUri), V.getPackagePath(), V.getName());
                descendants.add(descendant);
            });
            root.put("stylesheet", this.getStylesheetPath(classPath.split("/").length - 1));
            root.put("overview", this.getOverviewPath(classPath.split("/").length - 1));
            root.put("class", details);
            root.put("ancestors", ancestors);
            root.put("properties", properties);
            root.put("descendants", descendants);
            this.populateTemplate(classDetails, root, classPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating class detail page from template for class " + bmmClass.getName());
        }
    }

    public void populateTemplate(Template template, Map<String, Object> root, String outputFilePath) throws Exception {
        FileWriter out = new FileWriter(this.outputDirectory + File.separator + outputFilePath);
        template.process(root, (Writer)out);
        ((Writer)out).close();
    }

    public Map<String, BmmPackage> collectPackages(BmmModel model) {
        LinkedHashMap<String, BmmPackage> packages = new LinkedHashMap<String, BmmPackage>();
        this.collectPackages((BmmPackageContainer)model, packages, "", 0);
        return packages;
    }

    protected void collectPackages(BmmPackageContainer packageContainer, Map<String, BmmPackage> packages, String path, int level) {
        Map bmmPackageMap = packageContainer.getPackages();
        if (bmmPackageMap != null && bmmPackageMap.size() > 0) {
            Collection bmmPackages = bmmPackageMap.values();
            bmmPackages.forEach(bmmPackage -> {
                String newpath = "";
                newpath = level == 0 ? ((BmmPackage)bmmPackage).getName() : path + "." + ((BmmPackage)bmmPackage).getName();
                packages.put(newpath, (BmmPackage)bmmPackage);
                if (((BmmPackage)bmmPackage).getPackages() != null && ((BmmPackage)bmmPackage).getPackages().size() > 0) {
                    this.collectPackages((BmmPackageContainer)((BmmPackage)bmmPackage), packages, newpath, level + 1);
                }
            });
        }
    }

    public PackageTreeNode buildPackageTree(BmmModel model) {
        PackageTreeNode tree = new PackageTreeNode();
        PackageListItem root = new PackageListItem();
        root.setName("model");
        root.setPath("");
        tree.setPackageItem(root);
        this.buildTree((BmmPackageContainer)model, tree, "", 0);
        return tree;
    }

    protected void buildTree(BmmPackageContainer packageContainer, PackageTreeNode tree, String path, int level) {
        Map bmmPackageMap = packageContainer.getPackages();
        if (bmmPackageMap != null && bmmPackageMap.size() > 0) {
            Collection bmmPackages = bmmPackageMap.values();
            bmmPackages.forEach(bmmPackage -> {
                String newpath = "";
                newpath = level == 0 ? ((BmmPackage)bmmPackage).getName() : path + "." + ((BmmPackage)bmmPackage).getName();
                PackageTreeNode node = new PackageTreeNode();
                PackageListItem item = this.buildPackageListItemFromPackage(newpath, (BmmPackage)bmmPackage);
                node.setPackageItem(item);
                tree.addChildNode(node);
                if (((BmmPackage)bmmPackage).getPackages() != null && ((BmmPackage)bmmPackage).getPackages().size() > 0) {
                    this.buildTree((BmmPackageContainer)((BmmPackage)bmmPackage), node, newpath, level + 1);
                }
            });
        }
    }

    protected String buildPackageContentPagePath(String path, BmmPackage bmmPackage) {
        String outputPath = path.replaceAll("\\.", File.separator) + File.separator + bmmPackage.getName() + "_pkg.html";
        return outputPath;
    }

    protected String buildPackageInfoPagePath(String path, BmmPackage bmmPackage) {
        String outputPath = path.replaceAll("\\.", File.separator) + File.separator + bmmPackage.getName() + "_info.html";
        return outputPath;
    }

    protected void generateFolderStructureFromPath(BmmModel schema, String path, BmmPackage bmmPackage, PackageListItem item) {
        try {
            String absolutePath = this.outputDirectory + this.buildPackageContentPagePath(path, bmmPackage);
            String relativePath = this.buildPackageContentPagePath(path, bmmPackage);
            System.out.println(absolutePath);
            System.out.println(relativePath);
            Files.createDirectories(Paths.get(absolutePath.substring(0, absolutePath.lastIndexOf(File.separator)), new String[0]), new FileAttribute[0]);
            this.populatePackageClassList(schema, bmmPackage, item, relativePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing package class details file", e);
        }
    }

    protected Template retrieveAllClassesTemplate() {
        return this.retrieveTemplate(ALL_CLASSES_FRAME_TEMPLATE);
    }

    protected Template retrieveOverviewSummaryTemplate() {
        return this.retrieveTemplate(OVERVIEW_SUMMARY_TEMPLATE);
    }

    protected Template retrieveAllPackagesTemplate() {
        return this.retrieveTemplate(ALL_PACKAGES_FRAME_TEMPLATE);
    }

    protected Template retrievePackageDetailsTemplate() {
        return this.retrieveTemplate(PACKAGE_DETAILS_TEMPLATE);
    }

    protected Template retrieveClassDetailsTemplate() {
        return this.retrieveTemplate(CLASS_DETAILS_TEMPLATE);
    }

    public Template retrieveTemplate(String templateName) {
        Template template = null;
        try {
            template = this.cfg.getTemplate(templateName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("error retrieving template " + templateName);
        }
        return template;
    }

    public void configure(File templateDirectory) {
        try {
            this.cfg = new Configuration(Configuration.VERSION_2_3_25);
            this.cfg.setClassForTemplateLoading(this.getClass(), "/templates");
            this.cfg.setDefaultEncoding("UTF-8");
            this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.cfg.setLogTemplateExceptions(false);
        }
        catch (Exception e) {
            throw new RuntimeException("Error configuring Freemaker", e);
        }
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public void setCfg(Configuration cfg) {
        this.cfg = cfg;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        if (!this.outputDirectory.endsWith(File.separator)) {
            this.outputDirectory = this.outputDirectory + File.separator;
        }
    }

    public String getSupplementalFilesDirectory() {
        return this.supplementalFilesDirectory;
    }

    public void setSupplementalFilesDirectory(String supplementalFilesDirectory) {
        this.supplementalFilesDirectory = supplementalFilesDirectory;
    }

    public String getStylesheetPath(int relativeSteps) {
        return this.getRelativePath(relativeSteps, "stylesheet.css");
    }

    public String getOverviewPath(int relativeSteps) {
        return this.getRelativePath(relativeSteps, "overview-summary.html");
    }

    protected String getRelativePath(int relativeSteps, String path) {
        String prefix = "";
        for (int i = 0; i < relativeSteps; ++i) {
            prefix = prefix + ".." + File.separator;
        }
        return prefix + path;
    }

    public String getMMDDYYYYhmsFormattedDate() {
        return this.getCurrentTime(defaultDateFormat);
    }

    protected String getCurrentTime(SimpleDateFormat format) {
        Date date = new Date();
        return format.format(date);
    }

    public static String revertSafeString(String documentation) {
        String safeString = documentation;
        safeString = safeString.replaceAll("&quot;", "\"");
        safeString = safeString.replaceAll("&lt;", "<");
        safeString = safeString.replaceAll("&gt;", ">");
        safeString = safeString.replaceAll("&#47;", "/");
        return safeString;
    }
}

