/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.rminfo.RMAttributeInfo;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

public class RMTypeInfo {
    private final String rmName;
    private final Class javaClass;
    private final Set<RMTypeInfo> parentClasses = new LinkedHashSet<RMTypeInfo>();
    private final Set<RMTypeInfo> descendantClasses = new LinkedHashSet<RMTypeInfo>();
    private Map<String, RMAttributeInfo> attributes = new HashMap<String, RMAttributeInfo>();

    public RMTypeInfo(Class clazz, String rmName) {
        this.javaClass = clazz;
        this.rmName = rmName;
    }

    public String getRmName() {
        return this.rmName;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public Map<String, RMAttributeInfo> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(RMAttributeInfo attribute) {
        this.attributes.put(attribute.getRmName(), attribute);
    }

    public RMAttributeInfo getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void addDirectParentClass(RMTypeInfo parent) {
        this.parentClasses.add(parent);
    }

    public Set<RMTypeInfo> getDirectParentClasses() {
        return this.parentClasses;
    }

    public void addDirectDescendantClass(RMTypeInfo parent) {
        this.descendantClasses.add(parent);
    }

    public Set<RMTypeInfo> getDirectDescendantClasses() {
        return this.descendantClasses;
    }

    public Set<RMTypeInfo> getAllDescendantClasses() {
        Stack<RMTypeInfo> workList = new Stack<RMTypeInfo>();
        LinkedHashSet<RMTypeInfo> result = new LinkedHashSet<RMTypeInfo>();
        workList.addAll(this.descendantClasses);
        while (!workList.isEmpty()) {
            RMTypeInfo descendant = (RMTypeInfo)workList.pop();
            workList.addAll(descendant.getDirectDescendantClasses());
            result.add(descendant);
        }
        return result;
    }

    public Set<RMTypeInfo> getAllParentClasses() {
        Stack<RMTypeInfo> workList = new Stack<RMTypeInfo>();
        LinkedHashSet<RMTypeInfo> result = new LinkedHashSet<RMTypeInfo>();
        workList.addAll(this.parentClasses);
        while (!workList.isEmpty()) {
            RMTypeInfo parent = (RMTypeInfo)workList.pop();
            workList.addAll(parent.getDirectParentClasses());
            result.add(parent);
        }
        return result;
    }

    public boolean isParentOf(RMTypeInfo other) {
        return this.getAllDescendantClasses().contains(other);
    }

    public boolean isDescendantOf(RMTypeInfo other) {
        return this.getAllParentClasses().contains(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RMTypeInfo that = (RMTypeInfo)o;
        return Objects.equals(this.rmName, that.rmName) && Objects.equals(this.javaClass, that.javaClass);
    }

    public int hashCode() {
        return Objects.hash(this.rmName, this.javaClass);
    }

    public String toString() {
        return this.rmName;
    }

    public boolean isDescendantOrEqual(RMTypeInfo other) {
        return other.equals(this) || this.getAllParentClasses().contains(other);
    }
}

