/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.base;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;

class IntervalDurationConverter {
    IntervalDurationConverter() {
    }

    public static Duration from(TemporalAmount amount) {
        Objects.requireNonNull(amount, "amount");
        Duration duration = Duration.ofSeconds(0L);
        for (TemporalUnit unit : amount.getUnits()) {
            duration = IntervalDurationConverter.plus(duration, amount.get(unit), unit);
        }
        return duration;
    }

    private static Duration plus(Duration value, long amountToAdd, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (unit != ChronoUnit.DAYS && unit.isDurationEstimated()) {
            Duration duration = unit.getDuration().multipliedBy(amountToAdd);
            return value.plusSeconds(duration.getSeconds()).plusNanos(duration.getNano());
        }
        return value.plus(amountToAdd, unit);
    }
}

