/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.antlr.errors;

import com.nedap.archie.antlr.errors.ANTLRParserMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ANTLRParserErrors {
    private static final Logger logger = LoggerFactory.getLogger(ANTLRParserErrors.class);
    private List<ANTLRParserMessage> errors = new ArrayList<ANTLRParserMessage>();
    private List<ANTLRParserMessage> warnings = new ArrayList<ANTLRParserMessage>();

    public void addError(String error) {
        this.errors.add(new ANTLRParserMessage(error));
    }

    public void addError(String error, int line, int charPositionInLine) {
        this.errors.add(new ANTLRParserMessage(error, line, charPositionInLine));
    }

    public void addWarning(String error) {
        this.warnings.add(new ANTLRParserMessage(error));
    }

    public void addWarning(String error, int line, int charPositionInLine) {
        this.warnings.add(new ANTLRParserMessage(error, line, charPositionInLine));
    }

    public void logToLogger() {
        for (ANTLRParserMessage message : this.warnings) {
            logger.warn(message.getMessage());
        }
        for (ANTLRParserMessage message : this.errors) {
            logger.error(message.getMessage());
        }
    }

    public List<ANTLRParserMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ANTLRParserMessage> errors) {
        this.errors = errors;
    }

    public List<ANTLRParserMessage> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ANTLRParserMessage> warnings) {
        this.warnings = warnings;
    }

    public boolean hasNoMessages() {
        return this.getErrors().isEmpty() && this.getWarnings().isEmpty();
    }

    public boolean hasNoErrors() {
        return this.getErrors().isEmpty();
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.append(result, "Warning", this.warnings);
        this.append(result, "Error", this.errors);
        return result.toString();
    }

    private void append(StringBuilder result, String level, List<ANTLRParserMessage> messages) {
        for (ANTLRParserMessage message : messages) {
            result.append(level);
            result.append(": ");
            result.append(message.getMessage());
            result.append("\n");
        }
    }
}

