/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.wheelpicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.itheima.wheelpicker.IDebug;
import com.itheima.wheelpicker.IWheelPicker;
import com.itheima.wheelpicker.R;
import java.util.Arrays;
import java.util.List;

public class WheelPicker
extends View
implements IDebug,
IWheelPicker,
Runnable {
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final String TAG = WheelPicker.class.getSimpleName();
    private final Handler mHandler = new Handler();
    private Paint mPaint;
    private Scroller mScroller;
    private VelocityTracker mTracker;
    private OnItemSelectedListener mOnItemSelectedListener;
    private OnWheelChangeListener mOnWheelChangeListener;
    private Rect mRectDrawn;
    private Rect mRectIndicatorHead;
    private Rect mRectIndicatorFoot;
    private Rect mRectCurrentItem;
    private Camera mCamera;
    private Matrix mMatrixRotate;
    private Matrix mMatrixDepth;
    private List mData;
    private String mMaxWidthText;
    private int mVisibleItemCount;
    private int mDrawnItemCount;
    private int mHalfDrawnItemCount;
    private int mTextMaxWidth;
    private int mTextMaxHeight;
    private int mItemTextColor;
    private int mSelectedItemTextColor;
    private int mItemTextSize;
    private int mIndicatorSize;
    private int mIndicatorColor;
    private int mCurtainColor;
    private int mItemSpace;
    private int mItemAlign;
    private int mItemHeight;
    private int mHalfItemHeight;
    private int mHalfWheelHeight;
    private int mSelectedItemPosition;
    private int mCurrentItemPosition;
    private int mMinFlingY;
    private int mMaxFlingY;
    private int mMinimumVelocity = 50;
    private int mMaximumVelocity = 8000;
    private int mWheelCenterX;
    private int mWheelCenterY;
    private int mDrawnCenterX;
    private int mDrawnCenterY;
    private int mScrollOffsetY;
    private int mTextMaxWidthPosition;
    private int mLastPointY;
    private int mDownPointY;
    private int mTouchSlop = 8;
    private boolean hasSameWidth;
    private boolean hasIndicator;
    private boolean hasCurtain;
    private boolean hasAtmospheric;
    private boolean isCyclic;
    private boolean isCurved;
    private boolean isClick;
    private boolean isForceFinishScroll;
    private boolean isDebug;

    public WheelPicker(Context context) {
        this(context, null);
    }

    public WheelPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelPicker);
        int idData = a.getResourceId(R.styleable.WheelPicker_wheel_data, 0);
        this.mData = Arrays.asList(this.getResources().getStringArray(idData == 0 ? R.array.WheelArrayDefault : idData));
        this.mItemTextSize = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_item_text_size, this.getResources().getDimensionPixelSize(R.dimen.WheelItemTextSize));
        this.mVisibleItemCount = a.getInt(R.styleable.WheelPicker_wheel_visible_item_count, 7);
        this.mSelectedItemPosition = a.getInt(R.styleable.WheelPicker_wheel_selected_item_position, 0);
        this.hasSameWidth = a.getBoolean(R.styleable.WheelPicker_wheel_same_width, false);
        this.mTextMaxWidthPosition = a.getInt(R.styleable.WheelPicker_wheel_maximum_width_text_position, -1);
        this.mMaxWidthText = a.getString(R.styleable.WheelPicker_wheel_maximum_width_text);
        this.mSelectedItemTextColor = a.getColor(R.styleable.WheelPicker_wheel_selected_item_text_color, -1);
        this.mItemTextColor = a.getColor(R.styleable.WheelPicker_wheel_item_text_color, -7829368);
        this.mItemSpace = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_item_space, this.getResources().getDimensionPixelSize(R.dimen.WheelItemSpace));
        this.isCyclic = a.getBoolean(R.styleable.WheelPicker_wheel_cyclic, false);
        this.hasIndicator = a.getBoolean(R.styleable.WheelPicker_wheel_indicator, false);
        this.mIndicatorColor = a.getColor(R.styleable.WheelPicker_wheel_indicator_color, -1166541);
        this.mIndicatorSize = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_indicator_size, this.getResources().getDimensionPixelSize(R.dimen.WheelIndicatorSize));
        this.hasCurtain = a.getBoolean(R.styleable.WheelPicker_wheel_curtain, false);
        this.mCurtainColor = a.getColor(R.styleable.WheelPicker_wheel_curtain_color, -1996488705);
        this.hasAtmospheric = a.getBoolean(R.styleable.WheelPicker_wheel_atmospheric, false);
        this.isCurved = a.getBoolean(R.styleable.WheelPicker_wheel_curved, false);
        this.mItemAlign = a.getInt(R.styleable.WheelPicker_wheel_item_align, 0);
        a.recycle();
        this.updateVisibleItemCount();
        this.mPaint = new Paint(69);
        this.mPaint.setTextSize((float)this.mItemTextSize);
        this.updateItemTextAlign();
        this.computeTextSize();
        this.mScroller = new Scroller(this.getContext());
        if (Build.VERSION.SDK_INT >= 4) {
            ViewConfiguration conf = ViewConfiguration.get((Context)this.getContext());
            this.mMinimumVelocity = conf.getScaledMinimumFlingVelocity();
            this.mMaximumVelocity = conf.getScaledMaximumFlingVelocity();
            this.mTouchSlop = conf.getScaledTouchSlop();
        }
        this.mRectDrawn = new Rect();
        this.mRectIndicatorHead = new Rect();
        this.mRectIndicatorFoot = new Rect();
        this.mRectCurrentItem = new Rect();
        this.mCamera = new Camera();
        this.mMatrixRotate = new Matrix();
        this.mMatrixDepth = new Matrix();
    }

    private void updateVisibleItemCount() {
        if (this.mVisibleItemCount < 2) {
            throw new ArithmeticException("Wheel's visible item count can not be less than 2!");
        }
        if (this.mVisibleItemCount % 2 == 0) {
            ++this.mVisibleItemCount;
        }
        this.mDrawnItemCount = this.mVisibleItemCount + 2;
        this.mHalfDrawnItemCount = this.mDrawnItemCount / 2;
    }

    private void computeTextSize() {
        this.mTextMaxHeight = 0;
        this.mTextMaxWidth = 0;
        if (this.hasSameWidth) {
            this.mTextMaxWidth = (int)this.mPaint.measureText(String.valueOf(this.mData.get(0)));
        } else if (this.isPosInRang(this.mTextMaxWidthPosition)) {
            this.mTextMaxWidth = (int)this.mPaint.measureText(String.valueOf(this.mData.get(this.mTextMaxWidthPosition)));
        } else if (!TextUtils.isEmpty((CharSequence)this.mMaxWidthText)) {
            this.mTextMaxWidth = (int)this.mPaint.measureText(this.mMaxWidthText);
        } else {
            for (Object obj : this.mData) {
                String text = String.valueOf(obj);
                int width = (int)this.mPaint.measureText(text);
                this.mTextMaxWidth = Math.max(this.mTextMaxWidth, width);
            }
        }
        Paint.FontMetrics metrics = this.mPaint.getFontMetrics();
        this.mTextMaxHeight = (int)(metrics.bottom - metrics.top);
    }

    private void updateItemTextAlign() {
        switch (this.mItemAlign) {
            case 1: {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.mPaint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultWidth = this.mTextMaxWidth;
        int resultHeight = this.mTextMaxHeight * this.mVisibleItemCount + this.mItemSpace * (this.mVisibleItemCount - 1);
        if (this.isCurved) {
            resultHeight = (int)((double)(2 * resultHeight) / Math.PI);
        }
        if (this.isDebug) {
            Log.i((String)TAG, (String)("Wheel's content size is (" + resultWidth + ":" + resultHeight + ")"));
        }
        resultWidth += this.getPaddingLeft() + this.getPaddingRight();
        resultHeight += this.getPaddingTop() + this.getPaddingBottom();
        if (this.isDebug) {
            Log.i((String)TAG, (String)("Wheel's size is (" + resultWidth + ":" + resultHeight + ")"));
        }
        resultWidth = this.measureSize(modeWidth, sizeWidth, resultWidth);
        resultHeight = this.measureSize(modeHeight, sizeHeight, resultHeight);
        this.setMeasuredDimension(resultWidth, resultHeight);
    }

    private int measureSize(int mode, int sizeExpect, int sizeActual) {
        int realSize;
        if (mode == 0x40000000) {
            realSize = sizeExpect;
        } else {
            realSize = sizeActual;
            if (mode == Integer.MIN_VALUE) {
                realSize = Math.min(realSize, sizeExpect);
            }
        }
        return realSize;
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.mRectDrawn.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        if (this.isDebug) {
            Log.i((String)TAG, (String)("Wheel's drawn rect size is (" + this.mRectDrawn.width() + ":" + this.mRectDrawn.height() + ") and location is (" + this.mRectDrawn.left + ":" + this.mRectDrawn.top + ")"));
        }
        this.mWheelCenterX = this.mRectDrawn.centerX();
        this.mWheelCenterY = this.mRectDrawn.centerY();
        this.computeDrawnCenter();
        this.mHalfWheelHeight = this.mRectDrawn.height() / 2;
        this.mItemHeight = this.mRectDrawn.height() / this.mVisibleItemCount;
        this.mHalfItemHeight = this.mItemHeight / 2;
        this.computeFlingLimitY();
        this.computeIndicatorRect();
        this.computeCurrentItemRect();
    }

    private void computeDrawnCenter() {
        switch (this.mItemAlign) {
            case 1: {
                this.mDrawnCenterX = this.mRectDrawn.left;
                break;
            }
            case 2: {
                this.mDrawnCenterX = this.mRectDrawn.right;
                break;
            }
            default: {
                this.mDrawnCenterX = this.mWheelCenterX;
            }
        }
        this.mDrawnCenterY = (int)((float)this.mWheelCenterY - (this.mPaint.ascent() + this.mPaint.descent()) / 2.0f);
    }

    private void computeFlingLimitY() {
        int currentItemOffset = this.mSelectedItemPosition * this.mItemHeight;
        this.mMinFlingY = this.isCyclic ? Integer.MIN_VALUE : -this.mItemHeight * (this.mData.size() - 1) + currentItemOffset;
        this.mMaxFlingY = this.isCyclic ? Integer.MAX_VALUE : currentItemOffset;
    }

    private void computeIndicatorRect() {
        if (!this.hasIndicator) {
            return;
        }
        int halfIndicatorSize = this.mIndicatorSize / 2;
        int indicatorHeadCenterY = this.mWheelCenterY + this.mHalfItemHeight;
        int indicatorFootCenterY = this.mWheelCenterY - this.mHalfItemHeight;
        this.mRectIndicatorHead.set(this.mRectDrawn.left, indicatorHeadCenterY - halfIndicatorSize, this.mRectDrawn.right, indicatorHeadCenterY + halfIndicatorSize);
        this.mRectIndicatorFoot.set(this.mRectDrawn.left, indicatorFootCenterY - halfIndicatorSize, this.mRectDrawn.right, indicatorFootCenterY + halfIndicatorSize);
    }

    private void computeCurrentItemRect() {
        if (!this.hasCurtain && this.mSelectedItemTextColor == -1) {
            return;
        }
        this.mRectCurrentItem.set(this.mRectDrawn.left, this.mWheelCenterY - this.mHalfItemHeight, this.mRectDrawn.right, this.mWheelCenterY + this.mHalfItemHeight);
    }

    protected void onDraw(Canvas canvas) {
        if (null != this.mOnWheelChangeListener) {
            this.mOnWheelChangeListener.onWheelScrolled(this.mScrollOffsetY);
        }
        int drawnDataStartPos = -this.mScrollOffsetY / this.mItemHeight - this.mHalfDrawnItemCount;
        int drawnDataPos = drawnDataStartPos + this.mSelectedItemPosition;
        int drawnOffsetPos = -this.mHalfDrawnItemCount;
        while (drawnDataPos < drawnDataStartPos + this.mSelectedItemPosition + this.mDrawnItemCount) {
            int drawnCenterY;
            String data = "";
            if (this.isCyclic) {
                int actualPos = drawnDataPos % this.mData.size();
                actualPos = actualPos < 0 ? actualPos + this.mData.size() : actualPos;
                data = String.valueOf(this.mData.get(actualPos));
            } else if (this.isPosInRang(drawnDataPos)) {
                data = String.valueOf(this.mData.get(drawnDataPos));
            }
            this.mPaint.setColor(this.mItemTextColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            int mDrawnItemCenterY = this.mDrawnCenterY + drawnOffsetPos * this.mItemHeight + this.mScrollOffsetY % this.mItemHeight;
            int distanceToCenter = 0;
            if (this.isCurved) {
                float ratio = (float)(this.mDrawnCenterY - Math.abs(this.mDrawnCenterY - mDrawnItemCenterY) - this.mRectDrawn.top) * 1.0f / (float)(this.mDrawnCenterY - this.mRectDrawn.top);
                int unit = 0;
                if (mDrawnItemCenterY > this.mDrawnCenterY) {
                    unit = 1;
                } else if (mDrawnItemCenterY < this.mDrawnCenterY) {
                    unit = -1;
                }
                float degree = -(1.0f - ratio) * 90.0f * (float)unit;
                if (degree < -90.0f) {
                    degree = -90.0f;
                }
                if (degree > 90.0f) {
                    degree = 90.0f;
                }
                distanceToCenter = this.computeSpace((int)degree);
                int transX = this.mWheelCenterX;
                switch (this.mItemAlign) {
                    case 1: {
                        transX = this.mRectDrawn.left;
                        break;
                    }
                    case 2: {
                        transX = this.mRectDrawn.right;
                    }
                }
                int transY = this.mWheelCenterY - distanceToCenter;
                this.mCamera.save();
                this.mCamera.rotateX(degree);
                this.mCamera.getMatrix(this.mMatrixRotate);
                this.mCamera.restore();
                this.mMatrixRotate.preTranslate((float)(-transX), (float)(-transY));
                this.mMatrixRotate.postTranslate((float)transX, (float)transY);
                this.mCamera.save();
                this.mCamera.translate(0.0f, 0.0f, (float)this.computeDepth((int)degree));
                this.mCamera.getMatrix(this.mMatrixDepth);
                this.mCamera.restore();
                this.mMatrixDepth.preTranslate((float)(-transX), (float)(-transY));
                this.mMatrixDepth.postTranslate((float)transX, (float)transY);
                this.mMatrixRotate.postConcat(this.mMatrixDepth);
            }
            if (this.hasAtmospheric) {
                int alpha = (int)((float)(this.mDrawnCenterY - Math.abs(this.mDrawnCenterY - mDrawnItemCenterY)) * 1.0f / (float)this.mDrawnCenterY * 255.0f);
                alpha = alpha < 0 ? 0 : alpha;
                this.mPaint.setAlpha(alpha);
            }
            int n = drawnCenterY = this.isCurved ? this.mDrawnCenterY - distanceToCenter : mDrawnItemCenterY;
            if (this.mSelectedItemTextColor != -1) {
                canvas.save();
                if (this.isCurved) {
                    canvas.concat(this.mMatrixRotate);
                }
                canvas.clipRect(this.mRectCurrentItem, Region.Op.DIFFERENCE);
                canvas.drawText(data, (float)this.mDrawnCenterX, (float)drawnCenterY, this.mPaint);
                canvas.restore();
                this.mPaint.setColor(this.mSelectedItemTextColor);
                canvas.save();
                if (this.isCurved) {
                    canvas.concat(this.mMatrixRotate);
                }
                canvas.clipRect(this.mRectCurrentItem);
                canvas.drawText(data, (float)this.mDrawnCenterX, (float)drawnCenterY, this.mPaint);
                canvas.restore();
            } else {
                canvas.save();
                canvas.clipRect(this.mRectDrawn);
                if (this.isCurved) {
                    canvas.concat(this.mMatrixRotate);
                }
                canvas.drawText(data, (float)this.mDrawnCenterX, (float)drawnCenterY, this.mPaint);
                canvas.restore();
            }
            if (this.isDebug) {
                canvas.save();
                canvas.clipRect(this.mRectDrawn);
                this.mPaint.setColor(-1166541);
                int lineCenterY = this.mWheelCenterY + drawnOffsetPos * this.mItemHeight;
                canvas.drawLine((float)this.mRectDrawn.left, (float)lineCenterY, (float)this.mRectDrawn.right, (float)lineCenterY, this.mPaint);
                this.mPaint.setColor(-13421586);
                this.mPaint.setStyle(Paint.Style.STROKE);
                int top = lineCenterY - this.mHalfItemHeight;
                canvas.drawRect((float)this.mRectDrawn.left, (float)top, (float)this.mRectDrawn.right, (float)(top + this.mItemHeight), this.mPaint);
                canvas.restore();
            }
            ++drawnDataPos;
            ++drawnOffsetPos;
        }
        if (this.hasCurtain) {
            this.mPaint.setColor(this.mCurtainColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.mRectCurrentItem, this.mPaint);
        }
        if (this.hasIndicator) {
            this.mPaint.setColor(this.mIndicatorColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.mRectIndicatorHead, this.mPaint);
            canvas.drawRect(this.mRectIndicatorFoot, this.mPaint);
        }
        if (this.isDebug) {
            this.mPaint.setColor(0x4433EE33);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(0.0f, 0.0f, (float)this.getPaddingLeft(), (float)this.getHeight(), this.mPaint);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getPaddingTop(), this.mPaint);
            canvas.drawRect((float)(this.getWidth() - this.getPaddingRight()), 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
            canvas.drawRect(0.0f, (float)(this.getHeight() - this.getPaddingBottom()), (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
        }
    }

    private boolean isPosInRang(int position) {
        return position >= 0 && position < this.mData.size();
    }

    private int computeSpace(int degree) {
        return (int)(Math.sin(Math.toRadians(degree)) * (double)this.mHalfWheelHeight);
    }

    private int computeDepth(int degree) {
        return (int)((double)this.mHalfWheelHeight - Math.cos(Math.toRadians(degree)) * (double)this.mHalfWheelHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (null == this.mTracker) {
                    this.mTracker = VelocityTracker.obtain();
                } else {
                    this.mTracker.clear();
                }
                this.mTracker.addMovement(event);
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.isForceFinishScroll = true;
                }
                this.mDownPointY = this.mLastPointY = (int)event.getY();
                break;
            }
            case 2: {
                float move;
                if (Math.abs((float)this.mDownPointY - event.getY()) < (float)this.mTouchSlop) {
                    this.isClick = true;
                    break;
                }
                this.isClick = false;
                this.mTracker.addMovement(event);
                if (null != this.mOnWheelChangeListener) {
                    this.mOnWheelChangeListener.onWheelScrollStateChanged(1);
                }
                if (Math.abs(move = event.getY() - (float)this.mLastPointY) < 1.0f) break;
                this.mScrollOffsetY = (int)((float)this.mScrollOffsetY + move);
                this.mLastPointY = (int)event.getY();
                this.invalidate();
                break;
            }
            case 1: {
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                if (this.isClick) break;
                this.mTracker.addMovement(event);
                if (Build.VERSION.SDK_INT >= 4) {
                    this.mTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                } else {
                    this.mTracker.computeCurrentVelocity(1000);
                }
                this.isForceFinishScroll = false;
                int velocity = (int)this.mTracker.getYVelocity();
                if (Math.abs(velocity) > this.mMinimumVelocity) {
                    this.mScroller.fling(0, this.mScrollOffsetY, 0, velocity, 0, 0, this.mMinFlingY, this.mMaxFlingY);
                    this.mScroller.setFinalY(this.mScroller.getFinalY() + this.computeDistanceToEndPoint(this.mScroller.getFinalY() % this.mItemHeight));
                } else {
                    this.mScroller.startScroll(0, this.mScrollOffsetY, 0, this.computeDistanceToEndPoint(this.mScrollOffsetY % this.mItemHeight));
                }
                if (!this.isCyclic) {
                    if (this.mScroller.getFinalY() > this.mMaxFlingY) {
                        this.mScroller.setFinalY(this.mMaxFlingY);
                    } else if (this.mScroller.getFinalY() < this.mMinFlingY) {
                        this.mScroller.setFinalY(this.mMinFlingY);
                    }
                }
                this.mHandler.post((Runnable)this);
                if (null == this.mTracker) break;
                this.mTracker.recycle();
                this.mTracker = null;
                break;
            }
            case 3: {
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                if (null == this.mTracker) break;
                this.mTracker.recycle();
                this.mTracker = null;
            }
        }
        return true;
    }

    private int computeDistanceToEndPoint(int remainder) {
        if (Math.abs(remainder) > this.mHalfItemHeight) {
            if (this.mScrollOffsetY < 0) {
                return -this.mItemHeight - remainder;
            }
            return this.mItemHeight - remainder;
        }
        return -remainder;
    }

    @Override
    public void run() {
        if (null == this.mData || this.mData.size() == 0) {
            return;
        }
        if (this.mScroller.isFinished() && !this.isForceFinishScroll) {
            if (this.mItemHeight == 0) {
                return;
            }
            int position = (-this.mScrollOffsetY / this.mItemHeight + this.mSelectedItemPosition) % this.mData.size();
            int n = position = position < 0 ? position + this.mData.size() : position;
            if (this.isDebug) {
                Log.i((String)TAG, (String)(position + ":" + this.mData.get(position) + ":" + this.mScrollOffsetY));
            }
            this.mCurrentItemPosition = position;
            if (null != this.mOnItemSelectedListener) {
                this.mOnItemSelectedListener.onItemSelected(this, this.mData.get(position), position);
            }
            if (null != this.mOnWheelChangeListener) {
                this.mOnWheelChangeListener.onWheelSelected(position);
                this.mOnWheelChangeListener.onWheelScrollStateChanged(0);
            }
        }
        if (this.mScroller.computeScrollOffset()) {
            if (null != this.mOnWheelChangeListener) {
                this.mOnWheelChangeListener.onWheelScrollStateChanged(2);
            }
            this.mScrollOffsetY = this.mScroller.getCurrY();
            this.postInvalidate();
            this.mHandler.postDelayed((Runnable)this, 16L);
        }
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    @Override
    public void setVisibleItemCount(int count) {
        this.mVisibleItemCount = count;
        this.updateVisibleItemCount();
        this.requestLayout();
    }

    @Override
    public boolean isCyclic() {
        return this.isCyclic;
    }

    @Override
    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
        this.computeFlingLimitY();
        this.invalidate();
    }

    @Override
    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    @Override
    public int getSelectedItemPosition() {
        return this.mSelectedItemPosition;
    }

    @Override
    public void setSelectedItemPosition(int position) {
        position = Math.min(position, this.mData.size() - 1);
        this.mSelectedItemPosition = position = Math.max(position, 0);
        this.mCurrentItemPosition = position;
        this.mScrollOffsetY = 0;
        this.computeFlingLimitY();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public int getCurrentItemPosition() {
        return this.mCurrentItemPosition;
    }

    @Override
    public List getData() {
        return this.mData;
    }

    @Override
    public void setData(List data) {
        if (null == data) {
            throw new NullPointerException("WheelPicker's data can not be null!");
        }
        this.mData = data;
        this.mSelectedItemPosition = this.mSelectedItemPosition > data.size() - 1 || this.mCurrentItemPosition > data.size() - 1 ? (this.mCurrentItemPosition = data.size() - 1) : this.mCurrentItemPosition;
        this.mScrollOffsetY = 0;
        this.computeTextSize();
        this.computeFlingLimitY();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setSameWidth(boolean hasSameWidth) {
        this.hasSameWidth = hasSameWidth;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public boolean hasSameWidth() {
        return this.hasSameWidth;
    }

    @Override
    public void setOnWheelChangeListener(OnWheelChangeListener listener) {
        this.mOnWheelChangeListener = listener;
    }

    @Override
    public String getMaximumWidthText() {
        return this.mMaxWidthText;
    }

    @Override
    public void setMaximumWidthText(String text) {
        if (null == text) {
            throw new NullPointerException("Maximum width text can not be null!");
        }
        this.mMaxWidthText = text;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public int getMaximumWidthTextPosition() {
        return this.mTextMaxWidthPosition;
    }

    @Override
    public void setMaximumWidthTextPosition(int position) {
        if (!this.isPosInRang(position)) {
            throw new ArrayIndexOutOfBoundsException("Maximum width text Position must in [0, " + this.mData.size() + "), but current is " + position);
        }
        this.mTextMaxWidthPosition = position;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public int getSelectedItemTextColor() {
        return this.mSelectedItemTextColor;
    }

    @Override
    public void setSelectedItemTextColor(int color) {
        this.mSelectedItemTextColor = color;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    @Override
    public int getItemTextColor() {
        return this.mItemTextColor;
    }

    @Override
    public void setItemTextColor(int color) {
        this.mItemTextColor = color;
        this.invalidate();
    }

    @Override
    public int getItemTextSize() {
        return this.mItemTextSize;
    }

    @Override
    public void setItemTextSize(int size) {
        this.mItemTextSize = size;
        this.mPaint.setTextSize((float)this.mItemTextSize);
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public int getItemSpace() {
        return this.mItemSpace;
    }

    @Override
    public void setItemSpace(int space) {
        this.mItemSpace = space;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setIndicator(boolean hasIndicator) {
        this.hasIndicator = hasIndicator;
        this.computeIndicatorRect();
        this.invalidate();
    }

    @Override
    public boolean hasIndicator() {
        return this.hasIndicator;
    }

    @Override
    public int getIndicatorSize() {
        return this.mIndicatorSize;
    }

    @Override
    public void setIndicatorSize(int size) {
        this.mIndicatorSize = size;
        this.computeIndicatorRect();
        this.invalidate();
    }

    @Override
    public int getIndicatorColor() {
        return this.mIndicatorColor;
    }

    @Override
    public void setIndicatorColor(int color) {
        this.mIndicatorColor = color;
        this.invalidate();
    }

    @Override
    public void setCurtain(boolean hasCurtain) {
        this.hasCurtain = hasCurtain;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    @Override
    public boolean hasCurtain() {
        return this.hasCurtain;
    }

    @Override
    public int getCurtainColor() {
        return this.mCurtainColor;
    }

    @Override
    public void setCurtainColor(int color) {
        this.mCurtainColor = color;
        this.invalidate();
    }

    @Override
    public void setAtmospheric(boolean hasAtmospheric) {
        this.hasAtmospheric = hasAtmospheric;
        this.invalidate();
    }

    @Override
    public boolean hasAtmospheric() {
        return this.hasAtmospheric;
    }

    @Override
    public boolean isCurved() {
        return this.isCurved;
    }

    @Override
    public void setCurved(boolean isCurved) {
        this.isCurved = isCurved;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public int getItemAlign() {
        return this.mItemAlign;
    }

    @Override
    public void setItemAlign(int align) {
        this.mItemAlign = align;
        this.updateItemTextAlign();
        this.computeDrawnCenter();
        this.invalidate();
    }

    @Override
    public Typeface getTypeface() {
        if (null != this.mPaint) {
            return this.mPaint.getTypeface();
        }
        return null;
    }

    @Override
    public void setTypeface(Typeface tf) {
        if (null != this.mPaint) {
            this.mPaint.setTypeface(tf);
        }
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public static interface OnWheelChangeListener {
        public void onWheelScrolled(int var1);

        public void onWheelSelected(int var1);

        public void onWheelScrollStateChanged(int var1);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(WheelPicker var1, Object var2, int var3);
    }
}

