/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.wheelpicker.widgets;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.itheima.wheelpicker.WheelPicker;
import com.itheima.wheelpicker.model.City;
import com.itheima.wheelpicker.model.Province;
import com.itheima.wheelpicker.widgets.IWheelAreaPicker;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class WheelAreaPicker
extends LinearLayout
implements IWheelAreaPicker {
    private static final float ITEM_TEXT_SIZE = 18.0f;
    private static final String SELECTED_ITEM_COLOR = "#353535";
    private static final int PROVINCE_INITIAL_INDEX = 0;
    private Context mContext;
    private List<Province> mProvinceList;
    private List<City> mCityList;
    private List<String> mProvinceName;
    private List<String> mCityName;
    private AssetManager mAssetManager;
    private LinearLayout.LayoutParams mLayoutParams;
    private WheelPicker mWPProvince;
    private WheelPicker mWPCity;
    private WheelPicker mWPArea;

    public WheelAreaPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initLayoutParams();
        this.initView(context);
        this.mProvinceList = this.getJsonDataFromAssets(this.mAssetManager);
        this.obtainProvinceData();
        this.addListenerToWheelPicker();
    }

    private List<Province> getJsonDataFromAssets(AssetManager assetManager) {
        List provinceList = null;
        try {
            InputStream inputStream = assetManager.open("RegionJsonData.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            provinceList = (List)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return provinceList;
    }

    private void initLayoutParams() {
        this.mLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.mLayoutParams.setMargins(5, 5, 5, 5);
        this.mLayoutParams.width = 0;
    }

    private void initView(Context context) {
        this.setOrientation(0);
        this.mContext = context;
        this.mAssetManager = this.mContext.getAssets();
        this.mProvinceName = new ArrayList<String>();
        this.mCityName = new ArrayList<String>();
        this.mWPProvince = new WheelPicker(context);
        this.mWPCity = new WheelPicker(context);
        this.mWPArea = new WheelPicker(context);
        this.initWheelPicker(this.mWPProvince, 1.0f);
        this.initWheelPicker(this.mWPCity, 1.5f);
        this.initWheelPicker(this.mWPArea, 1.5f);
    }

    private void initWheelPicker(WheelPicker wheelPicker, float weight) {
        this.mLayoutParams.weight = weight;
        wheelPicker.setItemTextSize(this.dip2px(this.mContext, 18.0f));
        wheelPicker.setSelectedItemTextColor(Color.parseColor((String)SELECTED_ITEM_COLOR));
        wheelPicker.setCurved(true);
        wheelPicker.setLayoutParams((ViewGroup.LayoutParams)this.mLayoutParams);
        this.addView(wheelPicker);
    }

    private void obtainProvinceData() {
        for (Province province : this.mProvinceList) {
            this.mProvinceName.add(province.getName());
        }
        this.mWPProvince.setData(this.mProvinceName);
        this.setCityAndAreaData(0);
    }

    private void addListenerToWheelPicker() {
        this.mWPProvince.setOnItemSelectedListener(new WheelPicker.OnItemSelectedListener(){

            @Override
            public void onItemSelected(WheelPicker picker, Object data, int position) {
                WheelAreaPicker.this.mCityList = ((Province)WheelAreaPicker.this.mProvinceList.get(position)).getCity();
                WheelAreaPicker.this.setCityAndAreaData(position);
            }
        });
        this.mWPCity.setOnItemSelectedListener(new WheelPicker.OnItemSelectedListener(){

            @Override
            public void onItemSelected(WheelPicker picker, Object data, int position) {
                WheelAreaPicker.this.mWPArea.setData(((City)WheelAreaPicker.this.mCityList.get(position)).getArea());
            }
        });
    }

    private void setCityAndAreaData(int position) {
        this.mCityList = this.mProvinceList.get(position).getCity();
        this.mCityName.clear();
        for (City city : this.mCityList) {
            this.mCityName.add(city.getName());
        }
        this.mWPCity.setData(this.mCityName);
        this.mWPCity.setSelectedItemPosition(0);
        this.mWPArea.setData(this.mCityList.get(0).getArea());
        this.mWPArea.setSelectedItemPosition(0);
    }

    @Override
    public String getProvince() {
        return this.mProvinceList.get(this.mWPProvince.getCurrentItemPosition()).getName();
    }

    @Override
    public String getCity() {
        return this.mCityList.get(this.mWPCity.getCurrentItemPosition()).getName();
    }

    @Override
    public String getArea() {
        return this.mCityList.get(this.mWPCity.getCurrentItemPosition()).getArea().get(this.mWPArea.getCurrentItemPosition());
    }

    @Override
    public void hideArea() {
        this.removeViewAt(2);
    }

    private int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

