/*
 * Decompiled with CFR 0.152.
 */
package com.todkars.shimmer;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.shimmer.Shimmer;
import com.todkars.shimmer.R;
import com.todkars.shimmer.ShimmerAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ShimmerRecyclerView
extends RecyclerView {
    public static final int LAYOUT_GRID = 1;
    public static final int LAYOUT_LIST = 0;
    private ShimmerAdapter mShimmerAdapter;
    private RecyclerView.Adapter mActualAdapter;
    private RecyclerView.LayoutManager mShimmerLayoutManager;
    private RecyclerView.LayoutManager mLayoutManager;
    private boolean isShimmerShowing;
    private int mLayoutOrientation = 1;
    private boolean mLayoutReverse = false;
    private int mGridSpanCount = -1;
    @LayoutRes
    private int mShimmerLayout = 0;
    private int mShimmerItemCount = 9;
    private int mLayoutType = 0;
    private ShimmerAdapter.ItemViewType mItemViewType = null;
    private Shimmer shimmer;

    public ShimmerRecyclerView(@NonNull Context context) {
        super(context);
        this.initialize(context, null);
    }

    public ShimmerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public ShimmerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context, attrs);
    }

    @CallSuper
    public void setLayoutManager(@Nullable RecyclerView.LayoutManager manager) {
        if (manager == null) {
            this.mLayoutManager = null;
        } else if (manager != this.mShimmerLayoutManager) {
            if (manager instanceof GridLayoutManager) {
                this.mGridSpanCount = ((GridLayoutManager)manager).getSpanCount();
            } else if (manager instanceof LinearLayoutManager) {
                this.mGridSpanCount = -1;
                this.mLayoutReverse = ((LinearLayoutManager)manager).getReverseLayout();
                this.mLayoutOrientation = ((LinearLayoutManager)manager).getOrientation();
            }
            this.mLayoutManager = manager;
        }
        this.initializeLayoutManager();
        this.invalidateShimmerAdapter();
        super.setLayoutManager(manager);
    }

    @CallSuper
    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        if (adapter == null) {
            this.mActualAdapter = null;
        } else if (adapter != this.mShimmerAdapter) {
            this.mActualAdapter = adapter;
        }
        super.setAdapter(adapter);
    }

    public final void showShimmer() {
        if (this.mShimmerLayoutManager == null) {
            this.initializeLayoutManager();
        }
        this.setLayoutManager(this.mShimmerLayoutManager);
        this.invalidateShimmerAdapter();
        this.setAdapter(this.getShimmerAdapter());
        this.isShimmerShowing = true;
    }

    public final void hideShimmer() {
        this.setLayoutManager(this.mLayoutManager);
        this.setAdapter(this.getActualAdapter());
        this.isShimmerShowing = false;
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager manager, @LayoutRes int shimmerLayout) {
        this.setShimmerLayout(shimmerLayout);
        this.setLayoutManager(manager);
    }

    public final boolean isShimmerShowing() {
        return this.isShimmerShowing;
    }

    public final void setShimmerLayout(@LayoutRes int layout2) {
        this.mShimmerLayout = layout2;
    }

    @LayoutRes
    public final int getShimmerLayout() {
        return this.mShimmerLayout;
    }

    public final void setShimmerItemCount(int count) {
        this.mShimmerItemCount = count;
    }

    public final int getShimmerItemCount() {
        return this.mShimmerItemCount;
    }

    public final void setShimmerLayoutManager(@NonNull RecyclerView.LayoutManager manager) {
        this.mShimmerLayoutManager = manager;
    }

    public final RecyclerView.LayoutManager getShimmerLayoutManager() {
        return this.mShimmerLayoutManager;
    }

    public final void setShimmer(Shimmer shimmer) {
        this.shimmer = shimmer;
    }

    public final Shimmer getShimmer() {
        return this.shimmer;
    }

    public final ShimmerAdapter getShimmerAdapter() {
        if (this.mShimmerAdapter == null) {
            this.mShimmerAdapter = new ShimmerAdapter(this.mShimmerLayout, this.mShimmerItemCount, this.mLayoutType, this.mItemViewType, this.shimmer, this.mLayoutOrientation);
        }
        return this.mShimmerAdapter;
    }

    public final RecyclerView.Adapter getActualAdapter() {
        return this.mActualAdapter;
    }

    public final void setItemViewType(ShimmerAdapter.ItemViewType itemViewType) {
        this.mItemViewType = itemViewType;
    }

    private void initialize(Context context, AttributeSet attrs) {
        if (this.shimmer == null) {
            this.shimmer = this.getDefaultSettings(context, attrs);
        }
    }

    private void invalidateShimmerAdapter() {
        this.getShimmerAdapter();
        this.mShimmerAdapter.setLayout(this.mShimmerLayout);
        this.mShimmerAdapter.setCount(this.mShimmerItemCount);
        this.mShimmerAdapter.setShimmerItemViewType(this.mLayoutType, this.mItemViewType);
        this.mShimmerAdapter.setShimmer(this.shimmer);
        this.mShimmerAdapter.notifyDataSetChanged();
    }

    private void tryAssigningDefaultLayout(boolean isGrid) {
        if (this.mShimmerLayout == 0 || this.mShimmerLayout == R.layout.recyclerview_shimmer_item_grid || this.mShimmerLayout == R.layout.recyclerview_shimmer_item_list) {
            this.mShimmerLayout = isGrid ? R.layout.recyclerview_shimmer_item_grid : R.layout.recyclerview_shimmer_item_list;
        }
    }

    private void initializeLayoutManager() {
        this.mShimmerLayoutManager = this.mGridSpanCount >= 0 ? new GridLayoutManager(this.getContext(), this.mGridSpanCount, this.mLayoutOrientation, this.mLayoutReverse){

            public boolean canScrollVertically() {
                return !ShimmerRecyclerView.this.isShimmerShowing;
            }

            public boolean canScrollHorizontally() {
                return !ShimmerRecyclerView.this.isShimmerShowing;
            }
        } : new LinearLayoutManager(this.getContext(), this.mLayoutOrientation, this.mLayoutReverse){

            public boolean canScrollVertically() {
                return !ShimmerRecyclerView.this.isShimmerShowing;
            }

            public boolean canScrollHorizontally() {
                return !ShimmerRecyclerView.this.isShimmerShowing;
            }
        };
        boolean isGridLayoutManager = this.mShimmerLayoutManager instanceof GridLayoutManager;
        this.mLayoutType = isGridLayoutManager ? 1 : 0;
        this.tryAssigningDefaultLayout(isGridLayoutManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shimmer getDefaultSettings(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return ((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)new Shimmer.AlphaHighlightBuilder().setBaseAlpha(1.0f)).setHighlightAlpha(0.3f)).setTilt(25.0f)).build();
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShimmerRecyclerView, 0, 0);
        try {
            Shimmer.AlphaHighlightBuilder builder;
            Object object = builder = a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_colored) && a.getBoolean(R.styleable.ShimmerRecyclerView_shimmer_recycler_colored, false) ? new Shimmer.ColorHighlightBuilder() : new Shimmer.AlphaHighlightBuilder();
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_layout)) {
                this.setShimmerLayout(a.getResourceId(R.styleable.ShimmerRecyclerView_shimmer_recycler_layout, this.mShimmerLayout));
            }
            this.setShimmerItemCount(a.getInteger(R.styleable.ShimmerRecyclerView_shimmer_recycler_item_count, this.mShimmerItemCount));
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_clip_to_children)) {
                builder.setClipToChildren(a.getBoolean(R.styleable.ShimmerRecyclerView_shimmer_recycler_clip_to_children, true));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_auto_start)) {
                builder.setAutoStart(a.getBoolean(R.styleable.ShimmerRecyclerView_shimmer_recycler_auto_start, true));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_base_color) && builder instanceof Shimmer.ColorHighlightBuilder) {
                ((Shimmer.ColorHighlightBuilder)builder).setBaseColor(a.getColor(R.styleable.ShimmerRecyclerView_shimmer_recycler_base_color, 0x4CFFFFFF));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_highlight_color) && builder instanceof Shimmer.ColorHighlightBuilder) {
                ((Shimmer.ColorHighlightBuilder)builder).setHighlightColor(a.getColor(R.styleable.ShimmerRecyclerView_shimmer_recycler_highlight_color, -1));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_base_alpha)) {
                builder.setBaseAlpha(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_base_alpha, 1.0f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_highlight_alpha)) {
                builder.setHighlightAlpha(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_highlight_alpha, 0.3f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_duration)) {
                builder.setDuration((long)a.getInteger(R.styleable.ShimmerRecyclerView_shimmer_recycler_duration, 1000));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_count)) {
                builder.setRepeatCount(a.getInt(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_count, -1));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_delay)) {
                builder.setRepeatDelay((long)a.getInt(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_delay, 0));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_mode)) {
                builder.setRepeatMode(a.getInt(R.styleable.ShimmerRecyclerView_shimmer_recycler_repeat_mode, 1));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_direction)) {
                int direction = a.getInt(R.styleable.ShimmerRecyclerView_shimmer_recycler_direction, 0);
                switch (direction) {
                    default: {
                        builder.setDirection(0);
                        break;
                    }
                    case 1: {
                        builder.setDirection(1);
                        break;
                    }
                    case 2: {
                        builder.setDirection(2);
                        break;
                    }
                    case 3: {
                        builder.setDirection(3);
                    }
                }
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_shape)) {
                int shape = a.getInt(R.styleable.ShimmerRecyclerView_shimmer_recycler_shape, 0);
                switch (shape) {
                    default: {
                        builder.setShape(0);
                        break;
                    }
                    case 1: {
                        builder.setShape(1);
                    }
                }
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_fixed_width)) {
                builder.setFixedWidth(a.getDimensionPixelSize(R.styleable.ShimmerRecyclerView_shimmer_recycler_fixed_width, 0));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_fixed_height)) {
                builder.setFixedHeight(a.getDimensionPixelSize(R.styleable.ShimmerRecyclerView_shimmer_recycler_fixed_height, 0));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_width_ratio)) {
                builder.setWidthRatio(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_width_ratio, 1.0f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_height_ratio)) {
                builder.setHeightRatio(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_height_ratio, 1.0f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_intensity)) {
                builder.setIntensity(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_intensity, 0.0f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_dropoff)) {
                builder.setDropoff(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_dropoff, 0.5f));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_shimmer_recycler_tilt)) {
                builder.setTilt(a.getFloat(R.styleable.ShimmerRecyclerView_shimmer_recycler_tilt, 25.0f));
            }
            Shimmer shimmer = builder.build();
            return shimmer;
        }
        finally {
            a.recycle();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LayoutType {
    }
}

