/*
 * Decompiled with CFR 0.152.
 */
package com.todkars.shimmer;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.shimmer.Shimmer;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.todkars.shimmer.R;
import com.todkars.shimmer.ShimmerViewHolder;

public final class ShimmerAdapter
extends RecyclerView.Adapter<ShimmerViewHolder> {
    private Shimmer shimmer;
    @LayoutRes
    private int layout;
    private int itemCount;
    private int layoutManagerType;
    private ItemViewType itemViewType;
    private int mLayoutOrientation;

    ShimmerAdapter(@LayoutRes int layout2, int itemCount, int layoutManagerType, ItemViewType itemViewType, Shimmer shimmer, int layoutOrientation) {
        this.layout = layout2;
        this.itemCount = this.validateCount(itemCount);
        this.layoutManagerType = layoutManagerType;
        this.itemViewType = itemViewType;
        this.shimmer = shimmer;
        this.mLayoutOrientation = layoutOrientation;
    }

    public int getItemViewType(int position) {
        return this.itemViewType != null ? this.itemViewType.getItemViewType(this.layoutManagerType, position) : this.layout;
    }

    @NonNull
    public ShimmerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View view = inflater.inflate(R.layout.recyclerview_shimmer_viewholder_layout, parent, false);
        if (this.mLayoutOrientation == 0) {
            view.getLayoutParams().width = -2;
        }
        return new ShimmerViewHolder((ShimmerFrameLayout)inflater.inflate(viewType, (ViewGroup)((ShimmerFrameLayout)view), true));
    }

    public void onBindViewHolder(@NonNull ShimmerViewHolder holder, int position) {
        holder.bindView(this.shimmer);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    void setShimmer(Shimmer shimmer) {
        this.shimmer = shimmer;
    }

    void setLayout(@LayoutRes int layout2) {
        this.layout = layout2;
    }

    void setCount(int count) {
        this.itemCount = this.validateCount(count);
    }

    void setShimmerItemViewType(int layoutManagerType, ItemViewType itemViewType) {
        this.layoutManagerType = layoutManagerType;
        this.itemViewType = itemViewType;
    }

    private int validateCount(int count) {
        return count < 20 ? count : 20;
    }

    public static interface ItemViewType {
        @LayoutRes
        public int getItemViewType(int var1, int var2);
    }
}

