/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.view.MotionEvent;
import com.willy.ratingbar.PartialView;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

class RatingBarUtils {
    private static DecimalFormat mDecimalFormat;
    private static final int MAX_CLICK_DISTANCE = 5;
    private static final int MAX_CLICK_DURATION = 200;

    RatingBarUtils() {
    }

    static boolean isClickEvent(float startX, float startY, MotionEvent event) {
        float duration = event.getEventTime() - event.getDownTime();
        if (duration > 200.0f) {
            return false;
        }
        float differenceX = Math.abs(startX - event.getX());
        float differenceY = Math.abs(startY - event.getY());
        return !(differenceX > 5.0f) && !(differenceY > 5.0f);
    }

    static float calculateRating(PartialView partialView, float stepSize, float eventX) {
        DecimalFormat decimalFormat = RatingBarUtils.getDecimalFormat();
        float ratioOfView = Float.parseFloat(decimalFormat.format((eventX - (float)partialView.getLeft()) / (float)partialView.getWidth()));
        float steps = (float)Math.round(ratioOfView / stepSize) * stepSize;
        return Float.parseFloat(decimalFormat.format((float)((Integer)partialView.getTag()).intValue() - (1.0f - steps)));
    }

    static float getValidMinimumStars(float minimumStars, int numStars, float stepSize) {
        if (minimumStars < 0.0f) {
            minimumStars = 0.0f;
        }
        if (minimumStars > (float)numStars) {
            minimumStars = numStars;
        }
        if (minimumStars % stepSize != 0.0f) {
            minimumStars = stepSize;
        }
        return minimumStars;
    }

    static DecimalFormat getDecimalFormat() {
        if (mDecimalFormat == null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            mDecimalFormat = new DecimalFormat("#.##", symbols);
        }
        return mDecimalFormat;
    }
}

