/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.willy.ratingbar.R;
import java.util.Map;

abstract class BaseRatingBar
extends LinearLayout {
    protected int mNumStars = 5;
    protected int mRating = 0;
    protected int mPadding = 20;
    protected Drawable mEmptyDrawable;
    protected Drawable mFilledDrawable;
    protected Map<ImageView, Boolean> mRatingViewStatus;

    public BaseRatingBar(Context context) {
        this(context, null);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBarAttributes);
        for (int i = 0; i < typedArray.getIndexCount(); ++i) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.RatingBarAttributes_numStars) {
                this.mNumStars = typedArray.getInt(attr, 5);
                continue;
            }
            if (attr == R.styleable.RatingBarAttributes_starPadding) {
                this.mPadding = typedArray.getInt(attr, 20);
                continue;
            }
            if (attr == R.styleable.RatingBarAttributes_rating) {
                this.mRating = typedArray.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.RatingBarAttributes_drawableEmpty) {
                this.mEmptyDrawable = typedArray.getDrawable(attr);
                continue;
            }
            if (attr != R.styleable.RatingBarAttributes_drawableFilled) continue;
            this.mFilledDrawable = typedArray.getDrawable(attr);
        }
        typedArray.recycle();
        this.init();
    }

    protected void init() {
        if (this.mEmptyDrawable == null) {
            this.mEmptyDrawable = this.getResources().getDrawable(R.drawable.start_empty);
        }
        if (this.mFilledDrawable == null) {
            this.mFilledDrawable = this.getResources().getDrawable(R.drawable.star_filled);
        }
        if (this.mRating > this.mNumStars) {
            this.mRating = this.mNumStars;
        }
    }

    abstract void fillRatingBar(int var1);

    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mNumStars = numStars;
    }

    public void setRating(int rating) {
        if (rating > this.mNumStars) {
            rating = this.mNumStars;
        }
        if (rating < 0) {
            rating = 0;
        }
        if (this.mRating == rating) {
            return;
        }
        this.mRating = rating;
        this.fillRatingBar(rating);
    }

    public int getRating() {
        return this.mRating;
    }

    public void setRatingPadding(int ratingPadding) {
        this.mPadding = ratingPadding;
    }

    public void setEmptyDrawable(Drawable drawable2) {
        this.mEmptyDrawable = drawable2;
    }

    public void setFilledDrawableId(Drawable drawable2) {
        this.mFilledDrawable = drawable2;
    }
}

