/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import androidx.annotation.LayoutRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.FragmentContainerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.github.nukc.stateview.AnimatorProvider;
import com.github.nukc.stateview.Injector;
import com.github.nukc.stateview.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 M2\u00020\u0001:\u0003KLMB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0014J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0017J\u0010\u00107\u001a\u0002012\u0006\u00105\u001a\u000206H\u0014J\u0010\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u0007H\u0016J\u001a\u00108\u001a\u0002012\b\u0010:\u001a\u0004\u0018\u00010\u00012\u0006\u00109\u001a\u00020\u0007H\u0002J\u0016\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u0001J\u0006\u0010=\u001a\u000201J\u0006\u0010>\u001a\u00020\u0001J\u0006\u0010?\u001a\u00020\u0001J\u0006\u0010@\u001a\u00020\u0001J\u000e\u0010A\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u0007J\u0012\u0010B\u001a\u00020\u00012\b\b\u0001\u0010C\u001a\u00020\u0007H\u0002J\u0010\u0010D\u001a\u0002012\u0006\u0010B\u001a\u00020\u0001H\u0002J\u0010\u0010E\u001a\u0002012\u0006\u0010:\u001a\u00020\u0001H\u0002J\u0012\u0010F\u001a\u0002012\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010G\u001a\u00020\u00012\b\b\u0001\u0010C\u001a\u00020\u0007H\u0002J\"\u0010H\u001a\u00020\u00012\b\b\u0001\u0010C\u001a\u00020\u00072\u0006\u0010I\u001a\u00020J2\u0006\u0010:\u001a\u00020\u0001H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001e\u0010\u0014\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R(\u0010+\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006N"}, d2={"Lcom/github/nukc/stateview/StateView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "views", "Landroid/util/SparseArray;", "emptyResource", "getEmptyResource", "()I", "setEmptyResource", "(I)V", "retryResource", "getRetryResource", "setRetryResource", "loadingResource", "getLoadingResource", "setLoadingResource", "inflater", "Landroid/view/LayoutInflater;", "getInflater", "()Landroid/view/LayoutInflater;", "setInflater", "(Landroid/view/LayoutInflater;)V", "onRetryClickListener", "Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "getOnRetryClickListener", "()Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "setOnRetryClickListener", "(Lcom/github/nukc/stateview/StateView$OnRetryClickListener;)V", "onInflateListener", "Lcom/github/nukc/stateview/StateView$OnInflateListener;", "getOnInflateListener", "()Lcom/github/nukc/stateview/StateView$OnInflateListener;", "setOnInflateListener", "(Lcom/github/nukc/stateview/StateView$OnInflateListener;)V", "value", "Lcom/github/nukc/stateview/AnimatorProvider;", "animatorProvider", "getAnimatorProvider", "()Lcom/github/nukc/stateview/AnimatorProvider;", "setAnimatorProvider", "(Lcom/github/nukc/stateview/AnimatorProvider;)V", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "draw", "canvas", "Landroid/graphics/Canvas;", "dispatchDraw", "setVisibility", "visibility", "view", "setView", "viewType", "showContent", "showEmpty", "showRetry", "showLoading", "show", "showView", "layoutResource", "hideViews", "startAnimation", "reset", "inflate", "addToParent", "viewParent", "Landroid/view/ViewGroup;", "OnRetryClickListener", "OnInflateListener", "Companion", "kotlin_release"})
public final class StateView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<View> views;
    @LayoutRes
    private int emptyResource;
    @LayoutRes
    private int retryResource;
    @LayoutRes
    private int loadingResource;
    @Nullable
    private LayoutInflater inflater;
    @Nullable
    private OnRetryClickListener onRetryClickListener;
    @Nullable
    private OnInflateListener onInflateListener;
    @Nullable
    private AnimatorProvider animatorProvider;
    @NotNull
    public static final String TAG = "StateView";

    @JvmOverloads
    public StateView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.views = new SparseArray(3);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StateView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray a = typedArray;
        this.emptyResource = a.getResourceId(R.styleable.StateView_emptyResource, 0);
        this.retryResource = a.getResourceId(R.styleable.StateView_retryResource, 0);
        this.loadingResource = a.getResourceId(R.styleable.StateView_loadingResource, 0);
        a.recycle();
        if (this.emptyResource == 0) {
            this.emptyResource = R.layout.base_empty;
        }
        if (this.retryResource == 0) {
            this.retryResource = R.layout.base_retry;
        }
        if (this.loadingResource == 0) {
            this.loadingResource = R.layout.base_loading;
        }
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    public /* synthetic */ StateView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getEmptyResource() {
        return this.emptyResource;
    }

    public final void setEmptyResource(int n) {
        this.emptyResource = n;
    }

    public final int getRetryResource() {
        return this.retryResource;
    }

    public final void setRetryResource(int n) {
        this.retryResource = n;
    }

    public final int getLoadingResource() {
        return this.loadingResource;
    }

    public final void setLoadingResource(int n) {
        this.loadingResource = n;
    }

    @Nullable
    public final LayoutInflater getInflater() {
        return this.inflater;
    }

    public final void setInflater(@Nullable LayoutInflater layoutInflater) {
        this.inflater = layoutInflater;
    }

    @Nullable
    public final OnRetryClickListener getOnRetryClickListener() {
        return this.onRetryClickListener;
    }

    public final void setOnRetryClickListener(@Nullable OnRetryClickListener onRetryClickListener) {
        this.onRetryClickListener = onRetryClickListener;
    }

    @Nullable
    public final OnInflateListener getOnInflateListener() {
        return this.onInflateListener;
    }

    public final void setOnInflateListener(@Nullable OnInflateListener onInflateListener) {
        this.onInflateListener = onInflateListener;
    }

    @Nullable
    public final AnimatorProvider getAnimatorProvider() {
        return this.animatorProvider;
    }

    public final void setAnimatorProvider(@Nullable AnimatorProvider value) {
        this.animatorProvider = value;
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            this.reset((View)this.views.valueAt(i));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    public void setVisibility(int visibility) {
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            this.setVisibility((View)this.views.valueAt(i), visibility);
        }
    }

    private final void setVisibility(View view, int visibility) {
        if (view != null && visibility != view.getVisibility()) {
            if (this.animatorProvider != null) {
                this.startAnimation(view);
            } else {
                view.setVisibility(visibility);
            }
        }
    }

    public final void setView(int viewType, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.views.put(viewType, (Object)view);
    }

    public final void showContent() {
        this.setVisibility(8);
    }

    @NotNull
    public final View showEmpty() {
        return this.showView(this.emptyResource);
    }

    @NotNull
    public final View showRetry() {
        return this.showView(this.retryResource);
    }

    @NotNull
    public final View showLoading() {
        return this.showView(this.loadingResource);
    }

    @NotNull
    public final View show(int viewType) {
        return this.showView(viewType);
    }

    private final View showView(@LayoutRes int layoutResource) {
        View view = (View)this.views.get(layoutResource);
        if (view == null) {
            view = this.inflate(layoutResource);
            this.views.put(layoutResource, (Object)view);
        } else {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            if (((ViewGroup)viewParent).indexOfChild(view) == -1) {
                ViewParent viewParent2 = this.getParent();
                Intrinsics.checkNotNull((Object)viewParent2, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                this.addToParent(layoutResource, (ViewGroup)viewParent2, view);
            }
        }
        this.setVisibility(view, 0);
        this.hideViews(view);
        return view;
    }

    private final void hideViews(View showView) {
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            View view = (View)this.views.valueAt(i);
            if (Intrinsics.areEqual((Object)view, (Object)showView)) continue;
            this.setVisibility(view, 8);
        }
    }

    private final void startAnimation(View view) {
        Animator animator;
        boolean toShow;
        boolean bl = toShow = view.getVisibility() == 8;
        if (toShow) {
            AnimatorProvider animatorProvider = this.animatorProvider;
            Intrinsics.checkNotNull((Object)animatorProvider);
            v2 = animatorProvider.showAnimation(view);
        } else {
            AnimatorProvider animatorProvider = this.animatorProvider;
            Intrinsics.checkNotNull((Object)animatorProvider);
            v2 = animator = animatorProvider.hideAnimation(view);
        }
        if (animator != null) {
            Animator animator2;
            Animator $this$startAnimation_u24lambda_u240 = animator2 = animator;
            boolean bl2 = false;
            $this$startAnimation_u24lambda_u240.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(toShow, view){
                final /* synthetic */ boolean $toShow;
                final /* synthetic */ View $view;
                {
                    this.$toShow = $toShow;
                    this.$view = $view;
                }

                public void onAnimationEnd(Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    super.onAnimationEnd(animation);
                    if (!this.$toShow) {
                        this.$view.setVisibility(8);
                    }
                }

                public void onAnimationStart(Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    super.onAnimationStart(animation);
                    if (this.$toShow) {
                        this.$view.setVisibility(0);
                    }
                }
            });
            $this$startAnimation_u24lambda_u240.start();
        } else {
            StateView it = this;
            boolean bl3 = false;
            view.setVisibility(toShow ? 0 : 8);
        }
    }

    private final void reset(View view) {
        if (view != null) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            view.setAlpha(1.0f);
            view.setRotation(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final View inflate(@LayoutRes int layoutResource) {
        ViewParent viewParent = this.getParent();
        if (!(viewParent instanceof ViewGroup)) throw new IllegalStateException("StateView must have a non-null ViewGroup viewParent");
        if (layoutResource == 0) throw new IllegalArgumentException("StateView must have a valid layoutResource");
        LayoutInflater layoutInflater = this.inflater;
        if (layoutInflater == null) {
            LayoutInflater layoutInflater2 = LayoutInflater.from((Context)this.getContext());
            layoutInflater = layoutInflater2;
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater2, (String)"from(...)");
        }
        LayoutInflater factory = layoutInflater;
        View view = factory.inflate(layoutResource, (ViewGroup)viewParent, false);
        ViewGroup viewGroup = (ViewGroup)viewParent;
        Intrinsics.checkNotNull((Object)view);
        return this.addToParent(layoutResource, viewGroup, view);
    }

    private final View addToParent(@LayoutRes int layoutResource, ViewGroup viewParent, View view) {
        block9: {
            int index = viewParent.indexOfChild((View)this);
            view.setClickable(true);
            view.setVisibility(8);
            ViewCompat.setZ((View)view, (float)ViewCompat.getZ((View)this));
            if (this.getLayoutParams() != null) {
                if (viewParent instanceof RelativeLayout) {
                    RelativeLayout.LayoutParams layoutParams;
                    if (Build.VERSION.SDK_INT >= 19) {
                        ViewGroup.LayoutParams layoutParams2 = this.getLayoutParams();
                        Intrinsics.checkNotNull((Object)layoutParams2, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                        layoutParams = new RelativeLayout.LayoutParams((RelativeLayout.LayoutParams)layoutParams2);
                    } else {
                        layoutParams = new RelativeLayout.LayoutParams(this.getLayoutParams());
                    }
                    RelativeLayout.LayoutParams lp = layoutParams;
                    viewParent.addView(view, index, (ViewGroup.LayoutParams)lp);
                } else if (Injector.INSTANCE.getConstraintLayoutAvailable() && viewParent instanceof ConstraintLayout) {
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                    ConstraintLayout.LayoutParams source = (ConstraintLayout.LayoutParams)layoutParams;
                    ViewGroup.LayoutParams layoutParams3 = this.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                    ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(layoutParams3);
                    lp.leftToLeft = source.leftToLeft;
                    lp.rightToRight = source.rightToRight;
                    lp.topToTop = source.topToTop;
                    lp.bottomToBottom = source.bottomToBottom;
                    lp.verticalBias = source.verticalBias;
                    lp.horizontalBias = source.horizontalBias;
                    ((ConstraintLayout)viewParent).addView(view, index, (ViewGroup.LayoutParams)lp);
                } else {
                    viewParent.addView(view, index, this.getLayoutParams());
                }
            } else {
                viewParent.addView(view, index);
            }
            if (layoutResource == this.retryResource) {
                view.setOnClickListener(arg_0 -> StateView.addToParent$lambda$4(this, view, arg_0));
            }
            OnInflateListener onInflateListener = this.onInflateListener;
            if (onInflateListener == null) break block9;
            onInflateListener.onInflate(layoutResource, view);
        }
        return view;
    }

    @JvmOverloads
    public StateView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StateView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void addToParent$lambda$4$lambda$3$lambda$2(OnRetryClickListener $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.onRetryClick();
    }

    private static final void addToParent$lambda$4(StateView this$0, View $view, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
            OnRetryClickListener onRetryClickListener = this$0.onRetryClickListener;
            if (onRetryClickListener == null) break block0;
            OnRetryClickListener it2 = onRetryClickListener;
            boolean bl = false;
            this$0.showLoading();
            $view.postDelayed(() -> StateView.addToParent$lambda$4$lambda$3$lambda$2(it2), 400L);
        }
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull Activity activity) {
        return Companion.inject(activity);
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull View view) {
        return Companion.inject(view);
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull ViewGroup viewGroup) {
        return Companion.inject(viewGroup);
    }

    @JvmStatic
    @NotNull
    public static final StateView wrap(@NotNull View view) {
        return Companion.wrap(view);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/nukc/stateview/StateView$Companion;", "", "<init>", "()V", "TAG", "", "inject", "Lcom/github/nukc/stateview/StateView;", "activity", "Landroid/app/Activity;", "view", "Landroid/view/View;", "viewGroup", "Landroid/view/ViewGroup;", "wrap", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            View view = activity.getWindow().getDecorView().findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
            return this.inject(view);
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return view instanceof ViewGroup ? this.inject((ViewGroup)view) : this.wrap(view);
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull ViewGroup viewGroup) {
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
            if (viewGroup instanceof LinearLayout || viewGroup instanceof ScrollView || viewGroup instanceof AdapterView || viewGroup instanceof ScrollingView && viewGroup instanceof NestedScrollingChild || viewGroup instanceof NestedScrollingParent && viewGroup instanceof NestedScrollingChild) {
                return viewGroup.getParent() instanceof ViewGroup && !(viewGroup.getParent() instanceof FragmentContainerView) ? this.wrap((View)viewGroup) : Injector.INSTANCE.wrapChild(viewGroup);
            }
            Context context = viewGroup.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            StateView stateView = new StateView(context, null, 0, 6, null);
            viewGroup.addView((View)stateView, -1, -1);
            return stateView;
        }

        @JvmStatic
        @NotNull
        public final StateView wrap(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                if (Injector.INSTANCE.getConstraintLayoutAvailable() && parent instanceof ConstraintLayout) {
                    return Injector.INSTANCE.matchViewIfParentIsConstraintLayout((ConstraintLayout)parent, view);
                }
                if (parent instanceof RelativeLayout) {
                    return Injector.INSTANCE.matchViewIfParentIsRelativeLayout((RelativeLayout)parent, view);
                }
                int index = ((ViewGroup)parent).indexOfChild(view);
                ((ViewGroup)parent).removeView(view);
                FrameLayout wrap = new FrameLayout(view.getContext());
                ((ViewGroup)parent).addView((View)wrap, index, view.getLayoutParams());
                wrap.addView(view, -1, -1);
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                StateView stateView = new StateView(context, null, 0, 6, null);
                wrap.addView((View)stateView, -1, -1);
                Injector.INSTANCE.setStateListAnimator(stateView, view);
                if (Injector.INSTANCE.getSwipeRefreshLayoutAvailable() && parent instanceof SwipeRefreshLayout) {
                    Injector.INSTANCE.injectIntoSwipeRefreshLayout((SwipeRefreshLayout)parent);
                }
                return stateView;
            }
            throw new ClassCastException("view.getParent() must be ViewGroup");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/github/nukc/stateview/StateView$OnInflateListener;", "", "onInflate", "", "layoutResource", "", "view", "Landroid/view/View;", "kotlin_release"})
    public static interface OnInflateListener {
        public void onInflate(@LayoutRes int var1, @NotNull View var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "", "onRetryClick", "", "kotlin_release"})
    public static interface OnRetryClickListener {
        public void onRetryClick();
    }
}

