/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ScrollingView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.github.nukc.stateview.StateView;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/github/nukc/stateview/Injector;", "", "<init>", "()V", "constraintLayoutAvailable", "", "getConstraintLayoutAvailable", "()Z", "swipeRefreshLayoutAvailable", "getSwipeRefreshLayoutAvailable", "wrapChild", "Lcom/github/nukc/stateview/StateView;", "parent", "Landroid/view/ViewGroup;", "matchViewIfParentIsConstraintLayout", "Landroidx/constraintlayout/widget/ConstraintLayout;", "view", "Landroid/view/View;", "matchViewIfParentIsRelativeLayout", "Landroid/widget/RelativeLayout;", "setStateListAnimator", "", "stateView", "target", "injectIntoSwipeRefreshLayout", "layout", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "kotlin_release"})
public final class Injector {
    @NotNull
    public static final Injector INSTANCE;
    private static final boolean constraintLayoutAvailable;
    private static final boolean swipeRefreshLayoutAvailable;

    private Injector() {
    }

    public final boolean getConstraintLayoutAvailable() {
        return constraintLayoutAvailable;
    }

    public final boolean getSwipeRefreshLayoutAvailable() {
        return swipeRefreshLayoutAvailable;
    }

    @NotNull
    public final StateView wrapChild(@NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int screenHeight = 0;
        FrameLayout wrapper = new FrameLayout(parent.getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        wrapper.setLayoutParams(layoutParams);
        if (parent instanceof LinearLayout) {
            LinearLayout wrapLayout = new LinearLayout(((LinearLayout)parent).getContext());
            ViewGroup.LayoutParams layoutParams2 = ((LinearLayout)parent).getLayoutParams();
            if (layoutParams2 == null) {
                layoutParams2 = layoutParams;
            }
            wrapLayout.setLayoutParams(layoutParams2);
            wrapLayout.setOrientation(((LinearLayout)parent).getOrientation());
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView;
                Intrinsics.checkNotNullExpressionValue((Object)parent.getChildAt(0), (String)"getChildAt(...)");
                parent.removeView(childView);
                wrapLayout.addView(childView);
            }
            wrapper.addView((View)wrapLayout);
        } else if (parent instanceof ScrollView || parent instanceof ScrollingView) {
            if (parent.getChildCount() != 1) {
                throw new IllegalStateException("the ScrollView does not have one direct child");
            }
            View directView = parent.getChildAt(0);
            parent.removeView(directView);
            wrapper.addView(directView);
            Object object = parent.getContext().getSystemService("window");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
            WindowManager wm = (WindowManager)object;
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            screenHeight = metrics.heightPixels;
        } else if (parent instanceof NestedScrollingParent && parent instanceof NestedScrollingChild) {
            if (parent.getChildCount() == 2) {
                View targetView = parent.getChildAt(1);
                parent.removeView(targetView);
                wrapper.addView(targetView);
            } else if (parent.getChildCount() > 2) {
                throw new IllegalStateException("the view is not refresh layout? view = " + parent);
            }
        } else {
            throw new IllegalStateException("the view does not have parent, view = " + parent);
        }
        parent.addView((View)wrapper);
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StateView stateView = new StateView(context, null, 0, 6, null);
        if (screenHeight > 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, screenHeight);
            wrapper.addView((View)stateView, params);
        } else {
            wrapper.addView((View)stateView);
        }
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsConstraintLayout(@NotNull ConstraintLayout parent, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StateView stateView = new StateView(context, null, 0, 6, null);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(layoutParams);
        lp.leftToLeft = view.getId();
        lp.rightToRight = view.getId();
        lp.topToTop = view.getId();
        lp.bottomToBottom = view.getId();
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsRelativeLayout(@NotNull RelativeLayout parent, @NotNull View view) {
        RelativeLayout.LayoutParams layoutParams;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StateView stateView = new StateView(context, null, 0, 6, null);
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams layoutParams2 = view.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams2, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            layoutParams = new RelativeLayout.LayoutParams((RelativeLayout.LayoutParams)layoutParams2);
        } else {
            layoutParams = new RelativeLayout.LayoutParams(view.getLayoutParams());
        }
        RelativeLayout.LayoutParams lp = layoutParams;
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        this.setStateListAnimator(stateView, view);
        return stateView;
    }

    public final void setStateListAnimator(@NotNull StateView stateView, @NotNull View target) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateView), (String)"stateView");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (Build.VERSION.SDK_INT >= 21 && target instanceof Button) {
            Log.i((String)"StateView", (String)"for normal display, stateView.stateListAnimator = view.stateListAnimator");
            stateView.setStateListAnimator(((Button)target).getStateListAnimator());
        }
    }

    public final void injectIntoSwipeRefreshLayout(@NotNull SwipeRefreshLayout layout2) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        try {
            Field mTargetField = SwipeRefreshLayout.class.getDeclaredField("mTarget");
            mTargetField.setAccessible(true);
            mTargetField.set(layout2, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        boolean bl;
        INSTANCE = new Injector();
        try {
            bl = Class.forName("androidx.constraintlayout.widget.ConstraintLayout") != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        constraintLayoutAvailable = bl;
        try {
            bl = Class.forName("androidx.swiperefreshlayout.widget.SwipeRefreshLayout") != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        swipeRefreshLayoutAvailable = bl;
    }
}

