/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.utf8;

import com.github.nkzawa.utf8.UTF8Exception;
import java.util.ArrayList;
import java.util.List;

public class UTF8 {
    private static int[] byteArray;
    private static int byteCount;
    private static int byteIndex;

    public static String encode(String string) {
        int[] codePoints = UTF8.uc2decode(string);
        int length = codePoints.length;
        int index = -1;
        StringBuilder byteString = new StringBuilder();
        while (++index < length) {
            int codePoint = codePoints[index];
            byteString.append(UTF8.encodeCodePoint(codePoint));
        }
        return byteString.toString();
    }

    public static String decode(String byteString) throws UTF8Exception {
        int tmp;
        byteArray = UTF8.uc2decode(byteString);
        byteCount = byteArray.length;
        byteIndex = 0;
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        while ((tmp = UTF8.decodeSymbol()) != -1) {
            codePoints.add(tmp);
        }
        return UTF8.ucs2encode(UTF8.listToArray(codePoints));
    }

    private static int[] uc2decode(String string) {
        int value;
        int length = string.length();
        int[] output = new int[string.codePointCount(0, length)];
        int counter = 0;
        for (int i = 0; i < length; i += Character.charCount(value)) {
            value = string.codePointAt(i);
            output[counter++] = value;
        }
        return output;
    }

    private static String encodeCodePoint(int codePoint) {
        StringBuilder symbol = new StringBuilder();
        if ((codePoint & 0xFFFFFF80) == 0) {
            return symbol.append(Character.toChars(codePoint)).toString();
        }
        if ((codePoint & 0xFFFFF800) == 0) {
            symbol.append(Character.toChars(codePoint >> 6 & 0x1F | 0xC0));
        } else if ((codePoint & 0xFFFF0000) == 0) {
            symbol.append(Character.toChars(codePoint >> 12 & 0xF | 0xE0));
            symbol.append(UTF8.createByte(codePoint, 6));
        } else if ((codePoint & 0xFFE00000) == 0) {
            symbol.append(Character.toChars(codePoint >> 18 & 7 | 0xF0));
            symbol.append(UTF8.createByte(codePoint, 12));
            symbol.append(UTF8.createByte(codePoint, 6));
        }
        symbol.append(Character.toChars(codePoint & 0x3F | 0x80));
        return symbol.toString();
    }

    private static char[] createByte(int codePoint, int shift) {
        return Character.toChars(codePoint >> shift & 0x3F | 0x80);
    }

    private static int decodeSymbol() throws UTF8Exception {
        int byte4;
        int byte3;
        int byte2;
        int codePoint;
        if (byteIndex > byteCount) {
            throw new UTF8Exception("Invalid byte index");
        }
        if (byteIndex == byteCount) {
            return -1;
        }
        int byte1 = byteArray[byteIndex] & 0xFF;
        ++byteIndex;
        if ((byte1 & 0x80) == 0) {
            return byte1;
        }
        if ((byte1 & 0xE0) == 192) {
            int byte22 = UTF8.readContinuationByte();
            int codePoint2 = (byte1 & 0x1F) << 6 | byte22;
            if (codePoint2 >= 128) {
                return codePoint2;
            }
            throw new UTF8Exception("Invalid continuation byte");
        }
        if ((byte1 & 0xF0) == 224) {
            int byte32;
            int byte23 = UTF8.readContinuationByte();
            int codePoint3 = (byte1 & 0xF) << 12 | byte23 << 6 | (byte32 = UTF8.readContinuationByte());
            if (codePoint3 >= 2048) {
                return codePoint3;
            }
            throw new UTF8Exception("Invalid continuation byte");
        }
        if ((byte1 & 0xF8) == 240 && (codePoint = (byte1 & 0xF) << 18 | (byte2 = UTF8.readContinuationByte()) << 12 | (byte3 = UTF8.readContinuationByte()) << 6 | (byte4 = UTF8.readContinuationByte())) >= 65536 && codePoint <= 0x10FFFF) {
            return codePoint;
        }
        throw new UTF8Exception("Invalid continuation byte");
    }

    private static int readContinuationByte() throws UTF8Exception {
        if (byteIndex >= byteCount) {
            throw new UTF8Exception("Invalid byte index");
        }
        int continuationByte = byteArray[byteIndex] & 0xFF;
        ++byteIndex;
        if ((continuationByte & 0xC0) == 128) {
            return continuationByte & 0x3F;
        }
        throw new UTF8Exception("Invalid continuation byte");
    }

    private static String ucs2encode(int[] array) {
        StringBuilder output = new StringBuilder();
        for (int value : array) {
            output.appendCodePoint(value);
        }
        return output.toString();
    }

    private static int[] listToArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }
}

