/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.github.niqdev.mjpeg.AbstractMjpegView;
import com.github.niqdev.mjpeg.DisplayMode;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegInputStreamNative;
import com.github.niqdev.mjpeg.MjpegViewDefault;
import com.github.niqdev.mjpeg.OnFrameCapturedListener;
import java.io.IOException;

public class MjpegViewNative
extends AbstractMjpegView {
    private static final String TAG = MjpegViewDefault.class.getSimpleName();
    private SurfaceHolder.Callback mSurfaceHolderCallback;
    private SurfaceView mSurfaceView;
    private boolean transparentBackground;
    private SurfaceHolder holder;
    private MjpegViewThread thread;
    private MjpegInputStreamNative mIn = null;
    private boolean showFps = false;
    private boolean mRun = false;
    private boolean surfaceDone = false;
    private Paint overlayPaint;
    private int overlayTextColor;
    private int overlayBackgroundColor;
    private int backgroundColor;
    private int ovlPos;
    private int dispWidth;
    private int dispHeight;
    private int displayMode;
    private boolean suspending = false;
    private Bitmap bmp = null;
    private int IMG_WIDTH = 640;
    private int IMG_HEIGHT = 480;

    private void init() {
        this.holder = this.mSurfaceView.getHolder();
        this.holder.addCallback(this.mSurfaceHolderCallback);
        this.thread = new MjpegViewThread(this.holder);
        this.mSurfaceView.setFocusable(true);
        this.overlayPaint = new Paint();
        this.overlayPaint.setTextAlign(Paint.Align.LEFT);
        this.overlayPaint.setTextSize(12.0f);
        this.overlayPaint.setTypeface(Typeface.DEFAULT);
        this.overlayTextColor = -1;
        this.overlayBackgroundColor = -16777216;
        this.backgroundColor = -16777216;
        this.ovlPos = 6;
        this.displayMode = 1;
        this.dispWidth = this.mSurfaceView.getWidth();
        this.dispHeight = this.mSurfaceView.getHeight();
    }

    void _startPlayback() {
        if (this.mIn != null) {
            this.mRun = true;
            if (this.thread == null) {
                this.thread = new MjpegViewThread(this.holder);
            }
            this.thread.start();
        }
    }

    void _resumePlayback() {
        if (this.suspending && this.mIn != null) {
            this.mRun = true;
            SurfaceHolder holder = this.mSurfaceView.getHolder();
            holder.addCallback(this.mSurfaceHolderCallback);
            this.thread = new MjpegViewThread(holder);
            this.thread.start();
            this.suspending = false;
        }
    }

    void _stopPlayback() {
        if (this.mRun) {
            this.suspending = true;
        }
        this.mRun = false;
        if (this.thread != null) {
            boolean retry = true;
            while (retry) {
                try {
                    this.thread.join();
                    retry = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        if (this.mIn != null) {
            try {
                this.mIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mIn = null;
        }
    }

    void _freeCameraMemory() {
        if (this.mIn != null) {
            this.mIn.freeCameraMemory();
        }
    }

    void _surfaceChanged(SurfaceHolder holder, int f, int w, int h) {
        if (this.thread != null) {
            this.thread.setSurfaceSize(w, h);
        }
    }

    void _surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceDone = false;
        this._stopPlayback();
        if (this.thread != null) {
            this.thread = null;
        }
    }

    MjpegViewNative(SurfaceView surfaceView, SurfaceHolder.Callback callback, boolean transparentBackground) {
        this.mSurfaceView = surfaceView;
        this.mSurfaceHolderCallback = callback;
        this.transparentBackground = transparentBackground;
        this.init();
    }

    void _surfaceCreated(SurfaceHolder holder) {
        this.surfaceDone = true;
    }

    void _showFps(boolean b) {
        this.showFps = b;
    }

    void _setSource(MjpegInputStreamNative source) {
        this.mIn = source;
        if (!this.suspending) {
            this._startPlayback();
        } else {
            this._resumePlayback();
        }
    }

    void _setOverlayPaint(Paint p) {
        this.overlayPaint = p;
    }

    void _setOverlayTextColor(int c) {
        this.overlayTextColor = c;
    }

    void _setOverlayBackgroundColor(int c) {
        this.overlayBackgroundColor = c;
    }

    void _setOverlayPosition(int p) {
        this.ovlPos = p;
    }

    void _setDisplayMode(int s) {
        this.displayMode = s;
    }

    void _setResolution(int w, int h) {
        this.IMG_WIDTH = w;
        this.IMG_HEIGHT = h;
    }

    boolean _isStreaming() {
        return this.mRun;
    }

    @Override
    public void onSurfaceCreated(SurfaceHolder holder) {
        this._surfaceCreated(holder);
    }

    @Override
    public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this._surfaceChanged(holder, format, width, height);
    }

    @Override
    public void onSurfaceDestroyed(SurfaceHolder holder) {
        this._surfaceDestroyed(holder);
    }

    @Override
    public void setSource(MjpegInputStream stream) {
        if (!(stream instanceof MjpegInputStreamNative)) {
            throw new IllegalArgumentException("stream must be an instance of MjpegInputStreamNative");
        }
        this._setSource((MjpegInputStreamNative)stream);
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        this._setDisplayMode(mode.getValue());
    }

    @Override
    public void showFps(boolean show) {
        this._showFps(show);
    }

    @Override
    public void flipSource(boolean flip) {
        this.flipHorizontal(flip);
    }

    @Override
    public void flipHorizontal(boolean flip) {
    }

    @Override
    public void flipVertical(boolean flip) {
    }

    @Override
    public void setRotate(float degrees) {
    }

    @Override
    public void stopPlayback() {
        this._stopPlayback();
    }

    @Override
    public boolean isStreaming() {
        return this._isStreaming();
    }

    @Override
    public void setResolution(int width, int height) {
        this._setResolution(width, height);
    }

    @Override
    public void freeCameraMemory() {
        this._freeCameraMemory();
    }

    @Override
    public void setOnFrameCapturedListener(OnFrameCapturedListener onFrameCapturedListener) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void setCustomBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void setFpsOverlayBackgroundColor(int overlayBackgroundColor) {
        this.overlayBackgroundColor = overlayBackgroundColor;
    }

    @Override
    public void setFpsOverlayTextColor(int overlayTextColor) {
        this.overlayTextColor = overlayTextColor;
    }

    @Override
    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    @Override
    public void resetTransparentBackground() {
        this.mSurfaceView.setZOrderOnTop(false);
        this.mSurfaceView.getHolder().setFormat(-1);
    }

    @Override
    public void setTransparentBackground() {
        this.mSurfaceView.setZOrderOnTop(true);
        this.mSurfaceView.getHolder().setFormat(-2);
    }

    @Override
    public void clearStream() {
        Canvas c = null;
        try {
            c = this.mSurfaceView.getHolder().lockCanvas();
            c.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        finally {
            if (c != null) {
                this.mSurfaceView.getHolder().unlockCanvasAndPost(c);
            } else {
                Log.w((String)TAG, (String)"couldn't unlock surface canvas");
            }
        }
    }

    class MjpegViewThread
    extends Thread {
        private SurfaceHolder mSurfaceHolder;
        private int frameCounter = 0;
        private long start;
        private String fps = "";

        MjpegViewThread(SurfaceHolder surfaceHolder) {
            this.mSurfaceHolder = surfaceHolder;
        }

        private Rect destRect(int bmw, int bmh) {
            if (MjpegViewNative.this.displayMode == 1) {
                int tempx = MjpegViewNative.this.dispWidth / 2 - bmw / 2;
                int tempy = MjpegViewNative.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (MjpegViewNative.this.displayMode == 4) {
                float bmasp = (float)bmw / (float)bmh;
                bmw = MjpegViewNative.this.dispWidth;
                bmh = (int)((float)MjpegViewNative.this.dispWidth / bmasp);
                if (bmh > MjpegViewNative.this.dispHeight) {
                    bmh = MjpegViewNative.this.dispHeight;
                    bmw = (int)((float)MjpegViewNative.this.dispHeight * bmasp);
                }
                int tempx = MjpegViewNative.this.dispWidth / 2 - bmw / 2;
                int tempy = MjpegViewNative.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (MjpegViewNative.this.displayMode == 8) {
                return new Rect(0, 0, MjpegViewNative.this.dispWidth, MjpegViewNative.this.dispHeight);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSurfaceSize(int width, int height) {
            SurfaceHolder surfaceHolder = this.mSurfaceHolder;
            synchronized (surfaceHolder) {
                MjpegViewNative.this.dispWidth = width;
                MjpegViewNative.this.dispHeight = height;
            }
        }

        private Bitmap makeFpsOverlay(Paint p) {
            Rect b = new Rect();
            p.getTextBounds(this.fps, 0, this.fps.length(), b);
            Bitmap bm = Bitmap.createBitmap((int)b.width(), (int)b.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(bm);
            p.setColor(MjpegViewNative.this.overlayBackgroundColor);
            c.drawRect(0.0f, 0.0f, (float)b.width(), (float)b.height(), p);
            p.setColor(MjpegViewNative.this.overlayTextColor);
            c.drawText(this.fps, (float)(-b.left), (float)(b.bottom - b.top) - p.descent(), p);
            return bm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            this.start = System.currentTimeMillis();
            PorterDuffXfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_OVER);
            Paint p = new Paint();
            Bitmap ovl = null;
            while (MjpegViewNative.this.mRun) {
                Canvas c;
                Rect destRect;
                block17: {
                    block18: {
                        int ret;
                        destRect = null;
                        c = null;
                        if (!MjpegViewNative.this.surfaceDone) continue;
                        if (MjpegViewNative.this.bmp == null) {
                            MjpegViewNative.this.bmp = Bitmap.createBitmap((int)MjpegViewNative.this.IMG_WIDTH, (int)MjpegViewNative.this.IMG_HEIGHT, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        }
                        if ((ret = MjpegViewNative.this.mIn.readMjpegFrame(MjpegViewNative.this.bmp)) != -1) break block17;
                        if (c == null) break block18;
                        this.mSurfaceHolder.unlockCanvasAndPost(c);
                    }
                    return;
                }
                try {
                    destRect = this.destRect(MjpegViewNative.this.bmp.getWidth(), MjpegViewNative.this.bmp.getHeight());
                    c = this.mSurfaceHolder.lockCanvas();
                    SurfaceHolder surfaceHolder = this.mSurfaceHolder;
                    synchronized (surfaceHolder) {
                        if (MjpegViewNative.this.transparentBackground) {
                            c.drawColor(0, PorterDuff.Mode.CLEAR);
                        } else {
                            c.drawColor(MjpegViewNative.this.backgroundColor);
                        }
                        c.drawBitmap(MjpegViewNative.this.bmp, null, destRect, p);
                        if (MjpegViewNative.this.showFps) {
                            p.setXfermode((Xfermode)mode);
                            if (ovl != null) {
                                int height = (MjpegViewNative.this.ovlPos & 1) == 1 ? destRect.top : destRect.bottom - ovl.getHeight();
                                int width = (MjpegViewNative.this.ovlPos & 8) == 8 ? destRect.left : destRect.right - ovl.getWidth();
                                c.drawBitmap(ovl, (float)width, (float)height, null);
                            }
                            p.setXfermode(null);
                            ++this.frameCounter;
                            if (System.currentTimeMillis() - this.start >= 1000L) {
                                this.fps = String.valueOf(this.frameCounter) + "fps";
                                this.frameCounter = 0;
                                this.start = System.currentTimeMillis();
                                if (ovl != null) {
                                    ovl.recycle();
                                }
                                ovl = this.makeFpsOverlay(MjpegViewNative.this.overlayPaint);
                            }
                        }
                    }
                    if (c == null) continue;
                }
                catch (IOException iOException) {
                    if (c == null) continue;
                    this.mSurfaceHolder.unlockCanvasAndPost(c);
                    continue;
                    catch (Throwable throwable) {
                        if (c != null) {
                            this.mSurfaceHolder.unlockCanvasAndPost(c);
                        }
                        throw throwable;
                    }
                }
                this.mSurfaceHolder.unlockCanvasAndPost(c);
            }
        }
    }
}

