/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.github.niqdev.mjpeg.MjpegInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MjpegInputStreamNative
extends MjpegInputStream {
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOF_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length";
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 200000;
    private int mContentLength = -1;
    byte[] header = null;
    byte[] frameData = null;
    int headerLen = -1;
    int headerLenPrev = -1;
    int skip = 1;
    int count = 0;
    private static final String TAG = "MJPEG";
    private static final boolean DEBUG = false;

    public native int pixeltobmp(byte[] var1, int var2, Bitmap var3);

    public native void freeCameraMemory();

    MjpegInputStreamNative(InputStream in) {
        super(new BufferedInputStream(in, 200000));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        int seqIndex = 0;
        for (int i = 0; i < 200000; ++i) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[seqIndex]) {
                if (++seqIndex != sequence.length) continue;
                return i + 1;
            }
            seqIndex = 0;
        }
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int getEndOfSeqeunceSimplified(DataInputStream in, byte[] sequence) throws IOException {
        int startPos = this.mContentLength / 2;
        int endPos = 3 * this.mContentLength / 2;
        this.skipBytes(this.headerLen + startPos);
        int seqIndex = 0;
        for (int i = 0; i < endPos - startPos; ++i) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[seqIndex]) {
                if (++seqIndex != sequence.length) continue;
                return this.headerLen + startPos + i + 1;
            }
            seqIndex = 0;
        }
        return -1;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException, IllegalArgumentException {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(headerBytes);
        Properties props = new Properties();
        props.load(headerIn);
        return Integer.parseInt(props.getProperty("Content-Length"));
    }

    private Bitmap readMjpegFrame() throws IOException {
        int headerLen;
        this.mark(200000);
        try {
            headerLen = this.getStartOfSequence(this, this.SOI_MARKER);
        }
        catch (IOException e) {
            this.reset();
            return null;
        }
        this.reset();
        if (this.header == null || headerLen != this.headerLenPrev) {
            this.header = new byte[headerLen];
        }
        this.headerLenPrev = headerLen;
        this.readFully(this.header);
        int ContentLengthNew = -1;
        try {
            ContentLengthNew = this.parseContentLength(this.header);
        }
        catch (NumberFormatException nfe) {
            ContentLengthNew = this.getEndOfSeqeunceSimplified(this, this.EOF_MARKER);
            if (ContentLengthNew < 0) {
                this.reset();
                ContentLengthNew = this.getEndOfSeqeunce(this, this.EOF_MARKER);
            }
        }
        catch (IllegalArgumentException e) {
            ContentLengthNew = this.getEndOfSeqeunceSimplified(this, this.EOF_MARKER);
            if (ContentLengthNew < 0) {
                this.reset();
                ContentLengthNew = this.getEndOfSeqeunce(this, this.EOF_MARKER);
            }
        }
        catch (IOException e) {
            this.reset();
            return null;
        }
        this.mContentLength = ContentLengthNew;
        this.reset();
        if (this.frameData == null) {
            this.frameData = new byte[200000];
        }
        if (this.mContentLength + 100 > 200000) {
            this.frameData = new byte[this.mContentLength + 100];
        }
        this.skipBytes(headerLen);
        this.readFully(this.frameData, 0, this.mContentLength);
        if (this.count++ % this.skip == 0) {
            return BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(this.frameData, 0, this.mContentLength));
        }
        return null;
    }

    int readMjpegFrame(Bitmap bmp) throws IOException {
        int headerLen;
        this.mark(200000);
        try {
            headerLen = this.getStartOfSequence(this, this.SOI_MARKER);
        }
        catch (IOException e) {
            this.reset();
            return -1;
        }
        this.reset();
        if (this.header == null || headerLen != this.headerLenPrev) {
            this.header = new byte[headerLen];
        }
        this.headerLenPrev = headerLen;
        this.readFully(this.header);
        int ContentLengthNew = -1;
        try {
            ContentLengthNew = this.parseContentLength(this.header);
        }
        catch (NumberFormatException nfe) {
            ContentLengthNew = this.getEndOfSeqeunceSimplified(this, this.EOF_MARKER);
            if (ContentLengthNew < 0) {
                this.reset();
                ContentLengthNew = this.getEndOfSeqeunce(this, this.EOF_MARKER);
            }
        }
        catch (IllegalArgumentException e) {
            ContentLengthNew = this.getEndOfSeqeunceSimplified(this, this.EOF_MARKER);
            if (ContentLengthNew < 0) {
                this.reset();
                ContentLengthNew = this.getEndOfSeqeunce(this, this.EOF_MARKER);
            }
        }
        catch (IOException e) {
            this.reset();
            return -1;
        }
        this.mContentLength = ContentLengthNew;
        this.reset();
        if (this.frameData == null) {
            this.frameData = new byte[200000];
        }
        if (this.mContentLength + 100 > 200000) {
            this.frameData = new byte[this.mContentLength + 100];
        }
        this.skipBytes(headerLen);
        this.readFully(this.frameData, 0, this.mContentLength);
        if (this.count++ % this.skip == 0) {
            return this.pixeltobmp(this.frameData, this.mContentLength, bmp);
        }
        return 0;
    }

    void setSkip(int s) {
        this.skip = s;
    }

    static {
        System.loadLibrary("ImageProc");
    }
}

