/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.jglfont.impl.format.JGLFontGlyphInfo;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public abstract class JGLAbstractFontData {
    protected JGLFontRenderer renderer;
    protected ResourceLoader resourceLoader;
    protected String name;
    protected Map<Integer, String> bitmaps = new TreeMap<Integer, String>();
    protected int bitmapWidth;
    protected int bitmapHeight;
    protected int lineHeight;
    protected Map<Integer, JGLFontGlyphInfo> characters = new GlyphTable();

    protected JGLAbstractFontData(JGLFontRenderer renderer, ResourceLoader resourceLoader) {
        this.renderer = renderer;
        this.resourceLoader = resourceLoader;
    }

    public JGLFontRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(JGLFontRenderer renderer) {
        this.renderer = renderer;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, String> getBitmaps() {
        return this.bitmaps;
    }

    public void addBitmap(int index, String name) {
        this.bitmaps.put(index, name);
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    public Map<Integer, JGLFontGlyphInfo> getGlyphs() {
        return Collections.unmodifiableMap(this.characters);
    }

    public void addGlyph(Integer codepoint, JGLFontGlyphInfo glyphInfo) {
        this.characters.put(codepoint, glyphInfo);
    }

    public void preProcessGlyph(Integer codepoint) {
    }

    public abstract void init();

    private class GlyphTable
    extends Hashtable<Integer, JGLFontGlyphInfo> {
        private GlyphTable() {
        }

        @Override
        public synchronized JGLFontGlyphInfo get(Object key) {
            if (key instanceof Integer) {
                JGLAbstractFontData.this.preProcessGlyph((Integer)key);
            }
            return (JGLFontGlyphInfo)super.get(key);
        }
    }
}

