/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.xpp3;

import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.xml.tools.BundleInfo;
import de.lessvoid.xml.tools.SpecialValuesReplace;
import de.lessvoid.xml.xpp3.ControlParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xmlpull.v1.XmlPullParser;

public class Attributes {
    private static final String ORIGINAL_VALUE_MARKER = "$$$originalValue->";
    private static final ControlParameter controlParameter = new ControlParameter();
    @Nonnull
    private final Map<String, String> attributes = new HashMap<String, String>();
    @Nonnull
    private final Map<String, Set<String>> taggedAttributes = new HashMap<String, Set<String>>();

    public Attributes() {
    }

    public Attributes(String ... values) {
        this();
        for (int i = 0; i < values.length / 2; ++i) {
            this.attributes.put(values[i * 2], values[i * 2 + 1]);
        }
    }

    public Attributes(@Nonnull XmlPullParser xpp) {
        this();
        int count = xpp.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String key = xpp.getAttributeName(i);
            String value = xpp.getAttributeValue(i);
            this.attributes.put(key, value);
        }
    }

    public Attributes(@Nonnull Attributes source) {
        this();
        this.attributes.putAll(source.attributes);
        this.taggedAttributes.putAll(source.taggedAttributes);
    }

    public void translateSpecialValues(@Nonnull Map<String, BundleInfo> resourceBundle, @Nullable ScreenController screenController, @Nullable Properties globalProperties, @Nullable Locale loc) {
        HashMap<String, String> replacedAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(ORIGINAL_VALUE_MARKER)) {
                replacedAttributes.put(key, value);
                continue;
            }
            String replaced = SpecialValuesReplace.replace(value, resourceBundle, screenController, globalProperties, loc);
            replacedAttributes.put(key, replaced);
            replacedAttributes.put(ORIGINAL_VALUE_MARKER + key, value);
        }
        this.attributes.putAll(replacedAttributes);
    }

    public boolean isSet(@Nonnull String name) {
        return this.get(name) != null;
    }

    @Nullable
    public String get(@Nonnull String name) {
        return this.attributes.get(name);
    }

    @Nonnull
    public String getWithDefault(@Nonnull String name, @Nonnull String defaultValue) {
        String value = this.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Nonnull
    public Properties createProperties() {
        Properties props = new Properties();
        props.putAll(this.attributes);
        return props;
    }

    public boolean getAsBoolean(@Nonnull String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public int getAsInteger(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Requested attribute \"" + name + "\" does not match a value.");
        }
        return Integer.parseInt(value);
    }

    public int getAsInteger(@Nonnull String name, int defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getAsFloat(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Requested attribute \"" + name + "\" does not match a value.");
        }
        return Float.parseFloat(value);
    }

    public float getAsFloat(@Nonnull String name, float defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nullable
    public Color getAsColor(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        return new Color(value);
    }

    public void set(@Nonnull String name, @Nonnull String value) {
        this.setAttribute(name, value);
    }

    public void overwrite(@Nonnull Attributes src) {
        this.attributes.clear();
        this.taggedAttributes.clear();
        this.attributes.putAll(src.attributes);
        this.taggedAttributes.putAll(src.taggedAttributes);
    }

    public void merge(@Nonnull Attributes src) {
        Map<String, String> srcAttributes = src.attributes;
        for (Map.Entry<String, String> srcAttribute : srcAttributes.entrySet()) {
            String srcKey = srcAttribute.getKey();
            if (this.attributes.containsKey(srcKey)) continue;
            this.attributes.put(srcKey, srcAttribute.getValue());
            for (Map.Entry<String, Set<String>> tag : src.taggedAttributes.entrySet()) {
                if (!tag.getValue().contains(srcKey)) continue;
                Set<String> attribForTag = this.taggedAttributes.get(tag.getKey());
                if (attribForTag == null) {
                    attribForTag = new HashSet<String>();
                    this.taggedAttributes.put(tag.getKey(), attribForTag);
                }
                attribForTag.add(srcKey);
            }
        }
    }

    public void mergeAndTag(@Nonnull Attributes src, @Nonnull String tag) {
        for (Map.Entry<String, String> entry : src.attributes.entrySet()) {
            String srcKey = entry.getKey();
            if (this.attributes.containsKey(srcKey)) continue;
            this.setAttribute(srcKey, entry.getValue());
            this.tagAttribute(srcKey, tag);
        }
    }

    private void tagAttribute(@Nonnull String srcKey, @Nonnull String tag) {
        Set<String> attribForTag = this.taggedAttributes.get(tag);
        if (attribForTag == null) {
            attribForTag = new HashSet<String>();
            this.taggedAttributes.put(tag, attribForTag);
        }
        attribForTag.add(srcKey);
    }

    public void refreshFromAttributes(@Nonnull Attributes src) {
        Map<String, String> srcAttributes = src.attributes;
        for (Map.Entry<String, String> srcAttribute : srcAttributes.entrySet()) {
            String srcKey = srcAttribute.getKey();
            String srcValue = srcAttribute.getValue();
            if (srcValue.equals("")) {
                this.attributes.remove(srcKey);
                continue;
            }
            this.attributes.put(srcKey, srcAttributes.get(srcKey));
        }
    }

    private void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Nonnull
    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String key : this.attributes.keySet()) {
            if (!first) {
                result.append(", ");
            }
            if (first) {
                first = false;
            }
            result.append(key).append(" => ").append(this.attributes.get(key));
            String tag = this.resolveTag(key);
            if (tag == null) continue;
            result.append(" {").append(tag).append("}");
        }
        return result.toString();
    }

    @Nullable
    private String resolveTag(String key) {
        for (Map.Entry<String, Set<String>> tag : this.taggedAttributes.entrySet()) {
            if (!tag.getValue().contains(key)) continue;
            return tag.getKey();
        }
        return null;
    }

    @Nonnull
    public List<Parameter> extractParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!this.isParameterDefinition(value)) continue;
            parameters.add(new Parameter(value, controlParameter.extractParameter(value), key));
        }
        return parameters;
    }

    private boolean isParameterDefinition(@Nonnull String value) {
        return controlParameter.isParameter(value);
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void remove(String key) {
        this.attributes.remove(key);
    }

    @Nullable
    public String getWithTag(String name, String tag) {
        Set<String> attributesWithTag = this.taggedAttributes.get(tag);
        if (attributesWithTag == null) {
            return null;
        }
        if (!attributesWithTag.contains(name)) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void resolveParameters(@Nonnull Attributes attributes) {
        List<Parameter> entrySet = this.getParameterSet();
        for (Parameter entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (attributes.isSet(key)) {
                this.set(value, controlParameter.applyParameter(entry.getOriginalValue(), entry.getKey(), attributes.get(key)));
                continue;
            }
            if (this.isSet(key) && !this.isParameterDefinition(this.get(key))) {
                this.set(value, this.get(key));
                continue;
            }
            this.remove(value);
        }
    }

    @Nonnull
    List<Parameter> getParameterSet() {
        return this.extractParameters();
    }

    public void removeWithTag(String tag) {
        Set<String> tagged = this.taggedAttributes.get(tag);
        if (tagged != null) {
            for (String key : tagged) {
                this.remove(key);
            }
        }
    }

    public String getOriginalValue(String key) {
        String value = this.get(ORIGINAL_VALUE_MARKER + key);
        if (value != null) {
            return value;
        }
        return this.get(key);
    }

    public static class Parameter {
        private final String originalValue;
        private final String key;
        private final String value;

        private Parameter(String originalValue, String key, String value) {
            this.originalValue = originalValue;
            this.key = key;
            this.value = value;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

