/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Split {
    private static final String BEGIN_KEY = "${";
    private static final String END_KEY = "}";

    public static boolean containsKey(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return value.contains(BEGIN_KEY);
    }

    @Nonnull
    public static List<String> split(@Nullable String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        String remaining = value;
        int startIdx = 0;
        while ((remaining = remaining.substring(startIdx)).length() != 0) {
            boolean parsingKey = remaining.startsWith(BEGIN_KEY);
            int endIdx = Split.findEndIdx(remaining, parsingKey);
            if (endIdx == -1) {
                result.add(remaining);
                break;
            }
            if (parsingKey) {
                result.add(remaining.substring(0, endIdx + 1));
                startIdx = endIdx + 1;
                continue;
            }
            result.add(remaining.substring(0, endIdx));
            startIdx = endIdx;
        }
        return result;
    }

    @Nonnull
    public static String join(@Nonnull List<String> parts) {
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            result.append(part);
        }
        return result.toString();
    }

    private static int findEndIdx(@Nonnull String remaining, boolean parsingKey) {
        if (parsingKey) {
            return remaining.indexOf(END_KEY);
        }
        return remaining.indexOf(BEGIN_KEY);
    }
}

